// Add-on by Chaz Longstff for MLPV2 by Lear Cale. June 2008.
// Function: gives object to someone on an MLPV2 ball
// MLP button: LINKMSG MyButtonName | 1,-4,987789,NamesOfObjectToOffer##MsgToPerson
 
// In a menu card, format a menu button like this, for example:
// LINKMSG TieMeUp | 1,-4,987789,Cuff1#Cuff2#Cuff3#Cuff4##Wear these four cuffs.
// In this example, TieMeUp is the button name
//     1 means whether to make the MLPV2 menu go away or not.
//       Generally set it to 1 as per the example, as otherwise the user
//       might not see the accept prompt for the inventory being given.
//     -4 is the value of LINK_THIS, meaning, send this message to this prim only.
//       (Use -1 if the ~give script is in a different prim.)
//     987789 -- don't change this, this is the link message number
//     Cuff1#Cuff2#Cuff3#Cuff4##Wear these four cuffs.
//       The items separated by # are the items to give,
//       followed by a message to be instant messaged to the recipient
//       of the object. It's good to include a msg, so that they don't think
//       it's a griefer trying to hand them something. Notice that the list
//       of objects to give and the accompanying msg, are separated by ##
 
default{
   link_message(integer from, integer num, string str, key id) {
       if (num == 987789) {
           list    TempList = llParseStringKeepNulls(str,["##"],[]);
           string  message = llStringTrim(llList2String(TempList, 1),STRING_TRIM);
           string  Objects = llStringTrim(llList2String(TempList, 0),STRING_TRIM);
           list    ObjectsToGive = llParseStringKeepNulls(Objects,["#"],[]);
           integer GiveLength = llGetListLength(ObjectsToGive);
           if (GiveLength != 0) {
               if (message != "") {
                   llInstantMessage(id,message + " " + llList2CSV(ObjectsToGive));
               }
               integer x;
               for (x = 0; x < GiveLength; x++) {
                     string ObjectToGive = llStringTrim(llList2String(ObjectsToGive, x),STRING_TRIM);
                     if ( ( llGetInventoryType(ObjectToGive) != INVENTORY_NONE)
                     &&   ( llGetInventoryPermMask(ObjectToGive, MASK_NEXT) & PERM_COPY) ) {
                         llGiveInventory(id,ObjectToGive);
                     }
                }//end of for
            }//end of checking GiveLength
       } //end of if check for the right channel
   } //end link_message event
} //end default state
