integer number;
string name;
integer choice = 0;
integer glow = TRUE;            // Make the particles glow
integer bounce = FALSE;          // Make particles bounce on Z plane of object
integer interpColor = TRUE;     // Go from start to end color
integer interpSize = FALSE;      // Go from start to end size
integer wind = FALSE;           // Particles affected by wind
integer followSource = TRUE;    // Particles follow the source
integer followVel = FALSE;       // Particles turn to velocity direction
integer pattern = PSYS_SRC_PATTERN_EXPLODE;
key target = "self";
float age = 8;                  // Life of each particle
float maxSpeed = 0;            // Max speed each particle is spit out at
float minSpeed = 0;            // Min speed each particle is spit out at
string texture = "";                 // Texture used for particles, default used if blank
float startAlpha = 1;           // Start alpha (transparency) value
float endAlpha = 0.1;           // End alpha (transparency) value
vector startColor = <1,1,1>;    // Start color of particles <R,G,B>
vector endColor = <1,1,1>;      // End color of particles <R,G,B> (if interpColor == TRUE)
vector startSize = <.3,.3,.3>;     // Start size of particles 
vector endSize = <.3,.3,.3>;       // End size of particles (if interpSize == TRUE)
vector push = <0,0,0>;          // Force pushed on particles
float rate = 1.5;            // How fast (rate) to emit particles
float radius = 0;          // Radius to emit particles for BURST pattern
integer count = 1;        // How many particles to emit per BURST 
float outerAngle = 1.54;    // Outer angle for all ANGLE patterns
float innerAngle = 1.55;    // Inner angle for all ANGLE patterns
vector omega = <0,0,0>;    // Rotation of ANGLE patterns around the source
float life = 0;             // Life in seconds for the system to make particles
 
// Script variables
integer pre = 2;          //Adjust the precision of the generated list.
 
integer flags;
list sys;
integer type;
vector tempVector;
rotation tempRot;
string tempString;
integer i;

updateParticles()
{
    flags = 0;
    target = llGetKey();
    flags=flags | PSYS_PART_EMISSIVE_MASK;
    flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    sys = [  PSYS_PART_MAX_AGE,age,
             PSYS_PART_FLAGS,flags,
             PSYS_PART_START_COLOR, startColor,
             PSYS_PART_END_COLOR, endColor,
             PSYS_PART_START_SCALE,startSize,
             PSYS_PART_END_SCALE,endSize, 
             PSYS_SRC_PATTERN, pattern,
             PSYS_SRC_BURST_RATE,rate,
             PSYS_SRC_ACCEL, push,
             PSYS_SRC_BURST_PART_COUNT,count,
             PSYS_SRC_BURST_RADIUS,radius,
             PSYS_SRC_BURST_SPEED_MIN,minSpeed,
             PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
             PSYS_SRC_TARGET_KEY,target,
             PSYS_SRC_ANGLE_BEGIN,innerAngle, 
             PSYS_SRC_ANGLE_END,outerAngle,
             PSYS_SRC_OMEGA, omega,
             PSYS_SRC_MAX_AGE, life,
             PSYS_SRC_TEXTURE, texture,
             PSYS_PART_START_ALPHA, startAlpha,
             PSYS_PART_END_ALPHA, endAlpha
        ];
 llParticleSystem(sys);

}

default
{
    state_entry()
    {
        llSetTimerEvent(25); //How many seconds inbetween textures
        number = llGetInventoryNumber(INVENTORY_TEXTURE);
        llSetLinkTextureAnim(LINK_THIS, ANIM_ON | SMOOTH | LOOP , ALL_SIDES, 1, 1, 1, 1, .2);
    }
    timer()
    {
        if (choice < number)
        {
            name = llGetInventoryName(INVENTORY_TEXTURE, choice);
            if (name != "")
            //llSetTexture(name, ALL_SIDES);
            texture = name;
            updateParticles();
            choice = choice + 1;
        }
        else
        {
            name = llGetInventoryName(INVENTORY_TEXTURE, choice);
            if (name != "")
            llSetTexture(name, ALL_SIDES);
            choice = 0;
        }
    }
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY) 
        {
            llResetScript();
        }
    }
}