///////////////////////////////////////////////////////////////////////////////
// Builders' Buddy 1.9 (Base Script)
// by Newfie Pendragon, March 2006
//
// This script is distributed with permission that it may be used in
// any way, or may be further modified/included in resale items.
// HOWEVER, if this script is used as part of a for-sale product,
// it is required that appropriate credit be given to Newfie for
// the script (or portions used in derivatives).  That's a fair price
// in exchange for unlimited use of this script, dontcha think?
//
//  SL Forum thread and new versions found here:
//  http://forums.secondlife.com/showthread.php?t=96792
///////////////////////////////////////////////////////////////////////////////
//
//  Script Purpose & Use
//
//  Functions are dependent on the "component script"
//
//  QUICK USE:
//  - Drop this script in the Base.
//  - Drop the "Component" Script in each building part.
//  - Touch  your Base, and choose RECORD
//  - Take all building parts into inventory
//  - Drag building parts from inventory into Base Prim
//  - Touch your base and choose BUILD
//
//  OTHER COMMANDS from the Touch menu
//  - To reposition, move/rotate Base Prim choose POSITION
//  - To lock into position (removes scripts) choose DONE
//  - To delete building pieces: choose CLEAN
//
///////////////////////////////////////////////////////////////////////////////
//
//  History
//
// v1.0 - 20060328 - Newfie Pendragon
//      - Original Version
// v1.1 - 20060331 - Kalidor Lazarno
//      - Added a Dialog Engine to the base script
// v1.5 - 20060612 - Androclese Antonelli
//      - Added a random number generator to the dialog engine to elimintate
//        problems with multiple BB boxes cross-talking
//      - Added a timer to the listen command to put it asleep after 10sec.
//      - Added a Menu Description
//      - Added n "creator" flag so the owner could use the same object with full
//        menu options and only a single flag change
//      - Added an "ingroup" flag to enable/disable the same group use function
//      - Non-Admin usage cleans the inventory items as they spawn
// v1.6 - 20060624 - Newfie Pendragon
//      - Added active repositioning (building moves as the base piece moves)
//      - Added "Reset" Option to unlink parts from base temporarily
//      - Modified creator flag to automatically set based if owner is creator
//      - Minor changes to improve code readability (for those learning LSL)
// v1.8 - 20070429 - Newfie Pendragon
//      - Added a variable to allow a user to tweak how long a listener is open,
//        and changed the default to 30 seconds.
// v1.9 - 20070630 - Newfie Pendragon
//      - Changed to use llRegionSay - no more 96m max distance (same sim)
//      - Changed rez sequence to be less affected by lag/gray goo fence
//      - Timer always on, less code/more reliable
///////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////////////////
// Configurable Settings
 
integer start_param; 
// Channel used by Base Prim to talk to Component Prims
// This channel must be the same one in the component script
// A negative channel is used because it elimited accidental activations
// by an Avatar talking on obscure channels
integer PRIMCHAN = -19775863;    // Channel used by Base Prim to talk to Component Prims;
                                 // ***THIS MUST MATCH IN BOTH SCRIPTS!***
 
integer base_comm_chan_mod = 300;
// Set to TRUE to allow group members to use the dialog menu
// Set to FALSE to disallow group members from using the dialog menu
integer ingroup = TRUE;
 
//Set to FALSE if you dont want the script to say anything while 'working'
integer chatty = TRUE;
 
//How long to listen for a menu response before shutting down the listener
float fListenTime = 30.0;
 
//How often (in seconds) to perform any timed checks
float fTimerRate = 0.25;
 
//How long to sit still before exiting active mode
float fStoppedTime = 30.0;
 
//SL sometimes blocks rezzing to prevent "gray goo" attacks
//How long we wait (seconds) before we assume SL blocked our rez attempt
integer iRezWait = 3;
 
 
///////////////////////////////////////////////////////////////////////////////
// DO NOT EDIT BELOW THIS LINE.... NO.. NOT EVEN THEN
///////////////////////////////////////////////////////////////////////////////
 
//Name each option-these names will be your button names.
string optRecord = "Record";
string optReset = "Reset";
string optBuild = "Build";
string optPos = "Position";
string optClean = "CLEAR";
string optDone = "Done";
 
//Menu option descriptions
string descRecord = ": Record the position of all parts\n";
string descReset = ": Forgets the position of all parts\n";
string descBuild = ": Rez inv. items and position them\n";
string descPos = ": Reposition the parts to a new location\n";
string descClean = ": De-Rez all pieces\n";
string descDone = ": Remove all BB scripts and freeze parts in place.\n";
 
integer MENU_CHANNEL;
integer MENU_HANDLE;
key agent;
key objectowner;
integer group;
string title = "";
list optionlist = [];
integer bMoving;
vector vLastPos;
rotation rLastRot;
integer bRezzing;
integer iListenTimeout = 0;
integer iLastRez = 0;
integer iRezIndex;
//integer bTimerOn = FALSE;
 
//To avoid flooding the sim with a high rate of movements
//(and the resulting mass updates it will bring), we used
// a short throttle to limit ourselves
announce_moved()
{
    llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
    llResetTime();        //Reset our throttle
    vLastPos = llGetPos();
    rLastRot = llGetRot();
    return;
}
 
 
rez_object()
{
    //Rez the object indicated by iRezIndex
    if (llGetInventoryName(INVENTORY_OBJECT, iRezIndex) != "") 
    {
        llRezObject(llGetInventoryName(INVENTORY_OBJECT, iRezIndex), llGetPos(), ZERO_VECTOR, llGetRot(), PRIMCHAN);
        iLastRez = llGetUnixTime();
 
        if(!bRezzing) {
            bRezzing = TRUE;
        //timer_on();
        }
    }
}
 
post_rez_object()
{
    if ( llGetCreator() != llGetOwner() )
        llRemoveInventory(llGetInventoryName(INVENTORY_OBJECT, iRezIndex));
}
 
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
default {
    ///////////////////////////////////////////////////////////////////////////////
    changed(integer change) {
        if(change & CHANGED_OWNER)
        llResetScript();
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    state_entry () {
        //Use which menu?
            //Display all options
            optionlist = [optPos, optClean, optDone, optRecord, optReset, optBuild];
            title = optRecord + descRecord;
            title += optReset + descReset;
            title += optBuild + descBuild;
            title += optPos + descPos;
            title += optClean + descClean;
            title += optDone + descDone;
 
        //Record our position
        vLastPos = llGetPos();
        rLastRot = llGetRot();
        llListen(0, "", llGetOwner(),"");
        llSetTimerEvent(fTimerRate);
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    touch_start (integer total_number) {
        group = llDetectedGroup(0); // Is the Agent in the objowners group?
        agent = llDetectedKey(0); // Agent's key
        objectowner = llGetOwner(); // objowners key
        // is the Agent = the owner OR is the agent in the owners group
        if ( (objectowner == agent) || ( group && ingroup ))
          {
            iListenTimeout = llGetUnixTime() + llFloor(fListenTime);
            MENU_CHANNEL = llFloor(llFrand(-99999.0 - -100));
            MENU_HANDLE = llListen(MENU_CHANNEL,"","","");
            llDialog(agent, title, optionlist, MENU_CHANNEL);
            //timer_on();
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    listen(integer channel, string name, key id, string message) {
        if ( message == optRecord ) {
            llOwnerSay("Recording positions...");
            llRegionSay(PRIMCHAN, "RECORD " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            if (start_param == 0 || start_param == -4712)
            {
                
                llRegionSay(-19730611, "RECORD " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            }
            return;
        }
        if( message == optReset ) {
            llOwnerSay("Forgetting positions...");
            llRegionSay(PRIMCHAN, "RESET");
            return;
        }
        if ( message == optBuild ) {
            if(chatty) llOwnerSay("Rezzing build pieces...");
            iRezIndex = llGetInventoryNumber(INVENTORY_OBJECT) - 1;
            rez_object();
            return;
        }
        if ( message == optPos ) {
            if(chatty) llOwnerSay("Positioning");
            vector vThisPos = llGetPos();
            rotation rThisRot = llGetRot();
            llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ vThisPos, rThisRot ], "|"));
            return;
        }
        if ( message == optClean ) {
            llRegionSay(PRIMCHAN, "CLEAN");
            llDie();
            return;
        }
        if ( message == optDone ) {
            llRegionSay(PRIMCHAN, "DONE");
            if(chatty) llOwnerSay("Removing Builder's Buddy scripts.");
            return;
        }
        if ( message == "clean" ) {
            llRegionSay(PRIMCHAN, "CLEAN");
            llDie();
            return;
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    moving_start()
    {
        if( !bMoving )
        {
            bMoving = TRUE;
            //timer_on();
            announce_moved();
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    object_rez(key id) {
        //The object rezzed, perform any post-rez processing
        post_rez_object();
 
        //Move on to the next object
        //Loop through backwards (safety precaution in case of inventory change)
        iRezIndex--;
        if(iRezIndex >= 0) {
            //Attempt to rez it
            rez_object();
 
        } else {
            //Rezzing complete, now positioning
            iLastRez = 0;
            bRezzing = FALSE;
            if(chatty) llOwnerSay("Positioning");
            llSleep(2);
            llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            llSleep(2);
            if (start_param != 0) llDie();
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    timer() {
        //Did we change position/rotation?
        if( (llGetRot() != rLastRot) || (llGetPos() != vLastPos) )
        {
            if( llGetTime() > fTimerRate ) {
                announce_moved();
            }
        }
 
        //Are we rezzing?
        if(bRezzing) {
            //Did the last one take too long?
            if((llGetUnixTime() - iLastRez) >= iRezWait) {
                //Yes, retry it
                if(chatty) llOwnerSay("Reattempting rez of most recent piece");
                rez_object();
            }
        }
 
        //Open listener?
        if( iListenTimeout != 0 )
        {
            //Past our close timeout?
            if( iListenTimeout <= llGetUnixTime() )
            {
                iListenTimeout = 0;
                llListenRemove(MENU_HANDLE);
            }
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    on_rez(integer iStart)
    {
        //Reset ourselves
//        llResetScript();
//            if(chatty) llOwnerSay("Rezzing build pieces...");
            start_param= iStart;
            iRezIndex = llGetInventoryNumber(INVENTORY_OBJECT) - 1;
            if (start_param != -4712)
            {
                llSetAlpha(0,ALL_SIDES);
//                PRIMCHAN = iStart;
//                if (PRIMCHAN == 0)
//                {
//                    integer random_max = (integer)llFrand(120000.0);
//                    while (random_max < 90000)
//                    {
//                        random_max = (integer)llFrand(120000.0);
//                    }
//                    base_comm_chan_mod = base_comm_chan_mod + random_max;
//                    base_comm_chan_mod = base_comm_chan_mod - (base_comm_chan_mod * 2);
//                    PRIMCHAN = base_comm_chan_mod;
//                    llSetAlpha(1,ALL_SIDES);
//                }
            rez_object();
            llListen(PRIMCHAN, "","","CLEAN");
            }
            else
            {
                llSetAlpha(1,ALL_SIDES);
            }
            return;
    }
}
 