/* ************************************************************************** */
//
// tl BodyController script [FEET LAYER]
// 
// by Thai Low @ endivatomic.eu:8002
//
// Provided under Creative Commons Attribution-Non-Commercial-ShareAlike 4.0 
//                International license.
//
// Please be sure you read and adhere to the terms of this license: 
//      https://creativecommons.org/licenses/by-nc-sa/4.0/
//
/* ************************************************************************** */
// IMPORTANT NOTE: 
//          I only made the controller (this script) and the related HUD,
//          NOT the bodymesh where you may found this script inside. 
//          The right to copy and use any components (mesh,textures,etc...)
//          apart this script, are all reserved to the related builders.
//                                                      Thai Low
/* ************************************************************************** */

// -------------------------------------------------------------------------
//  module variables/constants
// -------------------------------------------------------------------------
integer CHOFFS  = 101;
string LAYER    = "SK";
string LAYERLOW = "SL";
string FEET     = "FEET";
string SOCKS    = "SOCKS";
string MODULE   = "FEET";

integer TMCD = 40;

integer mFeet0 = -1;
integer mFeet1 = -1;
integer mFeet2 = -1;


// -------------------------------------------------------------------------
//  common Helpers
// -------------------------------------------------------------------------
// --- Get a unique channel number (nearly unique)
integer getOwnerChannel() {  
  return 0x80000000 | (integer)("0x"+llGetSubString((string)llGetOwner(),-7,-1));
}  

// -------------------------------------------------------------------------
//  module functions
// -------------------------------------------------------------------------
initLinks() {
        
  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {        
    string name = llGetLinkName( lnk );      
    if (name == "FEET0") mFeet0 = lnk;
    else if (name == "FEET1") mFeet1 = lnk;
    else if (name == "FEET2") mFeet2 = lnk;
  }
}

// --- set color to all layer
setColor( vector col ) {
  llSetLinkColor( mFeet0, col, 1 );   
  llSetLinkColor( mFeet1, col, 1 );   
  llSetLinkColor( mFeet2, col, 1 );   
}

setTexture( key tid ) {      
  llSetLinkPrimitiveParamsFast( mFeet0, [PRIM_TEXTURE, 1, tid, <1,1,0>, <0,0,0>, 0] );    
  llSetLinkPrimitiveParamsFast( mFeet1, [PRIM_TEXTURE, 1, tid, <1,1,0>, <0,0,0>, 0] );    
  llSetLinkPrimitiveParamsFast( mFeet2, [PRIM_TEXTURE, 1, tid, <1,1,0>, <0,0,0>, 0] );            
}

setNailTexture( key tid ) {      
  llSetLinkPrimitiveParamsFast( mFeet0, [PRIM_TEXTURE, 0, tid, <1,1,0>, <0,0,0>, 0] );        
  llSetLinkPrimitiveParamsFast( mFeet1, [PRIM_TEXTURE, 0, tid, <1,1,0>, <0,0,0>, 0] );        
  llSetLinkPrimitiveParamsFast( mFeet2, [PRIM_TEXTURE, 0, tid, <1,1,0>, <0,0,0>, 0] );        
}

setNailColor( vector col ) {  
  llSetLinkColor( mFeet0, col, 0 );   
  llSetLinkColor( mFeet1, col, 0 );   
  llSetLinkColor( mFeet2, col, 0 );   
}

setPose( integer pose ) {  
  llSetTimerEvent(0); 
  
  integer lnk = getPose();  
  integer  so = FALSE;
  if (lnk != -1) {      
    if (llList2Float( llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, 2 ]), 1 ) > 0.1) so = TRUE;          
  }
  
  if (pose == 0) { 
    llSetLinkAlpha( mFeet1, 0., -1 );   
    llSetLinkAlpha( mFeet2, 0., -1 );   
    llSetLinkAlpha( mFeet0, 1., 0 );      
    llSetLinkAlpha( mFeet0, 1., 1 );      
    if (so) llSetLinkAlpha( mFeet0, 1., 2 );   
  }
  else if (pose == 1) { 
    llSetLinkAlpha( mFeet0, 0., -1 );   
    llSetLinkAlpha( mFeet2, 0., -1 );       
    llSetLinkAlpha( mFeet1, 1., 0 );      
    llSetLinkAlpha( mFeet1, 1., 1 );      
    if (so) llSetLinkAlpha( mFeet1, 1., 2 );       
  }  
  else if (pose == 2) { 
    llSetLinkAlpha( mFeet0, 0., -1 );   
    llSetLinkAlpha( mFeet1, 0., -1 );   
    llSetLinkAlpha( mFeet2, 1., 0 );      
    llSetLinkAlpha( mFeet2, 1., 1 );      
    if (so) llSetLinkAlpha( mFeet2, 1., 2 );   
  } 
  else {
    llSetLinkAlpha( mFeet0, 0., -1 );   
    llSetLinkAlpha( mFeet1, 0., -1 );   
    llSetLinkAlpha( mFeet2, 0., -1 );         
    llSetTimerEvent(TMCD);
  }   
}

integer getPose() {
  if (llList2Float( llGetLinkPrimitiveParams(mFeet0, [ PRIM_COLOR, 1 ]), 1 ) > 0.1) return mFeet0;
  if (llList2Float( llGetLinkPrimitiveParams(mFeet1, [ PRIM_COLOR, 1 ]), 1 ) > 0.1) return mFeet1;  
  if (llList2Float( llGetLinkPrimitiveParams(mFeet2, [ PRIM_COLOR, 1 ]), 1 ) > 0.1) return mFeet2;
  return -1;
}

switchSocks() { 
  integer lnk = getPose();
  if (lnk == -1) return;

  float alpha = 0;
  if (llList2Float( llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, 2 ]), 1 ) < 0.1) alpha = 1.;   
  llSetLinkAlpha( lnk, alpha, 2 );      
}

setSocksTexture( key tid ) {      
  llSetLinkPrimitiveParamsFast( mFeet0, [PRIM_TEXTURE, 2, tid, <1,1,0>, <0,0,0>, 0] );        
  llSetLinkPrimitiveParamsFast( mFeet1, [PRIM_TEXTURE, 2, tid, <1,1,0>, <0,0,0>, 0] );        
  llSetLinkPrimitiveParamsFast( mFeet2, [PRIM_TEXTURE, 2, tid, <1,1,0>, <0,0,0>, 0] );          
}

// -------------------------------------------------------------------------
//  default Events cycle
// -------------------------------------------------------------------------
default {
    
  state_entry() {
    initLinks();   
    llListen( getOwnerChannel() + CHOFFS, "", NULL_KEY, "" );     
  }
  
  changed(integer mask) { if ( mask & CHANGED_OWNER ) llResetScript(); }  
  on_rez(integer par) { llResetScript(); }  
  
  listen( integer ch, string name, key id, string msg ) {               
    list    par = llParseString2List( msg, ["|"], [] );    
    string dest = llList2String( par, 0 );        
    string  cmd = llList2String( par, 1 );        
   
    if (dest == LAYER && cmd == "col" ) { 
      setColor(llList2Vector( par, 2 )); 
    }           
    else if (dest == LAYERLOW && cmd == "txt") { 
      setTexture( llList2Key( par, 2 ) ); 
    } 
    else if (dest == FEET) {    
      if (cmd == "txt") setNailTexture( llList2Key( par, 2 ) );      
      else if (cmd == "col") setNailColor( llList2Vector( par, 2 ) );      
      else if (cmd == "pose") setPose( llList2Integer( par, 2 ) );                      
    } 
    else if (dest == SOCKS) {
      if (cmd == "txt") setSocksTexture( llList2Key( par, 2 ) );      
      else if (cmd == "switch") switchSocks();
    } 
  }
  
  timer() {    
    llSetTimerEvent(0);  
    llRequestPermissions(llGetOwner(), PERMISSION_ATTACH );
  }
  
  run_time_permissions(integer perm) {
    if(perm & PERMISSION_ATTACH) llDetachFromAvatar();        
  }  
} 