
float forward_power = 5; //Power used to go forward (1 to 30)
float reverse_power = -5; //Power ued to go reverse (-1 to -30)
float turning_ratio = .6; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
string sit_message = "Drive"; //Sit message
string not_owner_message = "You are not the owner of this vehicle ..."; //Not owner message

integer shouldDie = 0;
float speedmult=1.;
integer treading=0;
//Anything past this point should only be modfied if you know what you are doing
key Seated = NULL_KEY;

psystem()
{
     llLinkParticleSystem(2,
        [
            PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_EXPLODE,
            PSYS_SRC_BURST_RADIUS,.1,
            PSYS_SRC_ANGLE_BEGIN,-1,
            PSYS_SRC_ANGLE_END,1,
            PSYS_SRC_TARGET_KEY,llGetKey(),
            PSYS_PART_START_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_START_ALPHA,.6,
            PSYS_PART_END_ALPHA,0,
            PSYS_PART_START_GLOW,0,
            PSYS_PART_END_GLOW,0,
            PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
            PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
            PSYS_PART_START_SCALE,<2.30000,2.00000,0.000000>,
            PSYS_PART_END_SCALE,<1,1, 0.000000>,
            PSYS_SRC_TEXTURE,"3a7ea058-e486-4d21-b2e6-8b47462bb45b",
            PSYS_SRC_MAX_AGE,0,
            PSYS_PART_MAX_AGE,4,
            PSYS_SRC_BURST_RATE,0.05,
            PSYS_SRC_BURST_PART_COUNT,1,
            PSYS_SRC_ACCEL,<0.000000,0.000000,-1.500000>,
            PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
            PSYS_SRC_BURST_SPEED_MIN,0.7,
            PSYS_SRC_BURST_SPEED_MAX,0.8,
            PSYS_PART_FLAGS,
                0 |
                PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_BOUNCE_MASK
        ]);
}



init() {
        
        // forward-back,left-right,updown
        //llSitTarget(<2.6, .2, .7>, ZERO_ROTATION );
        llSetCameraEyeOffset(<-10, 1.0, 5.0>);
        
        
        //llSetCameraAtOffset(<1.0, 0.0, 2.0>);
        llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        //llPreloadSound("boat_start");
        //llPreloadSound("boat_run");
            llSetVehicleFlags(0);
        llSetVehicleType(VEHICLE_TYPE_BOAT);
        llSetVehicleFlags(VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_HOVER_WATER_ONLY);
        llSetVehicleVectorParam( VEHICLE_LINEAR_FRICTION_TIMESCALE, <.9, .9, 1> );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_FRICTION_TIMESCALE, 100. );

        
        
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, 0, 0>);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 1.5);
        
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_TIMESCALE, 1. );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 1 );
        
        llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, 8.7);
        llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 3.0 );
        llSetVehicleFloatParam( VEHICLE_BUOYANCY, 1 );
        
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3 );
        
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_TIMESCALE,  6.1);
        
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, .1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, 3.5 );
        llSetVehicleRotationParam( VEHICLE_REFERENCE_FRAME, ZERO_ROTATION );
        shouldDie = 1;
        llSetTimerEvent(300);
}


string curanim;

default
{
    
    on_rez(integer n)
    {
        llResetScript();   
    }
    
    state_entry()
    {
        init();
    }
    
    changed(integer change)
    {
        
        
        if (change & CHANGED_LINK)
        {
            
            key agent = llAvatarOnLinkSitTarget(1);
            if (agent != NULL_KEY && Seated == NULL_KEY)
            {
                    llRequestPermissions(agent, PERMISSION_TAKE_CONTROLS);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    shouldDie = 0;
                    Seated =agent;
            }
            else if (agent == NULL_KEY)
            {
                Seated = NULL_KEY;
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSleep(.2);
                llReleaseControls();
                llTargetOmega(<0,0,0>,PI,0);
                vector v = llRot2Euler(llGetRot())  ;
                v.x=0; v.y=0;
                llSetRot( llEuler2Rot(v) ) ;
                llSetTimerEvent(300);
            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
        }
            
    }

    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
//        vector vel = llGetVel();
        //float speed = llVecMag(vel);

        float speed = llGetVel()*(<1,0,0>*llGetRot());
        //car controls
        integer swim=0;
        
        if(level & CONTROL_UP)
        {
            speedmult = 2.0;
        }
        else if(level & CONTROL_DOWN)
        {
            speedmult = 1.0;
        }
        
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <speedmult * forward_power,0,0>);
            reverse=1;
            swim=1;
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
            swim=1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= speed / turning_ratio * reverse;
            angular_motor.x += 8;
            swim=1;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += speed / turning_ratio * reverse;
            angular_motor.x -= 8;
            swim=1;
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
       
        string an;
        if (swim )
        {
            an = "raftrow";
        }
        else 
        {
            an = "stand1";
        }
            
        if (an != curanim)
        {
            
            //llStopAnimation(curanim);
            curanim = an;
            if (curanim == "stand1" || curanim == "float")
            {
                 //if (curanim == "tread")
                 //   llSetLinkPrimitiveParams(3,[PRIM_POS_LOCAL, <0.0, 0.0, -0.55>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                 //else
                 //   llSetLinkPrimitiveParams(3,[PRIM_POS_LOCAL, <0.0, 0.0, 0.7>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                        
                llLinkParticleSystem(2,[]);
                llStopSound();
            }
            else
            {
                //llSetLinkPrimitiveParamsFast(3,[PRIM_POS_LOCAL, <0.0, 0.0, -0.26>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                psystem();
                llLoopSound("paddle", 1.0);
            }
            //llStartAnimation(curanim);
         }


    } //end control   
    
    timer()
    {
            if (llAvatarOnLinkSitTarget(1) == NULL_KEY) llDie();
        
    }
    
}  