// ----------------------------------------------------------------------------------
// nPose Menu 2.0 OSGrid JE 001
// ----------------------------------------------------------------------------------
// Changes:
// ----------------------------------------------------------------------------------
// Version JE 001
// - skip menu when called from sequencer
// ----------------------------------------------------------------------------------

integer RESET               = -950;

string Permissions = "PUBLIC";
string curmenuonsit = "off";
string cur2default = "off";
string Facials = "on";
string menuReqSit = "off";
string RLVenabled = "on";

string MAGIC = "nomenu";

list victims;
string path;
list slots;
string defaultPoseNcName;
string menuNC = ".Change Menu Order";
list slotbuttons = [];

list menus;
list menuPermPath;
list menuPermPerms;
float currentOffsetDelta = 0.2;
float menuDistance = 30.0;

key scriptID;

//#line 69 "C:\\Program Files\\Firestorm-Releasex64\\nPose Menu 2.0 OSGrid"
list offsetbuttons = ["forward", "left", "up", "backward", "right", "down", "0.2", "0.1", "0.05", "0.01", "reset"];


//#line 86 "C:\\Program Files\\Firestorm-Releasex64\\nPose Menu 2.0 OSGrid"
list adminbuttons = ["Adjust", "StopAdjust", "PosDump", "Unsit", "Options"];



//#line 96 "C:\\Program Files\\Firestorm-Releasex64\\nPose Menu 2.0 OSGrid"
list pluginPermissionList;

integer logicalXor(integer conditionA, integer conditionB) {

    return(conditionA && !conditionB) || (!conditionA && conditionB);
}

integer isAllowed(key rcpt, string permissions) {
    permissions=llStringTrim(permissions, STRING_TRIM);
    if(permissions=="") {
        return TRUE;
    }
    else {
        list permItemsOr=llParseString2List(llToLower(permissions), ["~"], []);
        integer indexOr=~llGetListLength(permItemsOr);
        integer result;
        while(++indexOr && !result) {
            list permItemsAnd=llParseString2List(llList2String(permItemsOr, indexOr), ["&"], []);
            integer indexAnd=~llGetListLength(permItemsAnd);
            result=TRUE;
            while(++indexAnd && result) {
                integer invert;
                string item=llStringTrim(llList2String(permItemsAnd, indexAnd), STRING_TRIM);
                if(llGetSubString(item, 0, 0)=="!") {
                    invert=TRUE;
                    item=llStringTrim(llDeleteSubString(item, 0, 0), STRING_TRIM);
                }
                if(item=="group") {
                    result=logicalXor(invert, llSameGroup(rcpt));
                }
                else if(item=="owner") {
                    result=logicalXor(invert, llGetOwner()==rcpt);
                }
                else if(item=="seated") {
                    result=logicalXor(invert, ~llListFindList(slots, [rcpt]));
                }
                else if((string)((integer)item)==item){

                    integer slotIndex=llListFindList(slots, [rcpt]);
                    integer z=llSubStringIndex(llList2String(slots, slotIndex + 1), "§");
                    string seatNumber=llGetSubString(llList2String(slots, slotIndex + 1), z+5,-1);
                    result=logicalXor(invert, item==seatNumber);
                }
                else {

                    integer pluginPermissionIndex=llListFindList(pluginPermissionList, [item]);
                    if(~pluginPermissionIndex) {

                        string pluginPermissionType=llList2String(pluginPermissionList, pluginPermissionIndex+1);
                        if(pluginPermissionType=="list")
                        {
                            result=logicalXor(invert, ~llSubStringIndex(llList2String(pluginPermissionList, pluginPermissionIndex+2), (string)rcpt));
                        }
                        else if(pluginPermissionType=="bool")
                        {
                            result=logicalXor(invert, (integer)llList2String(pluginPermissionList, pluginPermissionIndex+2));
                        }
                        else
                        {
                            result=invert;
                        }
                    }
                    else
                    {
                        result=invert;
                    }
                }
            }
        }
        return result;
    }
}

DoMenu(key toucher, string path, string menuPrompt, integer page) {
    integer index = llListFindList(menus, [path]);
    if(~index) {
        list buttons = llParseStringKeepNulls(llList2String(menus, index+1), ["|"], []);
        list tmp = [];
        if(path != "Main") {
            tmp += ["^"];
        }

        Dialog(toucher, menuPrompt + "\n"+path+"\n", buttons, tmp, page, path);
    }
}

//#line 104 "C:\\Program Files\\Firestorm-Releasex64\\nPose Menu 2.0 OSGrid"
Dialog(key rcpt, string prompt, list choices, list utilitybuttons, integer page, string Path)
{
    if((rcpt == llGetOwner() || Permissions == "GROUP" && llSameGroup(rcpt) || Permissions == "PUBLIC") &&
        (rcpt == llGetOwner() || menuReqSit == "off" || ~llListFindList(slots, [rcpt])) &&

            (rcpt == llGetOwner() || !~llListFindList(victims, [(string)rcpt])) )
            {
                list thisMenuPath=llDeleteSubList(llParseStringKeepNulls(Path , [":"], []), 0, 0);

                list tempPath=thisMenuPath;
                do {
                    integer indexc=llListFindList(menuPermPath, [llDumpList2String(tempPath, ":")]);
                    if(~indexc) {
                        if(!isAllowed(rcpt, llList2String(menuPermPerms, indexc))) {
                            return;
                        }
                    }
                    tempPath=llDeleteSubList(tempPath, -1, -1);
                }
                while (llGetListLength(tempPath));

                integer stopc = llGetListLength(choices);
                integer nc;
                for(; nc < stopc; ++nc) {
                    integer indexc = llListFindList(menuPermPath, [llDumpList2String(thisMenuPath + [llList2String(choices, nc)], ":")]);
                    if(indexc != -1) {
                        if(!isAllowed(rcpt, llList2String(menuPermPerms, indexc))) {
                            choices = llDeleteSubList(choices, nc, nc);
                            --nc;
                            --stopc;
                        }
                    }
                }
                llMessageLinked(LINK_SET, -900, (string)rcpt + "|" + prompt + "|" + (string)page +
                    "|" + llDumpList2String(choices, "`") + "|" + llDumpList2String(utilitybuttons, "`") + "|" + Path, scriptID);
            }
}

BuildMenus(list cardNames) {
    menus = [];
    menuPermPath = [];
    menuPermPerms = [];
    integer stop = llGetListLength(cardNames);
    integer fromContents;
    if(!stop) {
        fromContents = TRUE;
        stop = llGetInventoryNumber(INVENTORY_NOTECARD);
    }
    integer defaultSet;
    integer n;
    for(; n<stop; ++n) {
        string name = llList2String(cardNames, n);
        if(fromContents) {
            name = llGetInventoryName(INVENTORY_NOTECARD, n);
        }
        integer permsIndex1 = llSubStringIndex(name,"{");
        integer permsIndex2 = llSubStringIndex(name,"}");
        string menuPerms;
        if(~permsIndex1) {
            menuPerms = llGetSubString(name, permsIndex1+1, permsIndex2+-1);
            name = llDeleteSubString(name, permsIndex1, permsIndex2);
        }
        list pathParts = llParseStringKeepNulls(name, [":"], []);
        string prefix = llList2String(pathParts, 0);
        if((!defaultSet && prefix == "SET") | (prefix == "DEFAULT")) {
            if(!fromContents) {
                defaultPoseNcName = llList2String(cardNames, n);
            }
            else {
                defaultPoseNcName = llGetInventoryName(INVENTORY_NOTECARD, n);
            }
            defaultSet = TRUE;
        }
        pathParts = llListReplaceList(pathParts, ["Main"], 0, 0);
        if(menuPerms) {
            menuPermPath += llDumpList2String(llDeleteSubList(pathParts, 0, 0), ":");
            menuPermPerms += menuPerms;
        }
        if(~llListFindList(["SET", "DEFAULT", "BTN"], [prefix])) {
            pathParts = llDeleteSubList(pathParts, 0, 0);
            while(llGetListLength(pathParts)) {
                string last = llList2String(pathParts, -1);
                string parentpath = llDumpList2String(["Main"] + llDeleteSubList(pathParts, -1, -1), ":");
                integer index = llListFindList(menus, [parentpath]);
                if(index != -1 && !(index & 1)) {
                    list children = llParseStringKeepNulls(llList2String(menus, index + 1), ["|"], []);
                    if(!~llListFindList(children, [last])) {
                        children += [last];
                        if(llGetInventoryType(menuNC) != INVENTORY_NOTECARD) {
                            children = llListSort(children, 1, 1);
                        }
                        menus = llListReplaceList(menus, [llDumpList2String(children, "|")], index + 1, index + 1);
                    }
                }
                else {
                    menus += [parentpath, last];
                }
                pathParts = llDeleteSubList(pathParts, -1, -1);
            }
        }
    }
}

AdminMenu(key toucher, string path, string prompt, list buttons) {

    Dialog(toucher, prompt+"\n"+path+"\n", buttons, ["^"], 0, path);
}

AdjustOffsetDirection(key id, vector direction) {
    vector delta = direction * currentOffsetDelta;
    llMessageLinked(LINK_SET, 208, (string)delta, id);
}

default{
    state_entry() {
        scriptID=llGetInventoryKey(llGetScriptName());
        if(llGetInventoryType(menuNC) != INVENTORY_NOTECARD) {
            BuildMenus([]);
        }
        else {
            llSleep(1.0);
            llMessageLinked(LINK_SET, 224, menuNC, scriptID);
        }
    }

    touch_start(integer total_number) {
        key toucherKey = llDetectedKey(0);
        vector vDelta = llDetectedPos(0) - llGetPos();
        if(toucherKey == llGetOwner() || llVecMag(vDelta) < menuDistance) {
            DoMenu(toucherKey, "Main", "", 0);
        }
    }

    link_message(integer sender, integer num, string str, key id) {
        integer index;
        integer n;
        integer stop;
        if(str == "menuUP") {
            llMessageLinked(LINK_SET, -802, "PATH=" + path, id);
        }
        if(num == -901 && id == scriptID) {
            list params = llParseString2List(str, ["|"], []);
            integer page = (integer)llList2String(params, 0);
            string selection = llList2String(params, 1);
            key toucherid = llList2Key(params, 2);
            path = llList2String(params, 3);

            if(selection == "^")
            {
                list pathparts = llParseString2List(path, [":"], []);
                pathparts = llDeleteSubList(pathparts, -1, -1);
                if(llList2String(pathparts, -1) == "admin")
                {
                    AdminMenu(toucherid, llDumpList2String(pathparts, ":"), "", adminbuttons);
                }
                else if(llGetListLength(pathparts) <= 1)
                {
                    DoMenu(toucherid, "Main", "", 0);
                }
                else {

                    DoMenu(toucherid, llDumpList2String(pathparts, ":"), "", 0);
                }
            }
            else if(selection == "admin") {
                path += ":" + selection;
                AdminMenu(toucherid, path, "", adminbuttons);
            }
            else if(selection == "ChangeSeat")
            {
                path = path + ":" + selection;
                AdminMenu(toucherid, path,  "Where will you sit?", slotbuttons);
            }
            else if(selection == "offset") {

                path = path + ":" + selection;
                AdminMenu(toucherid, path,   "Adjust by " + (string)currentOffsetDelta
                    + "m, or choose another distance.", offsetbuttons);
            }
            else if(selection == "Adjust") {
                llMessageLinked(LINK_SET, 201, "", "");
                AdminMenu(toucherid, path, "", adminbuttons);
            }
            else if(selection == "StopAdjust") {
                llMessageLinked(LINK_SET, 205, "", "");
                AdminMenu(toucherid, path, "", adminbuttons);
            }
            else if(selection == "PosDump") {
                llMessageLinked(LINK_SET, 204, "", "");
                AdminMenu(toucherid, path, "", adminbuttons);
            }
            else if(selection == "Unsit") {
                list buttons;
                stop = llGetListLength(slots);
                for(; n < stop; n+=2) {

                    buttons += [llGetSubString(llKey2Name((key)llList2String(slots, n)), 0, 20)];
                }
                if(buttons != []) {

                    path += ":" + selection;
                    AdminMenu(toucherid, path, "Pick an avatar to unsit", buttons);
                }
                else {

                    AdminMenu(toucherid, path, "", adminbuttons);
                }
            }
            else if(selection == "Options") {
                path += ":" + selection;
                string optionsPrompt =  "Permit currently set to " + Permissions
                    + "\nMenuOnSit currently set to "+ curmenuonsit + "\nsit2GetMenu currently set to " + menuReqSit
                    + "\n2default currently set to "+ cur2default + "\nFacialEnable currently set to "+ Facials
                    + "\nUseRLVBaseRestrict currently set to "+ RLVenabled + "\nmenudist currently set to "+ (string)menuDistance;
                AdminMenu(toucherid, path, optionsPrompt, []);

            }
            else if(llList2String(llParseString2List(path, [":"], []), -1) == "ChangeSeat")
            {
                if(llGetSubString(selection, 0,3)=="seat")
                {
                    n = (integer)llGetSubString(selection, 4,-1);
                    if(n >= 0) {
                        llMessageLinked(LINK_SET, 210, (string)n, toucherid);
                    }
                }
                else
                {
                    n = llListFindList(slotbuttons, [selection])+1;
                    if(n >= 0) {
                        llMessageLinked(LINK_SET, 210, (string)n, toucherid);
                    }
                }
                list pathparts = llParseString2List(path, [":"], []);
                pathparts = llDeleteSubList(pathparts, -1, -1);
                path = llDumpList2String(pathparts, ":");
                DoMenu(toucherid, path,  "", 0);
            }
            else if(llList2String(llParseString2List(path, [":"], []), -1) == "Unsit")
            {
                stop = llGetListLength(slots);
                list buttons;
                for(; n < stop; n+=2)
                {
                    key av = llList2Key(slots, n);
                    if(llGetSubString(llKey2Name(av), 0, 20) == selection) {
                        llMessageLinked(LINK_SET, -222, (string)av, NULL_KEY);
                    }
                    else
                    {
                        buttons += [llGetSubString(llKey2Name(av), 0, 20)];
                    }
                }
                if(buttons != []) {
                    AdminMenu(toucherid, path, "Pick an avatar to unsit", buttons);
                }
                else
                {
                    list pathParts = llParseString2List(path, [":"], []);
                    pathParts = llDeleteSubList(pathParts, -1, -1);
                    AdminMenu(toucherid, llDumpList2String(pathParts, ":"), "", adminbuttons);
                }
            }
            else if(llList2String(llParseString2List(path, [":"], []), -1) == "offset") {
                if(selection ==   "forward") AdjustOffsetDirection(toucherid,  (vector)<1, 0, 0>);
                else if(selection ==  "backward") AdjustOffsetDirection(toucherid,  (vector)<-1, 0, 0>);
                else if(selection ==  "left") AdjustOffsetDirection(toucherid,  (vector)<0, 1, 0>);
                else if(selection == "right") AdjustOffsetDirection(toucherid,  (vector)<0, -1, 0>);
                else if(selection ==    "up") AdjustOffsetDirection(toucherid,  (vector)<0, 0, 1>);
                else if(selection ==  "down") AdjustOffsetDirection(toucherid,  (vector)<0, 0, -1>);
                else if(selection ==  "reset") llMessageLinked(LINK_SET, 209, (string)ZERO_VECTOR, toucherid);
                else currentOffsetDelta = (float)selection;
                AdminMenu(toucherid, path,  "Adjust by " + (string)currentOffsetDelta
                    + "m, or choose another distance.", offsetbuttons);
            }
            else if(selection == "sync") {
                llMessageLinked(LINK_SET, 206, "", "");
                DoMenu(toucherid, path, "", page);
            }
            else
            {
                list pathlist = llDeleteSubList(llParseStringKeepNulls(path, [":"], []), 0, 0);
                string defaultname = llDumpList2String(["DEFAULT"] + pathlist + [selection], ":");
                string setname = llDumpList2String(["SET"] + pathlist + [selection], ":");
                string btnname = llDumpList2String(["BTN"] + pathlist + [selection], ":");

                integer permission = llListFindList(menuPermPath, [llDumpList2String(pathlist + [selection], ":")]);

                if(~permission) {
                    string thisPerm = llList2String(menuPermPerms, permission);
                    if(thisPerm != "") {
                        defaultname += "{"+thisPerm+"}";
                        setname += "{"+thisPerm+"}";
                        btnname += "{"+thisPerm+"}";
                    }
                }
                if(llGetInventoryType(defaultname) == INVENTORY_NOTECARD) {
                    llMessageLinked(LINK_SET, 200, defaultname, toucherid);
                }
                if(llGetInventoryType(setname) == INVENTORY_NOTECARD) {
                    llMessageLinked(LINK_SET, 200, setname, toucherid);
                }
                if(llGetInventoryType(btnname) == INVENTORY_NOTECARD) {
                    llMessageLinked(LINK_SET, 207, btnname, toucherid);
                }
                if (MAGIC == llList2String(params, 4)) return;

                if(~llListFindList(menus, [path + ":" + selection]))
                {
                    DoMenu(toucherid, path + ":" + selection, "", 0);
                }
                else if(llGetSubString(selection,-1,-1) != "-") {
                    DoMenu(toucherid, path, "", page);
                }
            }
        }
        else if(num == -902)
        {
            if((cur2default == "on") && (llGetObjectPrimCount(llGetKey()) == llGetNumberOfPrims()) && (defaultPoseNcName != "")) {
                llMessageLinked(LINK_SET, 200, defaultPoseNcName, NULL_KEY);
            }

        }
        else if(num==-240)
        {

            list optionsToSet = llParseStringKeepNulls(str, ["~"], []);
            stop = llGetListLength(optionsToSet);
            for(; n<stop; ++n) {
                list optionsItems = llParseString2List(llList2String(optionsToSet, n), ["="], []);
                string optionItem = llToLower(llList2String(optionsItems, 0));
                string optionSetting = llToLower(llList2String(optionsItems, 1));
                if(optionItem == "menuonsit") {curmenuonsit = optionSetting;}
                else if(optionItem == "permit") {Permissions = llToUpper(optionSetting);}
                else if(optionItem == "2default") {cur2default = optionSetting;}
                else if(optionItem == "sit2getmenu") {menuReqSit = optionSetting;}
                else if(optionItem == "menudist") {menuDistance = (float)optionSetting;}
                else if(optionItem == "facialExp") {
                    Facials = optionSetting;
                    llMessageLinked(LINK_SET, -241, Facials, NULL_KEY);
                }
                else if(optionItem == "rlvbaser") {
                    RLVenabled = optionSetting;
                    llMessageLinked(LINK_SET, -1812221819, "RLV=" + RLVenabled, NULL_KEY);
                }
            }
        }
        else if(num == -888)
        {
            if(str == "admin") {
                path += ":" + str;
                AdminMenu(id, path, "", adminbuttons);
            }
            else if(str == "ChangeSeat")
            {
                path = path + ":" + str;
                AdminMenu(id, path,  "Where will you sit?", slotbuttons);
            }
            else if(str == "offset") {

                path = path + ":" + str;
                AdminMenu(id, path,   "Adjust by " + (string)currentOffsetDelta
                    + "m, or choose another distance.", offsetbuttons);
            }
            else if(str == "sync") {
                llMessageLinked(LINK_SET, 206, "", "");
                DoMenu(id, path, "", 0);
            }
        }
        else if(num == -800)
        {
            if(!llSubStringIndex(str, "PATH=")) str = llGetSubString(str, 5, -1);
            DoMenu(id, str, "", 0);
        }
        else if(num == -801)
        {
            DoMenu(id, "Main", "", 0);
        }
        else if(num == -238)
        {
            victims = llCSV2List(str);
        }
        else if(num == 225)
        {
            if(id==scriptID) {
                BuildMenus(llList2List(llParseStringKeepNulls(str, ["%&§"], []), 3, -1));
                str = "";
            }
        }
        else if(num == -806)
        {
            list newPermission=llCSV2List(str);
            integer n1;
            integer length=llGetListLength(newPermission);
            for(; n1<length; n1+=3) {
                string permissionName=llToLower(llList2String(newPermission, n1));
                index=llListFindList(pluginPermissionList, [permissionName]);
                if(~index) {
                    pluginPermissionList=llDeleteSubList(pluginPermissionList, index, index+2);
                }
                pluginPermissionList+=[permissionName] + llList2List(newPermission, n1+1, n1+2);
            }
        }
        else if(num==35353)
        {
            list slotsList = llParseStringKeepNulls(str, ["^"], []);
            slots = [];
            for(n=0; n<(llGetListLength(slotsList)/8); ++n) {
                slots += [(key)llList2String(slotsList, n*8+4), llList2String(slotsList, n*8+7)];
            }
        }
        else if (num==35354)
        {
            slotbuttons = llParseString2List(str, [","], []);
            string strideSeat;
            for(n = 0; n < llGetListLength(slotbuttons); ++n) {
                index = llSubStringIndex(llList2String(slotbuttons, n), "§");
                if(!index) {
                    strideSeat = llGetSubString(llList2String(slotbuttons, n), 1,-1);
                }
                else {
                    strideSeat = llGetSubString(llList2String(slotbuttons, n), 0, index+-1);
                }
                slotbuttons = llListReplaceList(slotbuttons, [strideSeat], n, n);
            }
        }
        else if(num == 34334)
        {
            llSay(0,"Memory Used by " + llGetScriptName() + ": " + (string)llGetUsedMemory() + " of " + (string)llGetMemoryLimit()
                + ",Leaving " + (string)llGetFreeMemory() + " memory free.");
        }
        else if (num == RESET)
        {
            llResetScript();
        }

    }

    changed(integer change) {
        if(change & CHANGED_INVENTORY) {
            scriptID=llGetInventoryKey(llGetScriptName());
            if(llGetInventoryType(menuNC) != INVENTORY_NOTECARD) {
                BuildMenus([]);
            }
            else {
                llSleep(1.0);
                llMessageLinked(LINK_SET, 224, menuNC, scriptID);
            }
        }
        if(change & CHANGED_OWNER) {
            llResetScript();
        }
        if((change & CHANGED_LINK) && (cur2default == "on")
            && (llGetObjectPrimCount(llGetKey()) == llGetNumberOfPrims())
                && (defaultPoseNcName != "")) {
                    llMessageLinked(LINK_SET, 200, defaultPoseNcName, NULL_KEY);
                }
    }

    on_rez(integer params) {
        llResetScript();
    }
}
 