integer direction;
integer curPoint;
list points;
string route;
float SPEED=8.0; //meters /second

float TURNING_DISTANCE_RATIO=0.2; // How much distance to cover while turning (ratio, 0. - 1.0)
float TURNING_TIME_RATIO=0.2; // How much time to spend turning. if > than DISTANCE_RATIO, the turns will be slow

float WATERHEIGHT = 20.05;


integer CONTROLLER_CHANNEL = 169;

beginRoute(list points)
{
            llSetKeyframedMotion( [], []);
            //llSetRot(ZERO_ROTATION);
            llSleep(0.3);
         
            WATERHEIGHT = llWater(ZERO_VECTOR);
            vector pos = llList2Vector(points,0);
            pos.z = WATERHEIGHT;
            rotation rot = llGetRot();
            llSetRegionPos(pos);
            llSetRot(rot);

            integer i;            
            list kf;
            float totTime =0;
            
            for (i=0; i < llGetListLength(points); i++)
            {
                vector v = llList2Vector(points, i);
                v.z = WATERHEIGHT;                
                
                
                rotation r2  = ZERO_ROTATION;
                if (i < llGetListLength(points)-1)
                {
                    vector vn = llVecNorm(llList2Vector(points, i+1) - v);
                    vn.z=0;
                    r2 = llRotBetween(<1,0,0>,vn);
                }

                float t;
                if (i>0)
                {
                    kf += (1.0-TURNING_DISTANCE_RATIO)*(v-pos);
                    kf += ZERO_ROTATION;
                    t = llVecMag(v-pos)/SPEED; //adjust for speed
                    kf += t*(1.0-TURNING_TIME_RATIO);
                                
                    kf += TURNING_DISTANCE_RATIO*(v-pos);
                    kf += (r2/rot);
                    kf += t*TURNING_TIME_RATIO; //adjust for speed
                }
                else // the zero-th frame is just a rotation
                {
                    kf += ZERO_VECTOR;
                    kf += (r2/rot);
                    kf += 2; //adjust for speed
                    t = 2;
                }
                

                totTime+= t+1;
                
                pos = v;
                rot = r2;
                //llOwnerSay("Pos="+(string)pos);
            }
            ///llOwnerSay("list has" + (string)llGetListLength(kf) );

            llLoopSound("paddle", 1.0);
            llSetKeyframedMotion( kf, [KFM_DATA, KFM_TRANSLATION|KFM_ROTATION, KFM_MODE, KFM_FORWARD]);
            
            llSetTimerEvent(totTime);
            llMessageLinked(LINK_SET, 0, "START", "");
}


default
{
    state_entry()
    {
        llListen( 0,"", "","");
        llMessageLinked(LINK_THIS, 0, "STOP", "");
    }
    
    listen(integer int, string n, key sender, string msg)
    {
        string nm = llGetObjectName();
        if (llGetSubString(msg, 0,llStringLength(nm)-1) != nm)         return;
        
        list tok = llParseString2List(msg, [" "], []);
        string cmd = llList2String(tok, 1);
        
        if (cmd  == "stop")
        {
            llSetKeyframedMotion( [], [KFM_COMMAND, KFM_CMD_STOP]);
            llStopSound();
            llSetTimerEvent(0);
            llMessageLinked(LINK_SET, 0, "STOP", "");
        }
        else if (cmd == "note" || cmd == "rnote" )
        { 
            string nc = llList2String(tok,2);
            if (llGetInventoryType(nc)!= INVENTORY_NOTECARD)
            {
                llSay(0,"notecard not found: "+nc);
                return;
            }
            points = llParseString2List(osGetNotecard(nc), [" ","\n"], []);
            if (cmd == "rnote") // Reverse order
            {
                integer t = llGetListLength(points);
                list tmp = [];
                while(--t>=0) tmp += llList2Vector(points, t);
                points = tmp;
            }   
        }
        else
        {
            llRegionSay(CONTROLLER_CHANNEL, "! "+llGetKey()+ " " +(string)llGetPos()+ " " + (string)sender + " " +msg);
        }
    }
    
    
    dataserver(key qid, string str)
    {
        points = llParseString2List(str, ["|"], []);
        
        if (llList2String(points,0) == "SETROUTE")
        {
            points = llList2List(points, 1, -1);
            //llSay(0, "Route is "+llList2CSV(points));
            
            llSetKeyframedMotion( [], [KFM_COMMAND, KFM_CMD_STOP]);
            llStopSound();
            llSetTimerEvent(0);
            llMessageLinked(LINK_SET, 0, "STOP", "");
            llSleep(0.3);
            beginRoute(points);
        }
        else if  (llList2String(points,0) == "TELEPORT")
        {
            llSetKeyframedMotion( [], [KFM_COMMAND, KFM_CMD_STOP]);
            llStopSound();

            llSetRegionPos(llList2Vector(points,1));
        }
    }

    
    touch_start(integer n)
    {
        key sender = llDetectedKey(0);
        llRegionSay(CONTROLLER_CHANNEL, "! "+llGetKey()+ " " +(string)llGetPos()+ " " + (string)sender + " "+ llGetObjectName()+ " CLICKED");
    }
        
    
    timer()
    {
        llStopSound();
        llSay(0, "Arrived");
        llSetTimerEvent(0);
        llMessageLinked(LINK_SET, 0, "STOP", "");
        //llResetScript();
    }
    
    
}

 