/* ************************************************************************** */
//
// tl BodyController script [UNDERWEAR LAYER]
// 
// by Thai Low @ endivatomic.eu:8002
//
// Provided under Creative Commons Attribution-Non-Commercial-ShareAlike 4.0 
//                International license.
//
// Please be sure you read and adhere to the terms of this license: 
//      https://creativecommons.org/licenses/by-nc-sa/4.0/
//
/* ************************************************************************** */
// IMPORTANT NOTE: 
//          I only made the controller (this script) and the related HUD,
//          NOT the bodymesh where you may found this script inside. 
//          The right to copy and use any components (mesh,textures,etc...)
//          apart this script, are all reserved to the related builders.
//                                                      Thai Low
/* ************************************************************************** */

// -------------------------------------------------------------------------
//  module variables/constants
// -------------------------------------------------------------------------
integer CHOFFS  = 101;
string LAYER    = "UK";
string LAYERUP  = "UU";
string LAYERLOW = "UL";
string MODULE   = "LINGERIE";

integer TMCD = 40;
integer mCh;

// -------------------------------------------------------------------------
//  common Helpers
// -------------------------------------------------------------------------
// --- Get a unique channel number (nearly unique)
integer getOwnerChannel() {  
  return 0x80000000 | (integer)("0x"+llGetSubString((string)llGetOwner(),-7,-1));
}  

// --- return alpha value on for all values other than 0
float bool2alpha( integer val ) {
  if (val) return 1.0;
  return 0.0;
}

// -------------------------------------------------------------------------
//  module functions
// -------------------------------------------------------------------------
// --- set alpha ON to all layer
setAlphaFull( integer sts ) {   
  float alpha = 0.; if (sts) alpha = 1.;
  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) llSetLinkAlpha( lnk, alpha, ALL_SIDES );  
}

// --- set color to all layer
setColor( vector col ) {
  integer lnk = 1 + llGetNumberOfPrims();    
  while( --lnk > 0 ) 
    llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, ALL_SIDES, col, 1.0] );
}

setTexture( string tp, key tid ) {      
  integer lnk = 1 + llGetNumberOfPrims();    
  while( --lnk > 0 ) {
    if ( llGetLinkName( lnk ) == tp ) 
      llSetLinkPrimitiveParamsFast( lnk, [
        PRIM_TEXTURE, ALL_SIDES, tid, <1,1,0>, <0,0,0>, 0,
        PRIM_COLOR, ALL_SIDES, <1,1,1>, 1.0
      ] );    
  }
  if (tp == LAYERLOW) llSay(mCh, "SOCKS|txt|"+tid);
  //else if (tp == LAYERUP) llSay(mCh, "GLOVES|txt|"+tid);
}


// -------------------------------------------------------------------------
//  default Events cycle
// -------------------------------------------------------------------------
default {
    
  state_entry() {
    mCh = getOwnerChannel() + CHOFFS;
    llListen( mCh, "", NULL_KEY, "" );    
  }
  
  changed(integer mask) { if ( mask & CHANGED_OWNER ) llResetScript(); }  
  on_rez(integer par) { llResetScript(); }  
  
  listen( integer ch, string name, key id, string msg ) {         
    string dest = llGetSubString( msg, 0, 1);
    if (dest != LAYER && dest != LAYERUP && dest != LAYERLOW) return;
              
    list   par = llParseString2List( msg, ["|"], [] );    
    string cmd = llList2String( par, 1 );        
        
    if (dest == LAYER && cmd == "on") { 
      setAlphaFull( TRUE ); 
      llSetTimerEvent(0);     
    } 
    else if (dest == LAYER && cmd == "off") { 
      setAlphaFull( FALSE );      
      if (llGetAttached()) llSetTimerEvent(TMCD);
    }
    if (dest == LAYER && cmd == "col" ) { 
      setColor(llList2Vector( par, 2 )); 
    }        
    if (dest == LAYER && cmd == "txt") { 
      setTexture( LAYERUP, llList2Key( par, 2 ) );
      setTexture( LAYERLOW, llList2Key( par, 3 ) );      
    }    
    else if ((dest == LAYERUP || dest == LAYERLOW) && cmd == "txt") { 
      setTexture( dest, llList2Key( par, 2 ) ); 
    }  
  }
  
  timer() {    
    llSetTimerEvent(0);  
    llRequestPermissions(llGetOwner(), PERMISSION_ATTACH );
  }
  
  run_time_permissions(integer perm) {
    if(perm & PERMISSION_ATTACH) llDetachFromAvatar();        
  }  
} 