// ----------------------------------------------------------------------------------
// nPose Write Notecards Script V1.03
// ----------------------------------------------------------------------------------
// Copyright (c) 2017, Jenni Eales. All rights reserved.
// ----------------------------------------------------------------------------------
// Changes:
// ----------------------------------------------------------------------------------
// Version 1.02
// - support of facial expressions
// - keep lines with special commands
// 
// Version 1.01
// - save prop info too
// 
// Version 1.0
// - first version released
// ----------------------------------------------------------------------------------
//
// constants
integer DEBUG               = FALSE;
integer STRIDE              = 8;
integer CHANNEL             = -111;

integer DOPOSE              =  200;
integer DOPOSE_READER       =  222;
integer SEAT_UPDATE         =  35353;
integer PROP_UPDATE         =  35355;

//PLUGIN SPECIFIC
integer DIALOG_SEQUENCE     = -95001;
integer SAVE_NOTECARD       = -95002;

string TEXT_ENTER_NOTECARD   = "Enter notecard name: \n\nSample:\nSET:Group:Pose";
string TEXT_ENTER_ANIMATIONS = "Enter animation names: \n\nSample:\nsit1,sit2";

// internal use
string notecard_name = "";
string notecard_positions = "";
string prop_position = "";
integer handle = 0;
integer step = 0;

// ----------------------------------------------------------------------------------
log(string message)
{
    if (DEBUG) llOwnerSay(message);
}

// replace substring in source string
string llReplaceString(string source, string pOld, string pNew)
{
    while (llSubStringIndex(source, pOld) != -1)
    {
        integer index = llSubStringIndex(source, pOld);
        string temp = llDeleteSubString(source, index, (index + (llStringLength(pOld) - 1)));
        source = llInsertString(temp, index, pNew);
    }
    return source;
}

string read_prop_data(string line)
{
    string result = "";
    list tokens = llParseStringKeepNulls(line, ["|"], []);
    integer count = llGetListLength(tokens);
    integer i;

    for (i = 0; i < count; i++)
    {
        string each = llList2String(tokens, i);
        if (llSubStringIndex(each, "PROP") > -1)
        {
            log("found " + each);
            result = "PROP|";
            result += llList2String(tokens, i + 1);
            result += "|" + llList2String(tokens, i + 2);
            result += "|" + llList2String(tokens, i + 3);
        }
    }
    
    return result;
}

create_notecard(string notecard_name, string animations)
{
    llSetTimerEvent(0);
    llListenRemove(handle);
    list lines = [];
    list tokens = llParseString2List(animations, [",", "|", "^"], []);
    list pos_tokens = llParseStringKeepNulls(notecard_positions, ["^"], []);
    integer i;
    for (i=0; i< llGetListLength(tokens); i++)
    {
        string command = "ANIM|";
        command += llList2String(tokens, i);
        string pos = llList2String(pos_tokens, 1 + (i * STRIDE));
        command += "|" + llReplaceString(pos, "NaN", "0.00");
        string rot = llList2String(pos_tokens, 2 + (i * STRIDE));
        rot = deg_to_rot(rot);
        command += "|" + llReplaceString(rot, "NaN", "0.00");
        command += "|";
        lines += [command];
        log("line: " + command);
    }

    lines += ["", "# notecard generated with " + llGetScriptName()];
    save(notecard_name, lines);
}

new_data()
{
    step = 0;
    handle = llListen(CHANNEL, "", llGetOwner(), "");
    llSetTimerEvent(60.00);
    llTextBox(llGetOwner(), TEXT_ENTER_NOTECARD, CHANNEL);
}

enter_animations()
{
    step = 1;
    llSetTimerEvent(60.00);
    llTextBox(llGetOwner(), TEXT_ENTER_ANIMATIONS, CHANNEL);
}

save(string notecard, list lines)
{
    log("saving data: " + notecard);
    if (llGetInventoryType(notecard) == INVENTORY_NOTECARD)
    {        
        llRemoveInventory(notecard);
    }
    osMakeNotecard(notecard, lines);
}

string deg_to_rot(string rot_string)
{
    rotation rot = (rotation) rot_string;
    vector euler = llRot2Euler(rot) * RAD_TO_DEG;
    return (string) euler;
}

list data_to_lines(string positions, list content)
{
    list lines = [];
    integer i;
    list tokens = llParseStringKeepNulls(positions, ["^"], []);

    // compose lines
    for (i=0; i<4; i++)
    {
        string command = "ANIM";
        string pose = llList2String(tokens, i * STRIDE);
        command += "|" + pose;
        string pos = llList2String(tokens, 1 + (i * STRIDE));
        command += "|" + pos;
        string rot = llList2String(tokens, 2 + (i * STRIDE));
        rot = deg_to_rot(rot);
        command += "|" + rot;
        string facial = llList2String(tokens, 3 + (i * STRIDE));
        command += "|" + facial;

        if (pose != "")
            lines += [command];
    }

    // add additional contents from previous version
    integer n = llGetListLength(content);
    for (i=0; i<n; i++)
    {
        string line = llList2String(content, i);
        if (llSubStringIndex(line, "LINKMSG|") == 0) lines = llListInsertList(lines, [line], i);
        if (llSubStringIndex(line, "SATMSG|") == 0) lines = llListInsertList(lines, [line], i);
        if (llSubStringIndex(line, "NOTSATMSG|") == 0) lines = llListInsertList(lines, [line], i);
    }

    // add prop data
    if (prop_position != "") lines += [prop_position];

    lines += ["", "# notecard generated with " + llGetScriptName()];
    return lines;
}

save_data()
{
    list content = [];
    if (llGetInventoryType(notecard_name) == INVENTORY_NOTECARD)
    {
        content = llParseString2List(osGetNotecard(notecard_name), ["\n"], []);
    }
    save(notecard_name, data_to_lines(notecard_positions, content));
}

// ----------------------------------------------------------------------------------
default
{
    // state entered
    state_entry()
    {
        log("state entered: 'default'");
    }

    // on rez: reset me
    on_rez(integer start_param)
    {
        llResetScript();
    }

    listen(integer channel, string name, key id, string message)
    {
        if (step == 0)
        {
            log("Notecard: " + message);
            notecard_name = message;
            enter_animations();
        }
        else if (step == 1)
        {
            log("Animations: " + message);
            create_notecard(notecard_name, message);
        }
    }

    // link message
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (number == DOPOSE)
        {
            log("Notecard: " + message);
            notecard_name = message;
        }
        else if (number == PROP_UPDATE)
        {
            log("prop update: " + message);
            prop_position = message;
        }
        else if (number == DOPOSE_READER)
        {
            log("prop reader: " + message);
            if (llSubStringIndex(message, "PROP") > -1)
            {
                prop_position = read_prop_data(message);
                log("prop data in pose: " + prop_position);
            }
            else
            {
                log("no prop in pose.");
                prop_position = "";
            }
        }
        else if (number == SEAT_UPDATE)
        {
            log("positions: " + message);
            notecard_positions = message;
        }
        else if (number == SAVE_NOTECARD)
        {
            if (message == "save")
                save_data();

            if (message == "new")
                new_data();
        }
        else
        {
            // log("link message sender: " + (string) sender_number + " number: " + (string) number + " message: '" + message + "' key: " + (string) id);
        }
    }

    timer()
    {
        log("timeout");
        llSetTimerEvent(0);
        llListenRemove(handle);
    }
}

// ----------------------------------------------------------------------------------
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above copyright notice,
//      this list of conditions and the following disclaimer in the documentation
//      and/or other materials provided with the distribution.
//    * The names of its contributors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
// BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
// OF SUCH DAMAGE.
// ----------------------------------------------------------------------------------
 