integer DEBUG = FALSE;

float INTERVAL = 9.6;
float VOLUME = 3.0;

integer CHANNEL = -165435;
integer SONGCHUNK = 6;

integer trackCnt = 0;
integer initBusy = TRUE;

integer curTrack = 0;
integer songIX = 0;
integer songTrackCnt = 0;
integer curSongOffset = 0;
integer totalSongs = 0;
integer curSongEnd = 5;
integer NotecardLine = 0;

string  dispSongStr = "";
string  songName = "";
string playing = "";

string NEXT_MSG = "Next >>";
string PREV_MSG = "<< Prev";
string STOP_MSG = "Stop";

list theSongBtns = [];
list songNames = [];
list songKeys = [];

key DataRequest = NULL_KEY;
key silence = "aa541ce7-3713-41f4-b82a-f3cb8a06e62a";

Initialize()
{
    llSetText("", <1,1,1>, 1.0);
   
    llListen(CHANNEL, "", NULL_KEY, "");

    playing = "";
    initBusy = TRUE;
    curTrack = 1;
    curSongEnd = 5;
    curSongOffset = 0;

    totalSongs = llGetInventoryNumber(INVENTORY_NOTECARD);

    songIX = 0;
    while(songIX < totalSongs)
    {
        songNames += llGetInventoryName(INVENTORY_NOTECARD, songIX);
        songIX += 1;
    }
    initBusy = FALSE;
}

curSongs()
{
    if(curSongOffset > 0)
    {
        theSongBtns = [PREV_MSG];
    }
    else
    {
        theSongBtns = [" "];
    }
    if(curSongEnd < (totalSongs-1))
    {
        theSongBtns += [STOP_MSG, NEXT_MSG];
    }
    else
    {
        theSongBtns += [STOP_MSG, " "];
    }

    integer i;
    dispSongStr = "";

    if (curSongOffset >= totalSongs)
    {
        curSongOffset = 0;
        curSongEnd = curSongOffset + (SONGCHUNK - 1);
    }

    if (curSongEnd >= totalSongs)
    {
        curSongEnd = totalSongs - 1;
    }

    for (i = curSongOffset; i <= curSongEnd; i++)
    {
        if (songIX == i)
        {
            dispSongStr += "*";
        }
        else
        {
            dispSongStr += " ";
        }
        dispSongStr += (string) (i + 1) + ") ";
        dispSongStr += llList2String(songNames, i);
        dispSongStr += "\n";

        theSongBtns += (string)(i + 1);
    }
}

doNextSet()
{
    curSongOffset += SONGCHUNK;
    curSongEnd = curSongOffset + (SONGCHUNK - 1);

    if (curSongOffset >= totalSongs)
    {
        curSongOffset = 0;
        curSongEnd = curSongOffset + (SONGCHUNK - 1);
    }

    if (curSongEnd >= totalSongs)
    {
        curSongEnd = totalSongs - 1;
    }
}


doPrevSet()
{
    if (curSongOffset > 1 && ((curSongOffset - SONGCHUNK) < 1))
    {
        curSongOffset = 0;
    }
    else
    {
        curSongOffset -= SONGCHUNK;
    }

    curSongEnd = curSongOffset + (SONGCHUNK - 1);

    if (curSongEnd >= totalSongs)
    {
        curSongEnd = totalSongs - 1;
    }

    if (curSongOffset < 0)
    {
        curSongEnd = totalSongs - 1;
        curSongOffset = totalSongs - (SONGCHUNK - 1);
    }
}

LoadSong()
{
    if(DEBUG) llOwnerSay("LoadSong");

    llOwnerSay( "Loading: "+ songName);

    songTrackCnt = 0;
    DataRequest = llGetNotecardLine( songName, 0 );
}

PlaySong()
{
    if(DEBUG) llOwnerSay("PlaySong");

    playing = songName;

    curTrack = 0;

    llOwnerSay("Playing: "+ songName);

    llPlaySound(llList2Key(songKeys, curTrack++), VOLUME);
    llPreloadSound( llList2Key(songKeys, curTrack) );
    llSetTimerEvent(INTERVAL-1.0);
}


StopSong()
{
    if(DEBUG) llOwnerSay("StopSong");

    llPlaySound(silence, 0.0);

    llStopSound();
    llSetTimerEvent(0.0);

    playing = "";

    songKeys = [];
}

default
{
    state_entry()
    {
        Initialize();
    }

    changed(integer change)
    {
        if(DEBUG) llOwnerSay("changed");

        if (change & CHANGED_INVENTORY)
        {
            llResetScript();
        }
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    dataserver( key id, string data )
    {
        if(DEBUG) llOwnerSay("dataserver: "+(string)songTrackCnt+" = "+data);

        if (id == DataRequest)
        {
            if (data != EOF)
            {
                data = llStringTrim( data, STRING_TRIM );
                list dataParts = llParseString2List(data, ["|"], [""]);

                songKeys += llList2String(dataParts, 0);
                songTrackCnt += 1;

                DataRequest = llGetNotecardLine( songName, songTrackCnt );
            }
            else
            {
                songTrackCnt -= 1;
                PlaySong();
            }
        }
    }

    touch_start(integer touchNumber)
    {
        if(DEBUG) llOwnerSay("touch_start");
        if(initBusy)
        {
            llOwnerSay("Busy loading songs, please wait a moment and try again...");
        }
        else
        {
            curSongs();

            llDialog(llDetectedKey(0), dispSongStr, theSongBtns, CHANNEL);
        }
    }

    listen(integer channel, string name, key id, string message)
    {
        if(DEBUG) llOwnerSay("listen: "+message);

        //list words = llParseString2List(message, [" ", " ", "="], []);
        list words = llParseString2List(message, ["="], []);
        list testFind = llList2List(words, 0, 0);
        
        if (llList2String(testFind,0) == "Next >>")
        {
            doNextSet();
            curSongs();

            llDialog(id, dispSongStr, theSongBtns, CHANNEL);
        }
        else if (llList2String(testFind,0) == "<< Prev")
        {
            doPrevSet();
            curSongs();

            llDialog(id, dispSongStr, theSongBtns, CHANNEL);
        }
        else if (llList2String(testFind,0) == "Stop")
        {
            StopSong();
        }
        else if ((integer)message > 0 && (integer)message < 256)
        {
            songIX = (integer)message - 1;
            songName = llList2String(songNames, songIX);

            StopSong();

            LoadSong();
        }
    }

    timer()
    {
        if(DEBUG) llOwnerSay("timer: start: playing = "+(string)playing+", curTrack="+(string)curTrack+", songTrackCnt="+(string)songTrackCnt);

        llSetTimerEvent(INTERVAL);

        if ( curTrack <= songTrackCnt )
        {
            llPlaySound(llList2Key(songKeys, curTrack), VOLUME);
            if ( ++curTrack < songTrackCnt )
            {
                llPreloadSound( llList2Key(songKeys, curTrack) );
            }
        }
        else
        {
            llOwnerSay("Finished: "+songName);

            llStopSound();

            llPlaySound(silence, 0.0);

            llSetTimerEvent(0.0);
        }

        if(DEBUG) llOwnerSay("timer end: playing = "+playing+", curTrack="+(string)curTrack+", songTrackCnt="+(string)songTrackCnt);
    }
}
 