// Sit script
// by Asp Grelling 23APR07

vector sitPosition = <0,-0.6,.4> ; // Sit offset
vector sitRotation = <0,0,270> ; // Sit rotation

// ---- DO NOT MODIFY BELOW THIS LINE -----

key avatar ;
key sitter = NULL_KEY ;
string anim = "sit" ;

default
{
state_entry()
{
llSetSitText("Sit here");
sitRotation = sitRotation*DEG_TO_RAD;
rotation rot = llEuler2Rot(sitRotation);
llSitTarget(sitPosition, rot);
sitter = NULL_KEY ;
}

on_rez(integer param)
{
llResetScript();
}

changed(integer change)
{
if(change & CHANGED_LINK) {
avatar = llAvatarOnSitTarget();
if ( avatar ) {
// Request permision to sit
llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
} else {
if ( sitter ) {
llUnSit(sitter);
sitter = NULL_KEY ;
} else {
// We can get here for many reasons
// Do nothing
}
}
}
}

run_time_permissions(integer perm)
{
if(perm & PERMISSION_TRIGGER_ANIMATION)
{
// Sit action
sitter = avatar ;
llStopAnimation("sit");
llStartAnimation(anim);
} else {
// We do not have permissions, so unist
llUnSit(sitter);
sitter = NULL_KEY ;
}
}
} 