/**

If the NPC is not showing or working, you need to recreate the appearance using NPC creator tool, while wearing  the AnimalListener object

**/

key unpc= NULL_KEY;
key listenerKey;

list productsCollected;
key targetTree = NULL_KEY;
key lastTree;
string waitForItem;

key myWater = NULL_KEY;
key myPotatoes = NULL_KEY;
string myPotatoesName = "";
key mySlop = NULL_KEY;
string lastAnim;
integer autoRez=0;

integer running=1;

integer waitTs;

string productName;
key followUser = NULL_KEY;

list TREENAMES = [];
list TREEFREQ  = [];
list TREEPRODUCTS = [];
string firstName;
string lastName;
float MAXHEIGHT=0;
float SPEED = 0.5;

integer isFlying;


integer RADIUS =90;

list treeLookup;

list myProducts; // list of product Keys

string PASSWORD;
string TITLE ="SF NPC Animal";
list PET_SAY;
list SIT_ANIM;
list CHAT_ANIM;
string FEEDER="Tiger Feeder";
string CRY="Meow";
integer RANGE=10;
float FEEDAMOUNT = 100.;
float WATERAMOUNT =100.;
float food = 100;
float water = 100;
vector stopPos;

integer chan(key u)
{
    return -1 - (integer)("0x" + llGetSubString( (string) u, -6, -1) )-393;
}



loadConfig()
{

    list lines = llParseString2List(osGetNotecard("config"), ["\n"], []);
    integer i;
    TREENAMES = [];
    TREEFREQ = [];
    TREEPRODUCTS= [];
    for (i=0; i < llGetListLength(lines); i++)
    {
        string line = llStringTrim(llList2String(lines, i), STRING_TRIM);
        if (llGetSubString(line, 0, 0) != "#")
        {
            list tok = llParseStringKeepNulls(llList2String(lines,i), ["="], []);
            string cmd=llStringTrim(llList2String(tok, 0), STRING_TRIM);
            string val=llStringTrim(llList2String(tok, 1), STRING_TRIM);
            if (cmd == "FIRST_NAME") firstName = val;
            else if (cmd == "LAST_NAME") lastName = val;
            else if (cmd == "CRY") CRY = val;
            else if (cmd == "TITLE") TITLE = val;
            else if (cmd == "FEEDER") FEEDER = val;
            else if (cmd == "PET_SAY") PET_SAY += val;
            else if (cmd == "ANIM_CHAT") CHAT_ANIM+= val;
            else if (cmd == "ANIM_SIT") SIT_ANIM+= val;
            else if (cmd == "RADIUS") RADIUS = (integer)val;
            else if (cmd == "AUTO_REZ") autoRez = (integer)val;
            else if (cmd == "RANGE") RANGE = (integer)val;
            else if (cmd == "MAXHEIGHT") MAXHEIGHT = (float)val;
            else if (cmd == "SPEED") SPEED = (float)val;
            else if (cmd == "FLY") isFlying = (integer)val;
            else if (cmd == "FEEDAMOUNT") FEEDAMOUNT= (float)val;
            else if (cmd == "WATERAMOUNT") WATERAMOUNT = (float)val;
        }
    }
}

integer listener=-1;
integer listenTs;

startListen()
{
    if (listener<0)
    {
        listener = llListen(chan(llGetKey()), "", "", "");
        listenTs = llGetUnixTime();
    }
}

checkListen()
{
    if (listener > 0 && llGetUnixTime() - listenTs > 300)
    {
        llListenRemove(listener);
        listener = -1;
    }
}

list objProps(key id)
{
    return llParseStringKeepNulls( llList2String(llGetObjectDetails(id, [OBJECT_DESC]), 0),  [";"], []);
}

string encodeList(list lst)
{
    list aux;
    integer i;
    for (i=0; i < llGetListLength(lst); i++)
    {
        integer tp = llGetListEntryType(lst,i);
        if (tp== TYPE_INTEGER)  aux += "I";
        else if (tp== TYPE_VECTOR)  aux += "V";
        else if (tp== TYPE_ROTATION)  aux += "R";
        else if (tp== TYPE_KEY)  aux += "K";
        else if (tp== TYPE_FLOAT)  aux += "F";
        else aux += "S";
        aux += llList2String(lst, i);
    }
    return llDumpList2String(aux, "|");
}

fire(integer isOn)
{
    return;
     list ps =
            [
                PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,
                PSYS_SRC_BURST_RADIUS,0,
                PSYS_SRC_ANGLE_BEGIN,0.0,
                PSYS_SRC_ANGLE_END,0.2,
                PSYS_SRC_TARGET_KEY,llGetKey(),
                PSYS_PART_START_COLOR,<0.878906,0.878906,0.878906>,
                PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
                PSYS_PART_START_ALPHA,.8,
                PSYS_PART_END_ALPHA,0,
                PSYS_PART_START_GLOW,0.1,
                PSYS_PART_END_GLOW,0,
                PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
                PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
                PSYS_PART_START_SCALE,<.500000,.500000,0.000000>,
                PSYS_PART_END_SCALE,<4.00000,4.000000,0.000000>,
                PSYS_SRC_TEXTURE,llGetInventoryKey("fire"),
                PSYS_SRC_MAX_AGE,3,
                PSYS_PART_MAX_AGE,5,
                PSYS_SRC_BURST_RATE,.01,
                PSYS_SRC_BURST_PART_COUNT,1,
                PSYS_SRC_ACCEL,<0.000000,0.000000, -.10000>,
                PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
                PSYS_SRC_BURST_SPEED_MIN,2.,
                PSYS_SRC_BURST_SPEED_MAX,4.,
                PSYS_PART_FLAGS,
                    0 |
                    PSYS_PART_EMISSIVE_MASK |
                    PSYS_PART_FOLLOW_SRC_MASK |
                    PSYS_PART_INTERP_COLOR_MASK|
                    PSYS_PART_INTERP_SCALE_MASK
            ];
    string str = encodeList(ps);
    if (isOn) msgListener("PARTICLESYSTEM|"+str);
    else msgListener("STOPPARTICLESYSTEM");
}

float walkTime(vector p , vector v)
{
    if (isFlying) return llVecDist(p,  v) / (8.5*SPEED) + 2; // Fly
    else return llVecDist(p,  v) / (3.2*SPEED) + 2; // walk
}

anim(string an)
{
    osNpcStopAnimation(unpc, lastAnim);
    lastAnim = an;
    if (lastAnim != "")
        osNpcPlayAnimation(unpc, lastAnim);
}

doTouch(key u)
{
   osNpcTouch(unpc, u, LINK_THIS);
}


whisper(string w)
{
   osNpcWhisper(unpc,0 , w);
}

say(string w)
{
   anim( llList2String(CHAT_ANIM, (integer)llFrand(llGetListLength(CHAT_ANIM))) )  ;
   if (llGetInventoryNumber(INVENTORY_SOUND)>0)
   {
       msgListener("TRIGGERSOUND|"+(string)llGetInventoryKey(llGetInventoryName(INVENTORY_SOUND, (integer)llFrand(llGetInventoryNumber(INVENTORY_SOUND)))) +"|1.0");
       fire(1);
   }
   if (w != "")
       osNpcSay(unpc, w);
}

chanSay(integer c, string w)
{
    say(">> "+w);
    osNpcSay(unpc, c, w);
}

msgListener(string m)
{
    if (llKey2Name(listenerKey) !="")
        osMessageObject(listenerKey,m);
}



doWalk(vector v)
{
    if (unpc==NULL_KEY) return;
    osNpcStopMoveToTarget(unpc);
    osSetSpeed(unpc, SPEED); // slow
    vector pos = osNpcGetPos(unpc);
    vector tgt = v - 1.0*llVecNorm(v-pos) + <0,0, .5>;
    if (isFlying)
    {
        if (llFrand(1.)<.2)
        {
            tgt.z = stopPos.z + .5;
           osNpcMoveToTarget(unpc, tgt  , OS_NPC_FLY|OS_NPC_LAND_AT_TARGET );
        }
        else osNpcMoveToTarget(unpc, tgt  , OS_NPC_FLY );
    }
    else
    {
        osNpcMoveToTarget(unpc, tgt  , OS_NPC_NO_FLY );
    }
    integer wt = (integer) walkTime(pos, v);
    waitTs = llGetUnixTime() + wt;
    llSetTimerEvent(wt+3);
}


doWander()
{

    float rnd = llFrand(1.);
    if (rnd <.4)
    {
        waitTs = llGetUnixTime() + 5;
        say("");
    }
    else
    {
        fire(0);
        vector pos = osNpcGetPos(unpc);
        vector tgt = stopPos + <(llFrand(2.)-1.)*RANGE, (llFrand(2.)-1.)*RANGE, (llFrand(1.))*MAXHEIGHT >;
        if (tgt.x<1) tgt.x =1;
        if (tgt.y<1) tgt.y =1;
        //llOwnerSay("Going to "+(string)tgt);
        doWalk(tgt);
    }
}


walkToTree(key u)
{
    vector v = llList2Vector( llGetObjectDetails(u , [OBJECT_POS]), 0);
    v += <0,0,0>;
    targetTree = u;
    doWalk(v);
}


handleTree(key u)
{
    if (llKey2Name(u) == FEEDER)
    {
        if ( food < 5)
        {
            osMessageObject(u, "FEEDME|"+PASSWORD+"|"+ (string)llGetKey() + "|" + (string)FEEDAMOUNT+"|"+(string)listenerKey);
        }
        if ( water < 5)
        {
            osMessageObject(u, "WATERME|"+PASSWORD+"|"+ (string)llGetKey() + "|"+ (string)WATERAMOUNT+"|"+(string)listenerKey);
        }
    }
}


integer lastTs;
refresh()
{
    integer ts = llGetUnixTime();
    food = 100;//(ts - lastTs)  *(100./6000.); // Food consumption rate
    water = 100;//(ts - lastTs) * (100./5000.); // water consumption rate

    if (food < 5 || water < 5)
    {
        string str = CRY+"! I 'm ";
        if (food<5) str += "hungry ";
        if (food<5 && water <5) str += " and ";
        if (water<5) str += "thirsty ";
        say(str);
        llSleep(1.);
        msgListener("SENSE|"+FEEDER);
    }

    lastTs = llGetUnixTime();
    msgListener("SETTEXT|"+"Food: "+(string)llRound(food)+"%\nWater: "+(string)llRound(water)+"%|<1,1,1>|1.0");
}


setDialogOpts()
{

    list opts = ["CLOSE", "Pet"];
    if (followUser == NULL_KEY)
        opts += "Follow";

    opts += "Stop";

    msgListener("SETDIALOGOPTS|"+firstName+" Menu:|"+llDumpList2String(opts, ","));
}

string strReplace(string str, string search, string replace) {
    return llDumpList2String(llParseStringKeepNulls(str, [search], []), replace);
}

key dlgUser;
string parseStr(string s)
{
    return strReplace(s, "%NAME%", llKey2Name( dlgUser ));
}

doDialogCmd(key who, string opt)
{
        dlgUser = who;
        opt  = llStringTrim(opt, STRING_TRIM);
        // Menu of cat
        if (opt == "Follow")
        {
            followUser = who;
            say("Following you "+llKey2Name(who));
            waitTs = 0;
            llSetTimerEvent(1);
            setDialogOpts();
        }
        else if (opt == "Stop")
        {
            say("Alright!");
            followUser = NULL_KEY;
            setDialogOpts();
            stopPos = osNpcGetPos(unpc);
            osNpcStopMoveToTarget(unpc);
            llSleep(.5);
            waitTs = llGetUnixTime() + 30;
            anim( llList2String(SIT_ANIM, (integer)llFrand(llGetListLength(SIT_ANIM))));
        }
        else if (opt == "Pet")
        {
            string str = llList2String(PET_SAY, (integer)llFrand(llGetListLength(PET_SAY)));
            say(parseStr(str));
        }
}

doRezNpc()
{
    lastTs= llGetUnixTime();
    osNpcRemove((key)llGetObjectDesc());
    llSetObjectName("SF NPC Controller");
    llSleep(.3);
    llSay(0, "Creating npc...");
    unpc = osNpcCreate(firstName, lastName,  llGetPos()+<0,0,1>, "appearance",  OS_NPC_NOT_OWNED | OS_NPC_SENSE_AS_AGENT | 8); //
    llSay(0, "Waiting for npc ...");
    llSetObjectDesc((string)unpc);
}

default
{
    dataserver(key kk, string m)
    {
        list tk = llParseStringKeepNulls(m, ["|"] , []);
        string cmd = llList2Key(tk,0);

        if (cmd  == "SENSORSF" || cmd == "SENSOR")
        {

            integer i;
            key u;
            list candidates;

            integer idx = 1+ (integer)llFrand( llGetListLength(tk)-1);
            u = llList2Key(tk, idx);

            if (u != NULL_KEY)
            {
                walkToTree(u);
            }
            else
                say("I cant find food!");

        }
        else if (cmd == "DIALOGCMD")
        {
            key who =  llList2Key(tk, 1);
            string opt = llList2String(tk, 2);
            doDialogCmd(who, opt);
        }
        else if (cmd == "WATER")
        {
            say("Aaah! Refreshing!");
            water = 100.;
            refresh();
        }
        else if (cmd == "FOOD")
        {
            say("Yummy yummy food");
            food = 100.;
            refresh();
        }
        else if (cmd == "NOSENSE")
        {
            food = 100;
            water = 100;
            say("Help! I can't find the "+FEEDER+"! Where did you put it?");
            doWander();
        }
        else if (cmd == "LISTENERKEY")
        {
            listenerKey = llList2Key(tk, 1);
            llSay(0, "Animal found!");
            osMessageObject(listenerKey, "CONTROLLERKEY|"+(string)llGetKey());
            osMessageObject(listenerKey, "SETRADIUS|"+(string)RADIUS);
            say("Hello!");
            setDialogOpts();
            llSetObjectName(TITLE);
            llSleep(.4);
            stopPos = osNpcGetPos(unpc);
            llSetTimerEvent(2);
        }
    }

    listen(integer c, string nm, key id, string m)
    {

        if (m == "Rez NPC")
        {
            doRezNpc();
        }
        else if (m =="SaveAppearance")
        {
            key k = id;
            llRemoveInventory("appearance");
            llSleep(1.);
            osAgentSaveAppearance(k, "appearance");
            llSay(0, "Saved appearance of "+llKey2Name(k));
        }
        else if (m == "Help")
        {
            llSay(0, "If you are having permission errors with the NPC in your region, it means you need to allow permissions for OSSL functions. You have to change the settings in your opensim.ini, or ask your sim host to change them for you. The settings you need to change are 'allow_osGetNotecard=true' and 'allow_osMessageObject=true'");
        }
        else if (m == "Remove NPC")
        {
            llSay(0, "Removing npc. ");
            osNpcRemove(unpc);
            unpc = NULL_KEY;
            llResetScript();
        }

    }

    touch_start(integer n)
    {
        if (llGetOwnerKey(llDetectedKey(0)) != llGetOwner()) return;

        list opts = [];
        if (unpc != NULL_KEY)
        {
            opts += "Remove NPC";
        }
        else
        {
            opts += "Rez NPC";

            //opts += "SaveAppearance";
        }

        opts += "Help";

        opts += "CLOSE";
        llSetTimerEvent(300);
        startListen();
        llDialog(llDetectedKey(0), "Select", opts, chan(llGetKey()));
    }

    state_entry()
    {
        lastTs = llGetUnixTime();
        PASSWORD = llStringTrim(osGetNotecard("sfp"), STRING_TRIM);
        loadConfig();

        refresh();
        llSay(0, "Touch to create / remove NPC");
        llSetText(llGetObjectName()+": "+firstName+" " +lastName, <1,1,1>, 1.0);
    }

    on_rez(integer n)
    {
        llResetScript();
    }

    timer()
    {


        integer ts = llGetUnixTime();
        if (ts > listenTs + 200)
        {
            checkListen();
        }

        refresh();

        if ( ts > waitTs)
        {

            if (targetTree != NULL_KEY )
            {
                if (llKey2Name(targetTree) != "")
                {
                    handleTree(targetTree);
                }
                lastTree = targetTree;
                targetTree = NULL_KEY;
                llSetTimerEvent(4);
                return;
            }

            if (followUser == NULL_KEY)
                doWander();
        }

        if (followUser!= NULL_KEY)
        {
            list res = llGetObjectDetails(followUser, [OBJECT_POS, OBJECT_ROT]);
            if (llGetListLength(res))
            {
                vector v = llList2Vector(res, 0)+ <0,1.4,0>*llList2Rot(res, 1);
                if (llVecDist(osNpcGetPos(unpc), v) >2)
                {
                    doWalk(v);
                }
            }
            else
                followUser = NULL_KEY;
        }
    }

    changed (integer c)
    {
        if (c & (CHANGED_REGION_START | CHANGED_REGION))
        {
            if (autoRez)
            {
                doRezNpc();
            }
        }
    }
}

 