// :CATEGORY:Vehicles
// :NAME:Boat
// :AUTHOR:Encog Dod
// :CREATED:2010-01-10 05:20:56.000
// :EDITED:2013-09-18 15:38:49
// :ID:108
// :NUM:149
// :REV:1.0
// :WORLD:Second Life
// :DESCRIPTION:
// Boat
// :CODE:
// From the book:
//
// Scripting Recipes for Second Life
// by Jeff Heaton (Encog Dod in SL)
// ISBN: 160439000X
// Copyright 2007 by Heaton Research, Inc.
//
// This script may be freely copied and modified so long as this header
// remains unmodified.
//
// For more information about this book visit the following web site:
//
// http://www.heatonresearch.com/articles/series/22/

float forward_power = 5; //Power used to go forward (1 to 30)
float reverse_power = -5; //Power ued to go reverse (-1 to -30)
float turning_ratio = .2; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
string sit_message = "SWIM"; //Sit message
string not_owner_message = "You are not the owner of this vehicle ..."; //Not owner message

integer shouldDie = 0;

//Anything past this point should only be modfied if you know what you are doing


psystem()
{
     llParticleSystem(
        [
            PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,
            PSYS_SRC_BURST_RADIUS,0.1,
            PSYS_SRC_ANGLE_BEGIN,-1,
            PSYS_SRC_ANGLE_END,1,
            PSYS_SRC_TARGET_KEY,llGetKey(),
            PSYS_PART_START_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_START_ALPHA,.6,
            PSYS_PART_END_ALPHA,0,
            PSYS_PART_START_GLOW,0,
            PSYS_PART_END_GLOW,0,
            PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
            PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
            PSYS_PART_START_SCALE,<2.30000,2.00000,0.000000>,
            PSYS_PART_END_SCALE,<1,1, 0.000000>,
            PSYS_SRC_TEXTURE,"3a7ea058-e486-4d21-b2e6-8b47462bb45b",
            PSYS_SRC_MAX_AGE,0,
            PSYS_PART_MAX_AGE,4,
            PSYS_SRC_BURST_RATE,0.05,
            PSYS_SRC_BURST_PART_COUNT,1,
            PSYS_SRC_ACCEL,<0.000000,0.000000,-1.500000>,
            PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
            PSYS_SRC_BURST_SPEED_MIN,0.7,
            PSYS_SRC_BURST_SPEED_MAX,0.8,
            PSYS_PART_FLAGS,
                0 |
                PSYS_PART_BOUNCE_MASK |
                PSYS_PART_EMISSIVE_MASK |
                PSYS_PART_INTERP_COLOR_MASK
        ]);
}



string curanim;

default
{
    
    on_rez(integer n)
    {
        llResetScript();   
    }
    
    state_entry()
    {
        llSetSitText(sit_message);
        // forward-back,left-right,updown
        llSitTarget(<0.,0, -.5>, ZERO_ROTATION );
        
        llSetCameraEyeOffset(<-6, 0.0, 3.0>);
        //llSetCameraAtOffset(<1.0, 0.0, 2.0>);
        
        //llPreloadSound("boat_start");
        //llPreloadSound("boat_run");
            llSetVehicleFlags(0);
        llSetVehicleType(VEHICLE_TYPE_BOAT);
        llSetVehicleFlags(VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_HOVER_WATER_ONLY);
        llSetVehicleVectorParam( VEHICLE_LINEAR_FRICTION_TIMESCALE, <1, 1, 1> );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_FRICTION_TIMESCALE, 2 );

        
        
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, 0, 0>);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.05);
        
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_TIMESCALE, 1 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, 0.15);
        llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 2.0 );
        llSetVehicleFloatParam( VEHICLE_BUOYANCY, 1 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, .5 );
        llSetVehicleRotationParam( VEHICLE_REFERENCE_FRAME, ZERO_ROTATION );
        shouldDie = 1;
        llSetTimerEvent(60);
    }
    
    changed(integer change)
    {
        
        
        if (change & CHANGED_LINK)
        {
            
            key agent = llAvatarOnLinkSitTarget(1);
            if (agent != NULL_KEY)
            {                
                /*if (agent != llGetOwner())
                {
                    llSay(0, not_owner_message);
                    llUnSit(agent);
                    llPushObject(agent, <0,0,50>, ZERO_VECTOR, FALSE);
                }
                else
                */
                {
                    //llTriggerSound("boat_start",1);
                    
                    
                    //llMessageLinked(LINK_ALL_CHILDREN , 0, "start", NULL_KEY);
                    llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
                    llSetLinkAlpha(2, 0.0, ALL_SIDES);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    
                    llSleep(.4);

                    //llLoopSound("boat_run",1);
                   
                    llSetTimerEvent(1);
                    shouldDie = 0;
                }

            }
            else
            {
                //llStopSound();
                
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSleep(.2);
                llReleaseControls();
                llTargetOmega(<0,0,0>,PI,0);
                llStopAnimation("swim");
                llStopAnimation("tread");
                llSetTimerEvent(0);
                llSetLinkAlpha(2,1.0, ALL_SIDES);
                llSetRot(ZERO_ROTATION);
                //llSleep(3);
                //llDie();
                shouldDie = 1;
                llSetTimerEvent(60);

            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
        }
            
    }
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        float speed = llVecMag(vel);

        //car controls
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power,0,0>);
            reverse=1;
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= speed / turning_ratio * reverse;
            //angular_motor.x += 15;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += speed / turning_ratio * reverse;
            //angular_motor.x -= 15;
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);

    } //end control   
    
    timer()
    {
        if (shouldDie)
        {
            llDie();
            return;
        }
        
        float vel = llVecMag(llGetVel());
        string an;
        if (vel >1.)
            an = "swim";
        else 
            an = "tread";
            
        if (an != curanim)
        {
            
            llStopAnimation(curanim);
            curanim = an;
            if (curanim == "tread")
            {
                llSetLinkPrimitiveParamsFast(3,[PRIM_POS_LOCAL, <0.0, 0.0, -0.55>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                llParticleSystem([]);
            }
            else
            {
                llSetLinkPrimitiveParamsFast(3,[PRIM_POS_LOCAL, <0.0, 0.0, -0.25>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                psystem();
            }
            llStartAnimation(curanim);
        }
        
    }
    
} //end default