integer getLinkByName(string name)
{
    integer i = llGetLinkNumber() != 0;
    integer x = llGetNumberOfPrims() + i;
    for(; i < x; ++i)
    {
        if(llGetLinkName(i) == name)
        {
            return i;
        }
    }
    return -1;
}

integer pendulumLink;
integer pendulumBaseLink;
vector toPendBase = <0, 0, -1.6>;
default
{
    state_entry()
    {
        llSetTimerEvent(0.2);
        pendulumLink = getLinkByName("Pendulum");
        pendulumBaseLink = getLinkByName("PendulumBase");
    }
    
    changed(integer change)
    {
        pendulumLink = getLinkByName("Pendulum");
        pendulumBaseLink = getLinkByName("PendulumBase");
    }
    
    timer()
    {
        float t = llGetWallclock();
        if((t % 2) >= 1)
        {
            t = t - llFloor(t);
            t = (0.5 - t) * 10;
        }
        else
        {
            t = t - llFloor(t);
            t = (t - 0.5) * 10;
        }
        //t=0;
        
        if(pendulumLink >= 0)
        {
            llSetLinkPrimitiveParamsFast(pendulumLink, [PRIM_ROT_LOCAL, llEuler2Rot(<0 * DEG_TO_RAD, t * DEG_TO_RAD, 90 * DEG_TO_RAD>)]);
        }
        if(pendulumBaseLink >= 0)
        {
            vector pendPos = toPendBase;
            rotation rot = llEuler2Rot(<0 * DEG_TO_RAD, t * DEG_TO_RAD, 0 * DEG_TO_RAD>);
            pendPos *= rot;
            pendPos += <0.0, 0.24, 2.5>;
            llSetLinkPrimitiveParamsFast(pendulumBaseLink,
                                    [PRIM_ROT_LOCAL, llEuler2Rot(<180 * DEG_TO_RAD, -t * DEG_TO_RAD, 0 * DEG_TO_RAD>),
                                    PRIM_POS_LOCAL, pendPos]);
        }
    }
} 