//
// ##################################################################################
//
// Simple Elevator
//
// Dorex Delicioso 2015-10-30 'Happy Halloween'
//
// To use, add script to a prim. 
// Set 'DistanceBetweenFloors' to the number of meters between each floor (distance to move)
// Set 'MetersPerSecond' to how many meters you want to move per second. (less is slower)
// Set 'ListenChannel' to what ever channel you want this to listen on 
//
// *****  If you reposition the prim, you must reset the script so it knows where the bottom floor is
//
// Stand on the prim
// type /3 {floor} in local chat
//
// Using an open listen channel is a really bad way of doing this, but it is for 
// example only and this is meant to be part of a larger build.
// A better way would be Link_Message, linked to a prim with floor selectors on it.
//
// ##################################################################################
//
float MetersPerSecond=4.0;       // how fast it moves in meters per second
float DistanceBetweenFloors=8.0;  // how far between floors
integer ListenChannel=3;        // what channel do we listen on
 
vector Floor1;
 
doMove(string floor)
{
    //
    // only try to move on floor numbers that are positive integers
    //
    if ((string)((integer)floor)==floor){        
        //
        // if floor is an integer
        //
        integer floorNumber=(integer)floor;
        if(floorNumber>0){                     
            //
            // if floor > 0
            //
            floorNumber--;        
            vector pos=llGetPos();
            //
            // what is the distance between the floor we want and where we are?
            //
            float distance = Floor1.z + floorNumber*DistanceBetweenFloors - pos.z;
            //
            // how long should it take us to get there
            //
            float time=llFabs(distance/MetersPerSecond);
            llSetKeyframedMotion( [<0.0,0.0,distance>, <0.0,0.0,0.0,1.0>, time], [KFM_MODE ,KFM_FORWARD]); 
        }    
    }
}
 
default{
 
    on_rez( integer start_param)
    {
        llResetScript();
    }
    
    state_entry()
    {
        llSetText("Magic Carpet", <1,1,1>,1.0);
        //
        // remember the first floor position
        //
        Floor1=llGetPos();           
        llSetPrimitiveParams([PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_CONVEX]);
        
        llListen(ListenChannel,"", NULL_KEY, "");       
    }
    
    listen(integer channel, string name, key id, string message) {
        doMove(message);    
    }
 
}
 