integer DISPLAY_STRING      = 204000; 
integer DISPLAY_EXTENDED    = 204001; 
integer REMAP_INDICES       = 204002; 
integer RESET_INDICES       = 204003; 
integer SET_FADE_OPTIONS    = 204004; 
integer SET_FONT_TEXTURE    = 204005; 
integer SET_LINE_COLOR      = 204006; 
integer SET_COLOR           = 204007; 
integer RESCAN_LINKSET      = 204008;

float   timering    = 120;
string  _buffer   = "";
list    log       = [];
string  region_name;
integer span;
float   fps_avg;
float   dilation_avg;
integer restarts  = 0;
string  startDate;
string  date      = "";

string FormatDecimal(float number, integer precision)
{
    float roundingValue = llPow(10, -precision)*0.5;
    float rounded;
    if (number < 0) rounded = number - roundingValue;
    else            rounded = number + roundingValue;
 
    if (precision < 1) // Rounding integer value
    {
        integer intRounding = (integer)llPow(10, -precision);
        rounded = (integer)rounded/intRounding*intRounding;
        precision = -1; // Don't truncate integer value
    }
 
    string strNumber = (string)rounded;
    return llGetSubString(strNumber, 0, llSubStringIndex(strNumber, ".") + precision);
}

 hoverText()
{
    string _date = llGetDate();
    if(date == _date)
        span++;
    else // daily reset of the average FPS and dilation
    {
        span = 1;
        date = _date;
        fps_avg = 0;
        dilation_avg = 0;
    }
 
    float fps = llGetRegionFPS();
    fps_avg += fps;
    float dilation = llGetRegionTimeDilation();
    dilation_avg += dilation;
    string message = "";
     
            message = region_name;
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"0");
            message = "FPS avg: " + FormatDecimal(fps_avg/span, 0)  + ", last: " + FormatDecimal(fps, 0);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"1");
            message = "Dilation avg: " + FormatDecimal(dilation_avg/span,2) + ", last: " + FormatDecimal(dilation,2);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"2");
            message = "Restarts since " + startDate + ": " + (string)restarts;
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"3");
            message = llList2String(log,0);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"4");
            message = llList2String(log,1);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"5");
            message = llList2String(log,2);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"6");
            message = llList2String(log,3);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"7");
            message = llList2String(log,4);
            llMessageLinked(LINK_THIS,DISPLAY_STRING,message,"8");
}

default
{
    state_entry()
    {
        region_name = llGetRegionName();
        startDate = llGetDate();
        hoverText(); // display hover text
        llSetTimerEvent(timering); // starting our timer
    }
    
   on_rez(integer num)
    {
        llResetScript();
    }
    
   changed(integer change)
    {
        if (change & CHANGED_REGION_START)
        { // log region restart
            restarts++;
            string timestamp = llGetTimestamp();
            list temp = llParseString2List(timestamp,["T",":","."],[]);
            log += llList2String(temp,0) + " - " + llList2String(temp,1) + ":"
                + llList2String(temp,2) + ":" + llList2String(temp,3);
            if(llGetListLength(log) > 5) // limit log entries to avoid hovertext truncation
                log = llDeleteSubList(log,0,0);
        }
    }
 timer()
    {
        hoverText(); // display hover text
    }
} 