// V1 //
 
integer on; // Establish "on" as a global variable so that we can remember whether or not the flame is on.
 
Flame(integer num)
{
    if(num) // Do we or don't we make a flame? Num is either TRUE or FALSE (1 or 0).
    {
        llParticleSystem([PSYS_PART_FLAGS, 275, // Make the flame since the condition above was met.
        PSYS_SRC_PATTERN, 4,
        PSYS_PART_START_ALPHA, 0.6,
        PSYS_PART_END_ALPHA, 0.0,
        PSYS_PART_START_COLOR, <1.0, 1.0, 0.3>,
        PSYS_PART_END_COLOR, <0.8, 0.6, 0.6>,
        PSYS_PART_START_SCALE, <0.04, 0.07, 0.0>,
        PSYS_PART_END_SCALE, <0.04, 0.04, 0.0>,
        PSYS_PART_MAX_AGE, 0.3,
        PSYS_SRC_MAX_AGE, 0.0,
        PSYS_SRC_ACCEL, <0.0, 0.0, 0.02>, // These are the parameters of the particle effect.
        PSYS_SRC_ANGLE_BEGIN, 0.0,
        PSYS_SRC_ANGLE_END, 0.0,
        PSYS_SRC_BURST_PART_COUNT, 50,
        PSYS_SRC_BURST_RATE, 0.07,
        PSYS_SRC_BURST_RADIUS, 0.0,
        PSYS_SRC_BURST_SPEED_MIN, 0.001,
        PSYS_SRC_BURST_SPEED_MAX, 0.4,
        PSYS_SRC_OMEGA, <0.0, 0.0, 0.0>,
        PSYS_SRC_TARGET_KEY,(key)"",
        PSYS_SRC_TEXTURE, ""]);
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE, <1.0, 0.8, 0.3>, 0.5, 2.0, 1.9,  // For extra effect we switch the light on too.
                              PRIM_COLOR, ALL_SIDES, <1.0,1.0,1.0>, 0.1, // And set the transparency to slightly visible.
                              PRIM_GLOW, ALL_SIDES, 0.1]); // And the glow to slight.
    }
    else // Num was not 1 (TRUE) so we need to stop the effect or not start it.
    {
        llParticleSystem([]); // Make no particles (no flame).
        llSetPrimitiveParams([PRIM_POINT_LIGHT, FALSE, ZERO_VECTOR, 0.0, 0.0, 0.0,  // Switch the light off.
                              PRIM_COLOR, ALL_SIDES, <1.0,1.0,1.0>, 0.0, // And set the transparency to invisible.
                              PRIM_GLOW, ALL_SIDES, 0.0]); // And the glow to zero.
    }
    on = num; // Establish the value of the global variable "on" as being equal to the task we just performed. This acts as our memory.
}
 
default // Create a state for the code to run in.
{
    state_entry() // On entering that state make the candle flame ignite.
    {
        llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_SPHERE, 0, <0.0,1.0,0.0>, 0.0, ZERO_VECTOR, <0.0,1.0,0.0>, // Make the prim a sphere.
                              PRIM_SIZE, <0.01,0.01,0.03>, // Make the prim the right size to act as the glowing center of the flame.
                              PRIM_TEXTURE, ALL_SIDES, TEXTURE_BLANK, ZERO_VECTOR, ZERO_VECTOR, 0.0]); // Set the blank texture.
        Flame(TRUE); // Flame(TRUE); Is an order to run the code "Flame" with the integer value "TRUE" (numerical value = 1).
    }
    touch_end(integer detected) // Detect if we have touched the candle.
    {
        Flame(!on); // We now order that the Flame() code is run with the integer value that is the oposite of what it already is.
        // (!on) = FALSE if on = TRUE and TRUE if on = FALSE. The "!" means "not".
    }
}

