// MODIFIED by talista.elon@osgrid to use new API that shouldn't expire/limit

integer MENUCHAN = -14856350;
integer translating = -1;
integer settingup = -1;
key owner;
string menu = "";
string native = "en";
string foreign = "fr";

Translate(string text)
{
    string query = "https://translate.googleapis.com/translate_a/single";
    query = query + "?client=gtx&sl=" + native + "&tl=" + foreign + "&dt=t&q=" + text;
    llHTTPRequest(query, [], "");
}


integer isOn() {
    return (integer)llList2String(llGetLinkPrimitiveParams(2, [PRIM_DESC]), 0);
}

onOff(integer on) {
    float offset = 0.95;
    if (on) {
        offset = -0.95;
        translating = llListen(0, "", "", "");
    }
    else {
        llListenRemove(translating);
        translating = -1;
    }
    llSetLinkPrimitiveParamsFast(2, [
        PRIM_TEXTURE, 0, "3f39b2d3-204c-4a63-a7ac-4c18773bc98c", <0.1, 0.1, 0.0>, <offset, -0.75, 0.0>, 0.0,
        PRIM_DESC, (string)on
    ]);
}

setup() {
    onOff(FALSE);
    llListen(MENUCHAN, "", owner, "");
    menu = "native";
    dialog(1);
}

dialog(integer page) {
    list btns;
    if (1 == page) {
        btns = [ "sq", "[Page 2]", "[Page 3]", "pt", "nl", "sv", "it", "es", "fr", "en", "ru", "de" ];
    }
    else if (2 == page) {
        btns = [ "el", "[Page 1]", "[Page 3]", "zh", "da", "fi", "ca", "hr", "cs", "ar", "sr", "bg" ];
    }
    else if (3 == page) {
        btns = [ "[Close]", "[Page 1]", "[Page 2]", "ja", "ko", "no", "hy", "hu", "id", "pl", "ro", "tr" ];
    }
    if (btns != []) {
        if (~settingup) {
            settingup = llListen(MENUCHAN, "", owner, "");
        }
        llDialog(owner, "\n\nChoose your " + menu + " language:", btns, MENUCHAN);
        llSetTimerEvent(60.0);
    }
}

close() {
    if (~settingup) {
        llListenRemove(settingup);
        settingup = -1;
        llSetTimerEvent(0.0);
    }
}

default {
    on_rez(integer n) {
        if (owner != llGetOwner()) {
            llResetScript();
        }
        else if (llGetAttached() > 0) { // do things when it's attached
            onOff(isOn());
        }
    }
    changed(integer what) {
        if (CHANGED_OWNER & what) {
            llResetScript();
        }
    }
    state_entry() {
        llOwnerSay("Reset.");
        owner = llGetOwner();
        llSetText("", ZERO_VECTOR, 0.0);
        setup();
    }
    touch_start(integer n) {
        if (llDetectedLinkNumber(0) == 2) {
            onOff(1 - isOn());
        }
        else { // the globe: setup
            llListen(MENUCHAN, "", owner, "");
            menu = "native";
            dialog(1);
        }
    }
    listen(integer channel, string name, key id, string msg) {
        if (0 == channel && id == owner) { // translate
            Translate(llEscapeURL(msg));
        }
        else if (MENUCHAN == channel && llGetOwnerKey(id) == owner) {
            if ("[Page 2]" == msg) {
                dialog(2);
            }
            else if ("[Page 3]" == msg) {
                dialog(3);
            }
            else if ("[Page 1]" == msg) {
                dialog(1);
            }
            else if ("[Close]" == msg) {
                close();
            }
            else {
                if ("native" == menu) {
                    native = msg;
                    menu = "foreign";
                    dialog(1);
                }
                else if ("foreign" == menu) {
                    foreign = msg;
                    menu = native + " → " + foreign;
                    llSetObjectDesc(native + ":" + foreign); // TODO: add auto setup from description
                    llOwnerSay("Translation " + menu + " active");
                    llSetText(menu, <1.0, 1.0, 1.0>, 1.0);
                    menu = "";
                    onOff(TRUE);
                }
            }
        }
    }
    timer() {
        close();
    }

    http_response(key id, integer status, list meta, string body) {
        
        
        list response = llJson2List(body);
        response = llJson2List(llList2String(response, 0));
        response = llJson2List(llList2String(response, 0));
        string obj = llGetObjectName();
        llSetObjectName(llKey2Name(owner) + " [" + native + "→" + foreign + "]");
        llSay(0, llList2String(response, 0));
        llSetObjectName(obj);
    }
}
 