//Damn Fast Relay, by Satomi Ahn
//
//This is a minimalist RLV Relay intended for laggy playgrounds, with the aim of making the answer to scan requests as fast as possible and decreasing the global lag.
//It only features the auto-accept mode but tries to fully comply to ORG 003 specifications.
//Touching the relay will make it release restrictions and reset (in other words: safewording).
//
//This script is provided as-is with mo guarrantee whatsoever.
//Feel free to use the code in anyway you want, provided you credit the original author, ie: myself, Satomi Ahn.
//(can be seen as a BSD-style license)

integer rlvrc = -1812221819;
integer viewerlistener;
float TouchTime = 0.0;
key source = NULL_KEY;
key wearer = NULL_KEY;
key sitid;
list restrictions = [];

release(key id) {
    llOwnerSay("@clear");
    llRegionSayTo(id, rlvrc, "release,"+(string)id+",!release,ok");
    llResetScript();
}

default {
    state_entry() {
        llSetMemoryLimit(16384); // new in v3
        llSetLinkAlpha(2,1.0,3);llSetLinkAlpha(2,0.0,2);llSetLinkColor(2,<0.2,0.7,0.0>,0);//beautyMod by Eve
        wearer = llGetOwner();
        llListen(rlvrc,"", NULL_KEY, "");
    }

    touch_start(integer total_number) {TouchTime=llGetTime();}
    
    touch_end(integer total_number) {if(1.2>(llGetTime()-TouchTime)) return;
        llOwnerSay("OwnerSay: Now safewording. Restrictions will be removed and the relay reset.");
        release(source);
    }
    
    listen(integer c, string w, key id, string msg) {
        if (c == 12345) {
            if (msg) sitid = (key) msg;
            llListenRemove(viewerlistener);
            return;
        } //llOwnerSay("heard["+(string)c+"]:"+msg); 
    
        if ((source!=NULL_KEY)&&(source!=id)) {
            //llOwnerSay("source="+(string)source); 
            return; // Sorry, already grabbed by another device
        } 
        list args = llParseStringKeepNulls(msg,[","],[]);
        if (llGetListLength(args)!=3) return; //else llOwnerSay("incorrect number of args");
        if (llList2Key(args,1)!=wearer && llList2Key(args,1)!=(key)"ffffffff-ffff-ffff-ffff-ffffffffffff") {
            llOwnerSay("message not for wearer"); 
            return;
        }
        string ident = llList2String(args,0);
        list commands = llParseString2List(llList2String(args,2),["|"],[]);
        integer i;
        string command;
        integer nc = llGetListLength(commands);
        for (i=0; i<nc; ++i) {
            command = llList2String(commands,i);
            if (llGetSubString(command,0,0)=="@") {
                llOwnerSay(command);
                llRegionSayTo(id, rlvrc, ident+","+(string)id+","+command+",ok");
                list subargs = llParseString2List(command, ["="], []);
                string behav = llGetSubString(llList2String(subargs, 0), 1, -1);
                integer index = llListFindList(restrictions, [behav]);
                string comtype = llList2String(subargs, 1);                
                if (comtype == "n" || comtype == "add") {
                    if (index == -1) restrictions += [behav];
                    if (behav == "unsit" && llGetAgentInfo(wearer) & AGENT_SITTING) {
                        viewerlistener = llListen(12345, "", wearer, "");
                        llOwnerSay("@getsitid=12345");
                    }
                }
                else if (comtype=="y" || comtype == "rem") {
                    if (index != -1) restrictions = llDeleteSubList(restrictions, index, index);
                    if (behav == "unsit") sitid = NULL_KEY;
                }
            }
            else if (command=="!pong") {
                    llOwnerSay("@sit:"+(string)sitid+"=force,"+llDumpList2String(restrictions, "=n,")+"=n");
                    llSetTimerEvent(0);
            }
            else if (command=="!version") {llOwnerSay("version request");
                llRegionSayTo(id, rlvrc, ident+","+(string)id+",!version,1100");
            }
            else if (command=="!implversion") llRegionSayTo(id, rlvrc, ident+","+(string)id+",!implversion,ORG=0003/Satomi's Damn Fast Relay v3");
            else if (command=="!x-orgversions") llRegionSayTo(id, rlvrc, ident+","+(string)id+",!x-orgversions,ORG=0003");
            else if (command=="!release") release(id);
            else llRegionSayTo(id, rlvrc, ident+","+(string)id+","+command+",ko");            
        }
        if (llGetListLength(restrictions)>0) { source = id; llOwnerSay("@detach=n"); 
        llSetLinkAlpha(2,1.0,2);llSetLinkAlpha(2,0.0,3);llSetLinkColor(2,<0.9,0.0,0.0>,0);//beautyMod by Eve
        }
        else { llOwnerSay("@clear"); llResetScript(); }
    }
    
    changed(integer c) {
        if (c & CHANGED_OWNER) llResetScript();
    }
    
    on_rez(integer i) {
        if (source) {
            llSleep(30);
            llRegionSayTo(source, rlvrc, "ping,"+(string)source+",ping,ping");
            llSetTimerEvent(30);
        }
    }
    
    timer() {
        llResetScript();
    }
    //no-script zone hack (requires to activate script 50m above no-script zone first)
    attach(key k) {if(k) llRequestPermissions(k, PERMISSION_TAKE_CONTROLS|PERMISSION_TRIGGER_ANIMATION);}    
    run_time_permissions(integer p) {if(PERMISSION_TAKE_CONTROLS&p) {llTakeControls(CONTROL_FWD, TRUE, TRUE);}}
}