// name, factor, texture
list SPANKTYPE = [
    "Red",  1.0, "f8ff6cdf-ee21-4f18-8971-f381e6917185",
    "Hand", 1.0, "3caa88ad-8712-473e-9b99-a26b73064112",
    "Burn", 1.2, "25f2636c-f0ba-4ad6-95fe-c30af08f94b1",
    "Cane", 1.5, "5ed11843-848d-4d72-93dd-769a43ed6487",
    "Whip", 2.0, "19fd4324-6b95-4a9c-8874-3bd4c8444439"
];
// name, factor, fade holding time (minutes)
list STRENGTHES = [
    "Soft", 1.0, 1,
    "Strong", 1.2, 2,
    "Hard", 1.5, 5
];

integer public;
integer sound;
integer chat;
integer anim;
integer type;
integer strength;
integer rlv;

list white;
list black;
integer holding;
integer chan;
integer setup;
string menu;
key spanker;
integer rlast;
integer llast;

integer rlvlock;
integer rlvblur;

ownSay(string msg) {
    llInstantMessage(llGetOwner(), msg);
}

string bool2Text(integer on) {
    return llList2String(["Off", "On"], (on != 0));
}

// gives a link to the user's profile
string nameURI(key who) {
    return "secondlife:///app/agent/" + who + "/inspect";
}

integer key2chan(integer positive) {
    return (-1 + (positive ==TRUE)*2) * ((integer)("0x" + (string)llGetKey()) & 0x7fffffff);
}

loadConfig() {
    list l = llParseString2List(llList2String(llGetLinkPrimitiveParams(2, [PRIM_DESC]), 0), [","],[]);
    if (llGetListLength(l) > 0) {
        public = (integer)llList2String(l, 0);
        sound = (integer)llList2String(l, 1);
        chat = (integer)llList2String(l, 2);
        anim = (integer)llList2String(l, 3);
        type = (integer)llList2String(l, 4);
        strength = (integer)llList2String(l, 5);
        rlv = (integer)llList2String(l, 6);
    }
    else {
        public = TRUE;
        sound = TRUE;
        chat = TRUE;
        anim = TRUE;
        strength = 0;   // Soft by default
        rlv = FALSE;
        integer n = llListFindList(SPANKTYPE, [llList2String(llGetLinkPrimitiveParams(2, [PRIM_TEXTURE, 0]), 0)]);
        if (~n) type = n - 2;
        else type = 0;       // Red by default
        saveConfig();
    }
}

saveConfig() {
    llSetLinkPrimitiveParamsFast(2, [PRIM_DESC, llDumpList2String([public, sound, chat, anim, type, strength, rlv], ",")]);
}

// returns TRUE is allowed, FALSE if not
integer isAllowed(key id) {
    if (~llListFindList(black, [id])) {
        ownSay("blacklisted " + nameURI(id) + " tried to spank you");
        return FALSE;
    }
    if (public || id == llGetOwner()) return TRUE;
    integer n = llListFindList(white, [id]);
    if (!~n) ownSay("non whitelisted " + nameURI(id) + " tried to spank you");
    return (n > -1);
}

// shortcut to call llDialog()
dlg(string txt, list btns) {
    while (llGetListLength(btns) % 3) btns += " ";
    llDialog(llGetOwner(), txt, llList2List(btns,9,11) + llList2List(btns,6,8) + llList2List(btns,3,5) + llList2List(btns,0,2), chan);
}

dlgStop() {
    menu = "";
}

dlgSetup() {
    menu = "SETUP";
    dlg("\nChange your spanker settings." +
        "\nWARNING: spanker inactive during setup. Use Close\n" +
        "\nSpank Type: " + llList2String(SPANKTYPE, type) +
        "\nStrength: " + llList2String(STRENGTHES, strength) +
        "\nPublic Access: " + bool2Text(public) +
        "\nSound: " + bool2Text(sound) +
        "\nChat: " + bool2Text(chat) +
        "\nAnimation: " + bool2Text(anim) +
        "\nRLV: " + bool2Text(rlv),
        [
            "Spank Type", "Strength", "RLV",
            "Sound", "Chat", "Anim",
            "Access", "Get Help", "Close"
        ]);
}

dlgType() {
    menu = "TYPE";
    dlg("\nSet the mark type.\nCurrent: " + llList2String(SPANKTYPE, type) +
        "\nForce Setup: " + bool2Text(setup) +
        "\n\nNote that from the type depends the strength of spanks (reddening speed):" +
        "\n• Red and Hand are soft\n• Burn and Cane are stronger\n• Whip is hard",
        llList2ListStrided(SPANKTYPE, 0, -1, 3) + [ "Force Setup", "▲ Back" ]
    );
}

dlgStrength() {
    menu = "STRENGTH";
    dlg("\nStrength will apply a factor to the reddening speed, and fading to normal." +
        "\nThe stronger the strength, the faster the reddening, and slower the fading." +
        "\nNote that spank type and close spanks increase the strength too" +
        "\nCurrent strength: " + llList2String(STRENGTHES, strength),
        llList2ListStrided(STRENGTHES, 0,-1, 3) + [ "▲ Back" ]);
}

dlgAccess() {
    menu = "ACCESS";
    dlg("\nChange the access to your ass." +
        "\nPublic Access: " + bool2Text(public) +
        "\nPeople in whitelist: " + (string)llGetListLength(white) +
        "\nPeople in blacklist: " + (string)llGetListLength(black), [
            "Add White", "Rem White", "List White",
            "Add Black", "Rem Black", "List Black",
            "Public", " ", "▲ Back"
        ]);
}

dlgInput(string type, string txt) {
    menu = type;
    llTextBox(llGetOwner(), "\n" + txt, chan);
}

// add an avatar to the white or black list
addList(string type, string id) {
    if (id != "") {
        list l;
        if (type == "white") l = white;
        else { type = "black"; l = black; }
        if (!~llListFindList(l, [id])) {
            l += id;
            ownSay(nameURI(id) + " added to " + type + "list.");
            if (type == "white") white = l;
            else black = l;
        }
    }
    dlgAccess();
}

// remove an avatar from the white or black list
remList(string type, string id) {
    if (id != "") {
        list l;
        if (type == "white") l = white;
        else { type = "black"; l = black; }
        integer n = llListFindList(l, [id]);
        if (~n) {
            l = llDeleteSubList(l, n, n);
            ownSay(nameURI(id) + " removed from " + type + "list.");
            if (type == "white") white = l;
            else black = l;
        }
    }
    dlgAccess();
}

// dump the white or black list
listList(string type) {
    list l;
    if (type == "white") l = white;
    else { type = "black"; l = black; }
    integer i;
    ownSay("Your current " + type + "list:");
    string objName = llGetObjectName();
    llSetObjectName(" ");
    for (i = 0; i < llGetListLength(l); ++i)
        ownSay(nameURI(llList2String(l, i)));
    llSetObjectName(objName);
    dlgAccess();
}

// get the current step from the prim alpha
float curCheek(integer link) {
    return llList2Float(llGetLinkPrimitiveParams(link, [PRIM_COLOR, 0]), 1);
}

// force ass to full red or clear
forceCheeks(integer red) {
    float r = 0.0; float l = 0.0;
    if (!red) {
        list desc = llParseString2List(llList2String(llGetLinkPrimitiveParams(3, [PRIM_DESC]), 0), [","], []);
        if (llGetListLength(desc) > 0) {
            r = (float)llList2String(desc, 0);
            l = (float)llList2String(desc, 1);
            llSetLinkPrimitiveParamsFast(3, [PRIM_DESC, ""]);
        }
    }
    else {
        llSetLinkPrimitiveParamsFast(3, [PRIM_DESC, llDumpList2String([curCheek(2), curCheek(3)], ",")]);
        r = 1.0;
        l = 1.0;
    }
    llSetLinkAlpha(2, r, 0);
    llSetLinkAlpha(3, l, 0);
    red = (r > 0.0 || l > 0.0);
    if (rlv && red != rlvlock) {
        // forbid/allow detach
        rlvlock = red;
        llOwnerSay("@detach=" + llList2String(["n","y"], rlvlock));
    }
}

// returns the sound to play depending on the current state
string state2Sound(float step, integer last) {
    if (llGetUnixTime() - last < 2 && step > 0.5) return "Breath";
    return "Full0" + (string)(1 + (integer)llFrand(4));
}

// the interesting part ;-)
spank(integer part) {
    part -= 2;
    // calculate the amount for this spank, depending on type and strength
    float factor = llList2Float(SPANKTYPE, type+1) * llList2Float(STRENGTHES, strength+1);
    float incr = factor * 0.02;
    float val = curCheek(part);

    if (val < 0.5) incr *= 5.0; // make it smoother after half the course
    val += incr;
    if (val > 1.0) val = 1.0;
    llSetLinkAlpha(part, val, 0);

    integer last = llList2Integer([rlast, llast], (part - 2));

    // process optional parts
    if (sound)
        llPlaySound(state2Sound(val, last), 1.0);
    if (anim && (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION))
        llStartAnimation("spankass");
    if (chat) {
        string objname = llGetObjectName();
        llSetObjectName(" ");
        string who = "her own";
        if (spanker != llGetOwner()) who = nameURI(llGetOwner()) + "'s";
        llSay(0, nameURI(spanker) + " spanked " + who + " " + llList2String(["right", "left"], (part - 2)) + " ass cheek.");
        llSetObjectName(objname);
    }
    if (rlv) {
        if (val > 0.5 & llGetUnixTime() - last < 2 && !rlvblur) {
            rlvblur = TRUE;
            llOwnerSay("@setdebug_renderresolutiondivisor:5=force");
        }
    }
    last = llGetUnixTime();
    if (part == 2) rlast = last;
    else llast = last;
    llSetTimerEvent(factor); // each second until there nothing more to do
}

float fadeCheek(integer link, integer last) {
    float val = curCheek(link);
    integer elapsed = llGetUnixTime() - last;
    if (val > 0.0 &&  elapsed > llList2Integer(STRENGTHES, strength+2) * 60) {
        float factor = llList2Float(SPANKTYPE, type+1) * llList2Float(STRENGTHES, strength+1);
        float decr = 0.001 / factor;

        if (val < 0.1) decr *= 100.0; // at the end, fade quickly
        else if (val < 0.3) decr *= 10.0;
        else if (val < 0.5) decr *= 3.0;
        else if (val < 0.8) decr *= 0.5;
        val -= decr;
        if (val < 0.0) val = 0.0;
        llSetLinkAlpha(link, val, 0);
    }
    return val;
}

rlvCheck() {
    ownSay("Wait for RLV initialization...");
    integer chan = key2chan(TRUE);
    llListen(chan, "", "", "");
    llOwnerSay("@versionnew="+(string)chan);
    rlv = -1;
    llSetTimerEvent(60.0); // max initialization time
}

rlvEnable(string msg) {
    llSetTimerEvent(0.0);
    list vers = llParseString2List(msg, [" "], [""]);
    ownSay("RLV " + llList2String(vers, 2) + " ready. " + llDumpList2String(llList2List(vers, 3, 4), " "));
    rlv = TRUE;
}

rlvFailed() {
    llSetTimerEvent(0.0);
    ownSay("Viewer didn't reply to RLV initialization, disabling.");
    rlv = FALSE;
    saveConfig();
}

default {
    changed(integer w) {
        if (w & CHANGED_OWNER) llResetScript();
    }
    attach(key id) {
        if (id != NULL_KEY) llResetScript();
    }
    state_entry() {
        loadConfig();
        if (rlv) rlvCheck();
        else state spank;
    }
    listen(integer channel, string name, key id, string msg) {
        if (id != llGetOwner()) return;
        rlvEnable(msg);
        state spank;
    }
    timer() {
        rlvFailed();
        state spank;
    }
}

state spank {
    attach(key id) {
        if (id != NULL_KEY) {
            forceCheeks(FALSE);
            if (rlv) state default; // recheck RLV
            llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
        }
    }
    state_entry() {
        if (curCheek(2) > 0.0 || curCheek(3) > 0.0) {
            float factor = llList2Float(SPANKTYPE, type+1) * llList2Float(STRENGTHES, strength+1);
            llSetTimerEvent(factor); // setup disables the timer
        }
        llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
    }
    run_time_permissions(integer perm) {
    }

    touch_start(integer n) {
        if (llDetectedKey(0) != llGetOwner()) return;
        holding = FALSE;
        llResetTime();
    }
    touch(integer n) {
        if (llDetectedKey(0) != llGetOwner() || holding || llGetTime() < 1.0) return;
        holding = TRUE;
        state setup;
    }
    touch_end(integer n) {
        if (holding) holding = FALSE;
        else {
            if (isAllowed(llDetectedKey(0))) {
                spanker = llDetectedKey(0);
                spank(llDetectedLinkNumber(0));
            }
        }
    }
    timer() {
        float r = fadeCheek(2, rlast);
        float l = fadeCheek(3, llast);
        if (r == 0.0 && l == 0.0) {
            llSetTimerEvent(0.0);
            if (rlvlock) {
                // enable detach
                llOwnerSay("@detach=y");
                ownSay("Ass clean, unlocked");
                rlvlock = FALSE;
            }
        }
        else if (rlv) {
            if (!rlvlock) {
                llOwnerSay("@detach=n");
                ownSay("Locked by RLV");
                rlvlock = TRUE;
            }
            if (rlvblur) {
                llOwnerSay("@setdebug_renderresolutiondivisor:1=force");
                rlvblur = FALSE;
            }
        }
    }
}

state setup {
    attach(key id) {
        if (id != NULL_KEY) state default;
    }
    state_entry() {
        llSetTimerEvent(0.0);
        chan = key2chan(FALSE);
        llListen(chan, "", llGetOwner(), "");
        setup = FALSE;
        dlgSetup();
    }
    state_exit() {
        saveConfig();
        if (setup) forceCheeks(FALSE);
    }
    touch_start(integer n) {
        if (llDetectedKey(0) == llGetOwner()) {
            if (menu == "SETUP") dlgSetup();
            else if (menu == "TYPE") dlgType();
            else if (menu == "STRENGTH") dlgStrength();
            else if (menu == "ACCESS") dlgAccess();
        }
    }
    listen(integer channel, string name, key id, string msg) {
        if (id != llGetOwner()) return;
        if (channel != chan) {
            rlvEnable(msg);
            return;
        }
        if (msg == "Close") { dlgStop(); state default; }
        else if (msg == "▲ Back") dlgSetup();
        else if (menu == "SETUP") {
            if (msg == "Spank Type") dlgType();
            else if (msg == "Strength") dlgStrength();
            else if (msg == "RLV") {
                // mostly improbable but: if the user uncheck RLV while check is performed, force it to FALSE
                if (rlv == -1) rlv = FALSE;
                else rlv = 1 - rlv;
                if (rlv) rlvCheck();
                dlgSetup();
            }
            else if (msg == "Sound") { sound = 1 - sound; dlgSetup(); }
            else if (msg == "Chat") { chat = 1 - chat; dlgSetup(); }
            else if (msg == "Anim") { anim = 1 - anim; dlgSetup(); }
            else if (msg == "Access") dlgAccess();
            else if (msg == "Get Help") { llGiveInventory(id, llGetInventoryName(INVENTORY_NOTECARD, 0)); }
            else dlgSetup();
        }
        else if (menu == "TYPE") {
            if (msg == "Force Setup") {
                setup = 1 - setup;
                forceCheeks(setup);
                dlgType();
            }
            else {
                integer n = llListFindList(SPANKTYPE, [msg]);
                if (~n) {
                    type = n;
                    // change the texture
                    msg = llList2String(SPANKTYPE, type+2);
                    llSetLinkTexture(2, msg, 0);
                    llSetLinkTexture(3, msg, 0);
                }
                if (setup) dlgType();
                else dlgSetup();
            }
        }
        else if (menu == "STRENGTH") {
            integer n = llListFindList(STRENGTHES, [msg]);
            if (~n) strength = n;
            dlgSetup();
        }
        else if (menu == "ACCESS") {
            if (msg == "Add White") dlgInput("ADDWHITE", "Enter the UUID of the person to add to the whitelist");
            else if (msg == "Rem White") dlgInput("REMWHITE", "Enter the UUID of the person to remove from the whitelist");
            else if (msg == "List White") listList("white");
            else if (msg == "Add Black") dlgInput("ADDBLACK", "Enter the UUID of the person to add to the blacklist");
            else if (msg == "Rem Black") dlgInput("REMBLACK", "Enter the UUID of the person to remove from the blacklist");
            else if (msg == "List Black") listList("black");
            else if (msg == "Public") { public = 1 - public; dlgAccess(); }
            else dlgAccess();
        }
        else if (menu == "ADDWHITE") addList("white", msg);
        else if (menu == "ADDBLACK") addList("black", msg);
        else if (menu == "REMWHITE") remList("white", msg);
        else if (menu == "REMBLACK") remList("black", msg);
    }
    timer() {
        rlvFailed();
    }
}
 