// Script Name: Texture_switch_Haydans.lsl
// Author: Anonymous
//texture swithcer menu driven

// Downloaded from : http://www.free-lsl-scripts.com/freescripts.plx?ID=1194

// This program is free software; you can redistribute it and/or modify it.
// License information must be included in any script you give out or use.
// This script is licensed under the Creative Commons Attribution-Share Alike 3.0 License
// from http://creativecommons.org/licenses/by-sa/3.0 unless licenses are
// included in the script or comments by the original author,in which case
// the authors license must be followed.

// Please leave any authors credits intact in any script you use or publish.
////////////////////////////////////////////////////////////////////
// CATEGORY:Texture
// DESCRIPTION:texture swithcer menu driven
// ARCHIVED BY:Ferd Frederix

list MENU1 = [];
list MENU2 = [];
integer listener;
integer MENU_CHANNEL = 1000;

// opens menu channel and displays dialog
Dialog(key id, list menu)
{
    llListenRemove(listener);
    listener = llListen(MENU_CHANNEL, "", NULL_KEY, "");
    llDialog(id, "Select one object below: ", menu, MENU_CHANNEL);
}

default
{
    on_rez(integer num)
    {
        // reset scripts on rez
        llResetScript();
    }

    touch_start(integer total_number)
    {
        if (llGetOwner() == llDetectedKey(0))
        {
        integer i = 0;
        MENU1 = [];
        MENU2 = [];
        // count the textures in the prim to see if we need pages
        integer c = llGetInventoryNumber(INVENTORY_TEXTURE);
        if (c <= 12)
        {
            for (; i < c; ++i)
                MENU1 += llGetInventoryName(INVENTORY_TEXTURE, i);
        }
        else
        {
            for (; i < 11; ++i)
                MENU1 += llGetInventoryName(INVENTORY_TEXTURE, i);
            if(c > 22)
                c = 22;
            for (; i < c; ++i)
                MENU2 += llGetInventoryName(INVENTORY_TEXTURE, i);
            MENU1 += ">>";
            MENU2 += "<<";
        }
        // display the dialog
        Dialog(llDetectedKey(0), MENU1);
    }
    }

    listen(integer channel, string name, key id, string message)
    {
        if (channel == MENU_CHANNEL)
        {
            llListenRemove(listener);
            if (message == ">>")
            {
                Dialog(id, MENU2);
            }
            else if (message == "<<")
            {
                Dialog(id, MENU1);
            }
            else
            {
                // display the texture from menu selection
                llSetTexture(message, ALL_SIDES);

            }
        }
    }
}
 // END //

