updclock(float timezone, integer military)
{    
    float cl = (llGetGMTclock()+timezone*3600)/3600.;

    float hrs =  cl%24;        //(cl%12)/12.;
    if (hrs >12.) hrs -=12;
    float mns = (hrs-llFloor(hrs));
    
    //llOwnerSay(" = "+(string)hrs);
    llSetLinkPrimitiveParams(3, [PRIM_ROT_LOCAL, llEuler2Rot(<-PI/2+ 2*hrs*PI/12 , PI, 0>)]);
    llSetLinkPrimitiveParams(2, [PRIM_ROT_LOCAL, llEuler2Rot(<-PI/2+2*mns*PI , PI,0>)]);
    
    if ((integer)hrs != lastHr)
    {
        lastHr = (integer)hrs;
        integer i;
        //llOwnerSay("lastHr = "+lastHr);
        integer bell = lastHr;
        if (lastHr ==0) bell = 12;
        for (i=0; i < bell; i++)
        {
            llTriggerSound("bell1", 1.0);
            llSleep(3);
        }
    }
    if ((integer)(mns) == 0)
    {
        for (integer i=0;i< lastHr;i++)
        {
            llPlaySound("bell1",1.0);
        }
    }
    if (((integer)mns) == 15)
    {
        llPlaySound("BigBen1", 1.0);
    }
    if (((integer)mns) == 30)
    {
        llPlaySound("BigBen1",1.0);
    }
    if (((integer)mns) == 45)
    {
        llPlaySound("BigBen1",1.0);
    }
}

integer lastHr =-1;
integer lastMin =-1;

default
{
    state_entry()
    {
        llSay(0, "Script running");
        llSetLinkPrimitiveParams(4, [PRIM_OMEGA, <1,0,0>, 2*PI/60., 1.0]);
        llSetTimerEvent(60);
    }
    
    timer()
    {
        updclock(-1,0 );
    }
} 