
float forward_power = 12; //Power used to go forward (1 to 30)
float reverse_power = -5; //Power ued to go reverse (-1 to -30)
float turning_ratio = .8; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
string sit_message = "Drive"; //Sit message
string not_owner_message = "You are not the owner of this vehicle ..."; //Not owner message
float WATERHEIGHT; 
integer effects =0;

integer LEFT_PROPELLER=34;
integer RIGHT_PROPELLER=32;

integer shouldDie = 0;
integer curwheel =-1;
integer treading=0;
//Anything past this point should only be modfied if you know what you are doing

wheel(integer w)
{
    float right = 8;
    float left = 8;
    if (w == 2)
        right= 1;
    else if (w ==1) 
        left=1;
    else if ( w == -1)
    {
        right =0;
        left =0;
    }
    

    llSetLinkPrimitiveParamsFast(RIGHT_PROPELLER, [PRIM_OMEGA, <1,0,0>,right, 1.0]);
    llSetLinkPrimitiveParamsFast(LEFT_PROPELLER, [PRIM_OMEGA, <1,0,0>, left, 1.0]);
}

psystem()
{
     llLinkParticleSystem(2,
        [
            PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,
            PSYS_SRC_BURST_RADIUS,1.5,
            PSYS_SRC_ANGLE_BEGIN,PI/2,
            PSYS_SRC_ANGLE_END,PI/4,
            PSYS_SRC_TARGET_KEY,llGetKey(),
            PSYS_PART_START_COLOR,<.99,.99,1.000000>,
            PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_START_ALPHA,.5,
            PSYS_PART_END_ALPHA,0,
            PSYS_PART_START_GLOW,0,
            PSYS_PART_END_GLOW,0,
            PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
            PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
            PSYS_PART_START_SCALE,<.050000,.05000,0.000000>,
            PSYS_PART_END_SCALE,<1,1, 0.000000>,
            PSYS_SRC_TEXTURE,"bubble",
            PSYS_SRC_MAX_AGE,0,
            PSYS_PART_MAX_AGE,8,
            PSYS_SRC_BURST_RATE,0.05,
            PSYS_SRC_BURST_PART_COUNT,5,
            PSYS_SRC_ACCEL,<.000000,0.000000,.0700000>,
            PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
            PSYS_SRC_BURST_SPEED_MIN,0.6,
            PSYS_SRC_BURST_SPEED_MAX,0.6,
            PSYS_PART_FLAGS,
                0 |
                PSYS_PART_INTERP_COLOR_MASK| PSYS_PART_INTERP_SCALE_MASK|     PSYS_PART_EMISSIVE_MASK
        ]);
}



init() {

        
       
        llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        //llPreloadSound("boat_start");
        //llPreloadSound("boat_run");
        //llSetVehicleFlags(0);
        llSetVehicleType(VEHICLE_TYPE_AIRPLANE);
       // llSetVehicleFlags(VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT);
        //llSetVehicleFlags(VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT); // | VEHICLE_FLAG_HOVER_WATER_ONLY);
        

        //llSetVehicleFloatParam(VEHICLE_HOVER_HEIGHT, llWater(ZERO_VECTOR));
        llSetVehicleFlags(VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT);
        
        llSetVehicleVectorParam( VEHICLE_LINEAR_FRICTION_TIMESCALE, <1. , 1. , .01> );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_FRICTION_TIMESCALE, 1. );

        
        
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, 0, 0>);
            
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 1. );
        
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_TIMESCALE, 1. );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 1. );

        llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 200.0 );
        llSetVehicleFloatParam( VEHICLE_BUOYANCY, 1.0 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, .5 );
        llSetVehicleRotationParam( VEHICLE_REFERENCE_FRAME, ZERO_ROTATION );
        shouldDie = 1;
        WATERHEIGHT = llWater(ZERO_VECTOR);
}


string curanim;

default
{
    
    on_rez(integer n)
    {
        llResetScript();   
    }
    
    state_entry()
    {
        
         
        llSetCameraEyeOffset(<-10, 0, 3>);
        llSetCameraAtOffset(<10, 0, 0>);
    
        
        llSetSitText(sit_message);
        // forward-back,left-right,updown
        llSitTarget(<.8, -.5, 1.1>, ZERO_ROTATION );
        
        llSetTimerEvent(300);
        
        
    }
    
    
    changed(integer change)
    {
        
        
        if (change & CHANGED_LINK)
        {
            
            key agent = llAvatarOnLinkSitTarget(1);
            if (agent != NULL_KEY)
            {                


                    llSetTimerEvent(0);
                    //llMessageLinked(LINK_ALL_CHILDREN , 0, "start", NULL_KEY);
                    llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS|PERMISSION_CONTROL_CAMERA);
                    //llSetLinkAlpha(2, 0.0, ALL_SIDES);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    
                    init(); 
            }
            else
            {
                llStopSound();
                
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSleep(.2);
                llReleaseControls();
                llTargetOmega(<0,0,0>,PI,0);
                vector rot = llRot2Euler(llGetRot());
                rot.x =0; rot.y=0;
                llSetRot(llEuler2Rot(rot));
                llLinkParticleSystem(2, []);
                llSetTimerEvent(300);
                wheel(-1);
            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            //llStopAnimation("sit");
            //llStartAnimation("stand1");
            
            llSetCameraParams([
                       CAMERA_ACTIVE, 1,                     // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 15.0,         // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 1.0,           // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 6.0,                 // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 20.0,                    // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.05,             // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 30.0,       // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,           // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.01 ,               // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.01,          // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <0.0,0.0,0.0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
                      
        }
            
    }
    
    
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;

        float speed = llGetVel()*(<1,0,0>*llGetRot());
        //car controls
        integer moving=0;
        float vz =0;
        
        if (level & CONTROL_UP) 
        { 
            vector pos = llGetPos();
            if (pos.z < WATERHEIGHT-3)
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power/4,0,4>);
        }
        else if (level & CONTROL_DOWN)    
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power/4,0,-8>);
        
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power,0,0>);
            reverse=1;
            if (!(edge & CONTROL_FWD))
                moving=1;
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,vz>);
            reverse = -1;




        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= speed / turning_ratio * reverse;
            angular_motor.x += 2;    
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += speed / turning_ratio * reverse;
            angular_motor.x -= 2;


        
        }
    
        integer wh = -1;
        
        if (moving>0 && !effects)
        {


            effects=1;
            psystem();
            llLoopSound("bleep1", 0.9);
        }
        else if (moving==0 && effects>0)
        {
            effects=0;
            llLinkParticleSystem(2,[]);
            llStopSound();
            //wh =  -1;
        }
        
        
         if ( level & CONTROL_BACK)                wh = (-1);

        else if ((level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT)))
                wh = (2);
        else        if ((level &(CONTROL_LEFT|CONTROL_ROT_LEFT)))                wh = 1;
        else if ( level & CONTROL_FWD)
                wh = (5); 
        else wh = -1;
        
        if (curwheel != wh)
        {
            curwheel = wh;
            wheel(wh);
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
       

    } //end control   
    
    timer()
    {
           llDie();
        
    }
    
} //end default