
integer getLinkByName(string name)
{
    integer i = llGetLinkNumber() != 0;
    integer x = llGetNumberOfPrims() + i;
    for(; i < x; ++i)
    {
        if(llGetLinkName(i) == name)
        {
            return i;
        }
    }
    return -1;
}

integer secondsLink;
integer minutesLink;
integer hoursLink;
float lastSec = -1;

default
{
    state_entry()
    {
        llSetTimerEvent(0.5);
        secondsLink = getLinkByName("Seconds");
        minutesLink = getLinkByName("Minutes");
        hoursLink = getLinkByName("Hours");
    }
    changed(integer change)
    {
        secondsLink = getLinkByName("Seconds");
        minutesLink = getLinkByName("Minutes");
        hoursLink = getLinkByName("Hours");
    }
    
    timer()
    {
        float s_angle;
        float m_angle;
        float h_angle;
        float time = llGetWallclock();
        float s = llFloor(time % 60);
        float m = llFloor((time / 60) % 60);
        float h = time / 3600;
        s_angle = 180 - s * 360. / 60.;
        m_angle = 180 - m * 360. / 60.;
        h_angle = h * 360 / 12;
        time += 0.5;
        if(llFabs(llFloor(time) - lastSec) > 0.5)
        {
            lastSec = time;
            llPlaySound("tick tock", 1);
        }
    
        if(secondsLink >= 0)
        {
            llSetLinkPrimitiveParamsFast(secondsLink, [PRIM_ROT_LOCAL, llEuler2Rot(<180 * DEG_TO_RAD, s_angle * DEG_TO_RAD, 90 * DEG_TO_RAD>)]);
        }
        if(minutesLink >= 0)
        {
            llSetLinkPrimitiveParamsFast(minutesLink, [PRIM_ROT_LOCAL, llEuler2Rot(<180 * DEG_TO_RAD, m_angle * DEG_TO_RAD, 90 * DEG_TO_RAD>)]);
        }
        if(hoursLink >= 0)
        {
            llSetLinkPrimitiveParamsFast(hoursLink, [PRIM_ROT_LOCAL, llEuler2Rot(<0, h_angle * DEG_TO_RAD, 270 * DEG_TO_RAD>)]);
        }
        
        if(m >= 59 && s > 50 && s < 57)
        {
            llMessageLinked(LINK_SET, (integer)1, "0.0", NULL_KEY);
        }
        if(m < 1 && s < 1)
        {
            h %= 12;
            if(h >= 1)
            {
                llMessageLinked(LINK_SET, (integer)h, "1.0", NULL_KEY);
            }
            else
            {
                llMessageLinked(LINK_SET, 12, "1.0", NULL_KEY);
            }
        }
    }
}
