// open source face animator.
// hopefully low lag:
//  * listens time out in 30 seconds
//  * moderate time between expression refreshes
//  * using states to avoid any "if"s to check when refreshing animation
//  * no timers when not expressing

// menu listen channel; suggest large negative number
integer CHANNEL = -90002553;

// how long do we wait between refreshes of an expression.
// the smaller this number is, the more lag this script causes
// suggest somewhere between 0.3-2.0 (or more)
// smaller times usually yield more "stable" expressions, though not always. default is 1.75.
float EXPRESSIONTIME = 1.75;

// how long do we wait before the menu times out, in seconds?
float MENUTIME = 30.0;

integer LISTEN_KEY;
string ANIM;

list MENU_UNHAPPY = // The limit of dialog is only twelve. Expressions in two menus.
[ 
"worry", "HAPPY", "CLOSE",
"disdain", "repulsed", "anger",
"shrug", "frown","afraid",
"sad", "cry", "bored"
];

list MENU_HAPPY =
[
"embarrassed", "UNHAPPY", "CLOSE",
"kiss", "surprise", "toothsmile",
"open mouth", "tongue out", "wink",
"smile", "laugh"
];

// list of all included animations for checking purposes
list ALL_ANIMS = [ "worry", "disdain", "repulsed", "anger", "shrug", "frown", "afraid", "sad", "cry", "bored", "embarrassed", "kiss", "surprise", "toothsmile", "open mouth", "tongue out", "wink", "smile", "laugh" ];

initialDialog()
{
    LISTEN_KEY = llListen(CHANNEL, "", llGetOwner(), "");
    llDialog(llGetOwner(), "\n What do you want to express?", MENU_HAPPY, CHANNEL);
    llSetTimerEvent(MENUTIME);
}

default {
    
on_rez(integer total_number)
{
    llResetScript();
}

state_entry()
{
    llOffsetTexture(0.0, -0.25, ALL_SIDES);
    llSetTimerEvent(0.0);
    llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
    // enable the line below if you want to pop up the dialog when ending an animation
    // if (ANIM != "") initialDialog();
    ANIM = "";
}

touch_start(integer total_number)
{
    llListenRemove(LISTEN_KEY);
    initialDialog();
}

listen(integer channel, string name, key id, string message)
{   
    //if we find the message in our list of animations
    if (llListFindList(ALL_ANIMS, [ message ]) != -1)
    {
    if (ANIM != "") llStopAnimation(ANIM);
    if (message == "afraid") ANIM = "express_afraid_emote";
    else if (message == "anger") ANIM = "express_anger_emote";
    else if (message == "bored") ANIM = "express_bored_emote";
    else if (message == "cry") ANIM = "express_cry_emote";
    else if (message == "disdain") ANIM = "express_disdain";
    else if (message == "embarrassed") ANIM = "express_embarrassed_emote";
    else if (message == "frown") ANIM = "express_frown";
    else if (message == "repulsed") ANIM = "express_repulsed_emote";
    else if (message == "sad") ANIM = "express_sad_emote";
    else if (message == "shrug") ANIM = "express_shrug_emote";
    else if (message == "surprise") ANIM = "express_surprise_emote";
    else if (message == "worry") ANIM = "express_worry_emote";
    else if (message == "kiss") ANIM = "express_kiss";
    else if (message == "laugh") ANIM = "express_laugh_emote";
    else if (message == "open mouth") ANIM = "express_open_mouth";
    else if (message == "smile") ANIM = "express_smile";
    else if (message == "tongue out") ANIM = "express_tongue_out";
    else if (message == "toothsmile") ANIM = "express_toothsmile";
    else if (message == "wink") ANIM = "express_wink_emote";
    //with this information now stored in the "ANIM" string, go to state "expressing"
    state expressing;
    }
    
    else if (message == "UNHAPPY")
    {
        llDialog(llGetOwner(), "\n What do you want to express?", MENU_UNHAPPY, CHANNEL);
    }
    else if (message =="HAPPY")
    {
        llDialog(llGetOwner(), "\n What do you want to express?", MENU_HAPPY, CHANNEL);
    }
}

timer()
{
    llListenRemove(LISTEN_KEY);
    llSetTimerEvent(0.0);
}

}


state expressing
{
    
on_rez(integer total_number)
    {
        llResetScript();
    }
    
state_entry()
    {
        llOffsetTexture(0.0, 0.25, ALL_SIDES);
        llStartAnimation(ANIM);
        llSetTimerEvent(EXPRESSIONTIME);
    }
    
touch_start(integer num_detected)
    {
        if (ANIM != "") llStopAnimation(ANIM);
        llSetTimerEvent(0.0);
        state default;
    }
    
timer()
    {
        llStartAnimation(ANIM);
    }
}