integer DEBUG = FALSE;

integer IRIS_OPEN  = 0;
integer IRIS_CLOSE = 1;
integer IRIS_RESET = 2;

string  door_lock  = "";

integer door_hole_steps = 10;
float   door_hole_limit = 2;    // steps from the end

float   door_hole;
float   door_hole_slice;
float   door_slice_delay = 0.2;

integer door_prim = 1;
integer door_prim_type = PRIM_TYPE_CYLINDER;

integer i;

iris_door(integer action) {

    if(door_lock != "locked") {

        float door_stop = door_hole_steps - door_hole_limit;

        i = 0;

        if(action == IRIS_OPEN) {

            do {

                door_hole += door_hole_slice;

                if(DEBUG){ llOwnerSay((string) door_hole); }

                llSetLinkPrimitiveParamsFast(LINK_THIS, [ PRIM_TYPE, PRIM_TYPE_BOX,

                    // hole shape, cut x,y (z not used), hole (0.0 - 1.0), twist, top size, shear
                    PRIM_HOLE_SQUARE, <0,1.0,0>, door_hole, <0,0,0>, <1.0,1.0,0>, <0,0,0> ]
                );

                i++;

                llSleep(door_slice_delay);

            } while (i <= door_stop);

        } else if(action == IRIS_CLOSE) {

            do {

                door_hole -= door_hole_slice;

                if(DEBUG){ llOwnerSay((string) door_hole); }

                llSetLinkPrimitiveParamsFast(LINK_THIS, [ PRIM_TYPE, PRIM_TYPE_BOX,

                    PRIM_HOLE_SQUARE, <0,1.0,0>, door_hole, <0,0,0>, <1.0,1.0,0>, <0,0,0> ]
                );

                i++;

                llSleep(door_slice_delay);

            } while (i <= door_stop);

        } else if(action == IRIS_RESET) {

            door_hole = 0;

            llSetLinkPrimitiveParamsFast(LINK_THIS, [ PRIM_TYPE, PRIM_TYPE_BOX,

                  PRIM_HOLE_SQUARE, <0,1.0,0>, door_hole, <0,0,0>, <1.0,1.0,0>, <0,0,0> ]
            );
        }
    }
}


default {

    state_entry() {

        door_lock       = "unlocked";
        door_hole_slice = 1.0 / door_hole_steps;

        llOwnerSay("Reset");
        llOwnerSay("Running: " + llGetScriptName());

        iris_door(IRIS_RESET);

        state closed;
    }
}

state open {

    state_entry() {

        if(DEBUG){ llOwnerSay("Open."); }
        llSetTimerEvent(30);
    }

    touch_end(integer num_detected)
    {

        iris_door(IRIS_CLOSE);

        state closed;
    }
    timer()
    {
        iris_door(IRIS_CLOSE);
        state closed;
        llSetTimerEvent(0);
    }
}

state closed {

    state_entry() {

        if(DEBUG){ llOwnerSay("Closed."); }
    }

    touch_end(integer num_detected) {

        iris_door(IRIS_OPEN);

        state open;
    }
}