
key gKyOID;
integer gIntCmdChan = 9;
integer gIntListenHandle;
key target;
vector pos;

integer FnIsSafe(vector pos)
{
    integer intFlagsHere = llGetParcelFlags(pos);
    if ((intFlagsHere & PARCEL_FLAG_ALLOW_CREATE_OBJECTS) && (intFlagsHere & PARCEL_FLAG_ALLOW_SCRIPTS))
    {
        return TRUE;
    }
    else if(llSameGroup(llList2Key(llGetParcelDetails(pos,[3]),0)) || llGetOwner() == llGetLandOwnerAt(pos)) 
    {
        return TRUE;
    }
    else 
    {
        return FALSE;
    }
}

updateParticles()
{
    
    target = llGetKey();
    llParticleSystem([  PSYS_PART_MAX_AGE,1.5,
                        PSYS_PART_FLAGS,PSYS_PART_EMISSIVE_MASK|PSYS_PART_INTERP_SCALE_MASK,
                        PSYS_PART_START_COLOR,<1,0,0> ,
                        PSYS_PART_END_COLOR, <.25,0,0>,
                        PSYS_PART_START_SCALE,<.5,.5,.5>,
                        PSYS_PART_END_SCALE,<.1,.1,.1>, 
                        PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
                        PSYS_SRC_BURST_RATE,.1,
                        PSYS_SRC_ACCEL, <0,0,1>,
                        PSYS_SRC_BURST_PART_COUNT,2,
                        PSYS_SRC_BURST_RADIUS,.01,
                        PSYS_SRC_BURST_SPEED_MIN,.05,
                        PSYS_SRC_BURST_SPEED_MAX,.05,
                        PSYS_SRC_TARGET_KEY,target,
                        PSYS_SRC_INNERANGLE,1.55, 
                        PSYS_SRC_OUTERANGLE,1.54,
                        PSYS_SRC_OMEGA, <0,0,10>,
                        PSYS_SRC_MAX_AGE, 0,
                        PSYS_SRC_TEXTURE, "smoke1",
                        PSYS_PART_START_ALPHA, 1,
                        PSYS_PART_END_ALPHA, 0
                            ]);
}

default 
{
    state_entry() 
    {
        target = llGetKey();
        updateParticles();
        gKyOID = llGetOwner();
        gIntListenHandle = llListen(gIntCmdChan,"","","");
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE,<1, 00, 0>, 1, 20, .05]);
        llSetPrimitiveParams([PRIM_GLOW,ALL_SIDES,0.5]);
        llRequestPermissions(gKyOID,PERMISSION_TRACK_CAMERA);
    }
    
      on_rez(integer param)
    {
        llResetScript();
    }
    
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRACK_CAMERA) 
        {
           llSetTimerEvent(.1);
        }
    }
    
    timer()
    {
        pos = llGetPos();
        if (FnIsSafe(pos) == TRUE)
        {
            llSetRegionPos(llGetCameraPos()+ <-1,-1,-1>);          
        }
    }
    
     listen(integer channel, string name, key id, string message) 
     {
        if ((id == gKyOID) || (gKyOID == llGetOwnerKey(id)))
        {
            if (llToLower(message) == "hold") 
            {
                llSetTimerEvent(0);
                llSetStatus(STATUS_PHYSICS,FALSE);
            }
            else if (llToLower(message) == "follow")
            {
                llSetTimerEvent(.1);
                llSetStatus(STATUS_PHYSICS,TRUE);
            }
            else if (llToLower(message) == "die")
            {
                llDie();
            }
        }
    }    
}
