string current_anim;
list anims;
key toucher;
integer chan;
integer glisten;
key sitter;
update_routine() {
    anims = [];
    integer i;
    integer anim_count = llGetInventoryNumber(INVENTORY_ANIMATION);
    for(i=0;i<anim_count;++i)
    {
        anims = anims + [llGetInventoryName(INVENTORY_ANIMATION,i)];
    }
    glisten = llListen(chan,"",toucher,"");
    llDialog(toucher,"\n \nCurrent: "+current_anim+"\nAvailable: "+(string)anim_count,anims,chan);
}
default {
    state_entry() {
        current_anim = llGetInventoryName(INVENTORY_ANIMATION,0);
        chan = -(integer)(llFrand(999));
        llSitTarget( <0.0, 0.0, 0.25>, ZERO_ROTATION);
    }
    on_rez(integer start_param) {
        llResetScript();
    }
    touch_start(integer num_detected) {
        key detectedtoucher = llDetectedKey(0);
        if (detectedtoucher == sitter) {
            if(llGetAgentInfo(detectedtoucher) & AGENT_ON_OBJECT) {
                toucher = detectedtoucher;
                update_routine();
            }
        }
    }
    listen(integer channel, string name, key id, string anim) {   
        if (channel == chan && id == toucher) {
            llListenRemove(glisten);
            llStopAnimation(current_anim);
            current_anim = anim;
            llStartAnimation(anim);
        }  
    }
    changed(integer change) {
        if (change & CHANGED_LINK) {
            sitter = llAvatarOnSitTarget();
            if(sitter != NULL_KEY) {
                llRequestPermissions(sitter, PERMISSION_TRIGGER_ANIMATION);
            }else{
                sitter = NULL_KEY;
                if (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION) {
                    llStopAnimation(current_anim);
                }
            }
        }
    }
    run_time_permissions(integer perm) {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            llStartAnimation(current_anim);
        }else{
            llSay(0,"Permission denied, please resit on me.");
        }
    }
}