//*****************************************
//*     Nyterave animation ball script!   *
//*           FREE TO USE V2.1            * 
//*        by Sitting Lightcloud          *
//*      Enhanced by Davie Macbeth        *
//*****************************************

// Revision history:
// =================
//
// V2.1.001:
//   Added ROTATION
//   Enabled LISTEN and set Channel to 1
//
// V2.1.002:
//   Added POSE_BALL
//
// V2.1.003:
//   Added synchronization
//
// V2.1.006:
//   Added facial expression
//
// V2.1.007:
//   Added hover text = anim name
//


// * * * * * * * MODIFY BELOW * * * * * * *//

// position to sit on the ball e.g <0.0, 0.0, 0.43>
// sit  0.5 meter above the ball
vector POSITION=<0, 0, -0.15>;

// rotation to sit on the ball
vector ROTATION=<0, 0, -90>;

// See http://lslwiki.net/lslwiki/wakka.php?wakka=animation for list of expressions
// Set to "" for no expression
string EXPRESSION = "";  // "express_kiss";  // "express_tongue_out";

// If TRUE, uses anim name as the hovertext
// Otherwise, use HOVERTEXT below
integer HOVERTEXT_ANIM = FALSE;

// hovertext above ball. "" for none.
// add '\n ' at the end to move text up i.e.
string HOVERTEXT="";

// Pie Menu Sit Text. Will only work for the
// main prim but included it anyway. If no text
// is entered between "" it won't be used.
string SIT_TEXT="";

// hovertext color 'r,g,b' e.g. "255,255,255" (white)
string HOVER_RGB="255,255,255";

// LISTEN sets if this ball should listen for voice commands
// or not. You only need to enable this for 1 ball if you
// link several balls to an object. (to reduce lagg).
// Change to TRUE to enable FALSE to disable. 
integer LISTEN=FALSE;

// What channel to listen for hide/show on. If you want to
// listen to normal conversation (hide/show), set channel
// to 0 otherwise the command will be /channel hide, show 
integer CHANNEL=1;

// Set to TRUE if object is a pose ball.  This will make
// it disappear when it is hopped on and reappear after
// the user stands up (unless it is hidden).
integer POSE_BALL=FALSE;

// * * * * * * * STOP MODIFY * * * * * * * *//




set_text()
{
       if ( (!hidden) )  // (llStringLength(HOVERTEXT)>0) && 
        {
            string text = HOVERTEXT;
            if( HOVERTEXT_ANIM ) text = llGetInventoryName(INVENTORY_ANIMATION,0);
            rgb=llCSV2List(HOVER_RGB);
            llSetText(text,<llList2Float(rgb,0)*0.003921568627450980392156862745098,llList2Float(rgb,1)*0.003921568627450980392156862745098,llList2Float(rgb,2)*0.003921568627450980392156862745098>,1.0);
            
        }    
        else
           llSetText("",<0,0,0>,0.0);     
}
start_listen()
{
    llListenRemove(listener);
    if (LISTEN==TRUE)
        listener=llListen(CHANNEL,"","","");
}
hide_me()
{
    if( POSE_BALL )
        llSetAlpha(0.0, ALL_SIDES);
    llSetText("",<0,0,0>,0.0);     
    hidden = TRUE;
}
show_me()
{
    if( POSE_BALL )
        llSetAlpha(1.0, ALL_SIDES);
    hidden = FALSE;
    set_text();                
}

list rgb;
string animation;
integer listener;
integer hidden=FALSE;

default 
{
    state_entry() 
    {
        if (llStringLength(SIT_TEXT)>0)
            llSetSitText(SIT_TEXT);
        llSitTarget(POSITION, llEuler2Rot(ROTATION * DEG_TO_RAD));
        set_text();
        start_listen();
    }
    
    on_rez(integer r)
    {
        start_listen();
    }
    
    listen(integer channel, string name, key id, string msg)  
    {
        if (msg=="hide")
        {
            hide_me();
            llMessageLinked(LINK_SET,0,"hide", NULL_KEY);
        }
        else if (msg=="show")
        {
            show_me();
            llMessageLinked(LINK_SET,0,"show", NULL_KEY);
        }
        else if (msg=="sync")
        {
            llMessageLinked(LINK_SET,0,"sync", NULL_KEY);
            if( animation != "" ) llStopAnimation(animation);
            if( animation != "" ) llStartAnimation(animation);
        }
    }
    
    changed(integer change) 
    { 
        if (change & CHANGED_INVENTORY) 
        {
            set_text();
        }
        else if (change & CHANGED_LINK) 
        {
            if (llAvatarOnSitTarget() != NULL_KEY) 
            { 
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                integer perm=llGetPermissions();
                if ((perm & PERMISSION_TRIGGER_ANIMATION) && llStringLength(animation)>0)       
                llSetTimerEvent(0);
                if( EXPRESSION != "" )
                    llStopAnimation(EXPRESSION);
                if( animation != "" ) llStopAnimation(animation);
                if( POSE_BALL )
                    llSetAlpha(1.0, ALL_SIDES);
                set_text();
                animation="";
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
                llMessageLinked(LINK_SET,0,"sync", NULL_KEY);
                llStopAnimation("sit");
                animation=llGetInventoryName(INVENTORY_ANIMATION,0);
                llStartAnimation(animation);
                if( EXPRESSION != "" )
                {
                    llStartAnimation( EXPRESSION );
                    llSetTimerEvent(0.5);
                }
                if( POSE_BALL )
                    llSetAlpha(0.0, ALL_SIDES);
                llSetText("",<0,0,0>,0.0);
        }
    }

    link_message(integer sender_num, integer num, string str, key id)
    {
        if (str=="hide")
        {
            hide_me();
        }
        else if (str=="show")
        {
            show_me();
        }
        else if (str=="sync")
        {
                if( animation != "" ) llStopAnimation(animation);
                if( animation != "" ) llStartAnimation(animation);
        }
    }

    timer() {  // timer to keep expression going
        llStartAnimation(EXPRESSION);
    }

}

