    //
    // This is your attachment point, or where this prim will call a chain from. See the
    // V2 HELP - Standard Tags file for the standardized list of attachment points.
    //
    
    string szAttachmentPoint = "rightwrist";

    //
    // These are just variables the program uses. kLinkedToAvatar remembers who was linked
    // so you don't have to pass the key a second time to unlink.
    //
    
    list lCommandLine;
    key kLinkedToAvatar = NULL_KEY;

default
{
    
    //
    // Just to clean up on a new rez.
    //
    
    on_rez( integer num )
    {
        
        llResetScript();
        
    }
    
    //
    // We pass our messages to the attachment point via link messages.
    // In essence, the message from the poseball will be:
    //      link [avatarkey]
    // That will link up the chain, and when you send:
    //      unlink
    // it will unlink the chain. The kLinkedToAvatar remembers which avatar
    // was linked. Of course, you can modify this file to handle multiple
    // avatars being attached to multiple points.
    //
    
    link_message( integer sender_num, integer num, string message, key id )
    {
        
        //
        // Break the message up so we can get the pieces.
        //
        
        lCommandLine = llParseString2List( message, [ " " ], [] );

        //
        // If our command is link...... then......
        //
                        
        if( llList2String( lCommandLine, 0 ) == "link" )
        {
            
            //
            // Remember who we are linking with.
            //
            
            kLinkedToAvatar = llList2Key( lCommandLine, 1 );            
            
            
            //
            // Fire off LockGuard to the attachment point noted at the beginning.
            //
             
            llWhisper( -9119, "lockguard " + (string)kLinkedToAvatar + " " + szAttachmentPoint + " link " + (string)llGetKey() );

        }
        
        //
        // If we are unlinking.....
        //
        
        if( llList2String( lCommandLine, 0 ) == "unlink" )
        {
            
            //
            // Make sure we've got the right avatar, you never know!
            //
            
            if( kLinkedToAvatar == NULL_KEY )
                return;
            
            
            //
            // Break the LockGuard link.
            //
            
            llWhisper( -9119, "lockguard " + (string)kLinkedToAvatar + " " + szAttachmentPoint + " unlink " );
            
            //
            // Reset the key to NULL.
            //
            
            kLinkedToAvatar = NULL_KEY;
            
        }
        
    }       
    
}