// ----------------------------------------------------------------------------------
// nPose Core 2.0 OSGrid JE 001
// ----------------------------------------------------------------------------------
// Changes:
// ----------------------------------------------------------------------------------
// Version JE 001
// - no reset on inventory change
// - reset scripts when no buttons are shown
// - forward prop adjust message
// ----------------------------------------------------------------------------------

integer RESET               = -950;

integer slotMax;
integer lastStrideCount = 12;
integer rezadjusters;
integer chatchannel;
integer explicitFlag;
key hudId;
string lastAssignSlotsCardName;
key lastAssignSlotsCardId;
key lastAssignSlotsAvatarId;
list slots;

string curmenuonsit = "off";

string NC_READER_CONTENT_SEPARATOR="%&§";

list SeatedAvs()
{
    list avs = [];
    integer n = llGetNumberOfPrims();
    for(; n >= llGetObjectPrimCount(llGetKey()); --n) {

        key id = llGetLinkKey(n);
        if(llGetAgentSize(id) != ZERO_VECTOR) {
            avs = [id] + avs;
        }
    }
    return avs;
}

integer FindEmptySlot()
{
    integer n;
    for(; n < slotMax; ++n) {
        if(llList2String(slots, n*8+4) == "") {
            return n;
        }
    }
    return -1;
}

assignSlots()
{
    list avqueue = SeatedAvs();
    integer x;
    integer n;
    for(; x < slotMax; ++x) {

        if(!~llListFindList(avqueue, [llList2Key(slots, x*8+4)])) {

            slots = llListReplaceList(slots, [""], x*8+4, x*8+4);
        }
    }

    if(slotMax < lastStrideCount)
    {
        for(x = slotMax; x <= lastStrideCount; ++x) {
            if(llList2Key(slots, x*8+4) != "") {

                integer emptySlot = FindEmptySlot();
                if((emptySlot >= 0) && (emptySlot < slotMax)) {

                    slots = llListReplaceList(slots, [llList2Key(slots, x*8+4)], emptySlot*8+4, emptySlot*8+4);
                }
            }
        }

        slots = llDeleteSubList(slots, (slotMax)*8, -1);

        for(; n<llGetListLength(avqueue); ++n) {
            if(!~llListFindList(slots, [llList2Key(avqueue, n)])) {
                llMessageLinked(LINK_SET, -222, llList2String(avqueue, n), NULL_KEY);
            }
        }
    }

    integer nn;
    for(; nn<llGetListLength(avqueue); ++nn) {
        key thisKey = llList2Key(avqueue, nn);
        integer index = llListFindList(slots, [llList2Key(avqueue, nn)]);
        integer emptySlot = FindEmptySlot();
        if(!~index)
        {
            key newAvatar;

            integer slotNum=-1;
            for(n = 1; n <= llGetObjectPrimCount(llGetKey()); ++n) {

                x = (integer)llGetSubString(llGetLinkName(n), 4, -1);
                if((x > 0) && (x <= slotMax)) {
                    if(llAvatarOnLinkSitTarget(n) == thisKey) {
                        if(llList2String(slots, (x-1)*8+4) == "") {
                            slotNum = (integer)llGetLinkName(n);
                            slots = llListReplaceList(slots, [thisKey], (slotNum-1)*8+4, (slotNum-1)*8+4);
                            newAvatar=thisKey;
                        }
                    }
                }
            }
            if(!~llListFindList(slots, [thisKey]))
            {
                if(~emptySlot) {

                    slots = llListReplaceList(slots, [thisKey], (emptySlot * 8) + 4, (emptySlot * 8) + 4);
                    newAvatar=thisKey;
                }
                else {
                    llMessageLinked(LINK_SET, -222, thisKey, NULL_KEY);
                }
            }
            if(newAvatar) {
                if(curmenuonsit == "on") {
                    llMessageLinked(LINK_SET, -801, "", newAvatar);
                }
            }
        }
    }
    lastStrideCount = slotMax;
    llMessageLinked(LINK_SET, 35353, llDumpList2String(slots, "^"), NULL_KEY);
}

SwapTwoSlots(integer currentseatnum, integer newseatnum)
{
    if(newseatnum <= slotMax)
    {
        integer slotNum;
        integer OldSlot;
        integer NewSlot;
        for(; slotNum < slotMax; ++slotNum)
        {
            integer z = llSubStringIndex(llList2String(slots, slotNum*8+7), "§");
            string strideSeat = llGetSubString(llList2String(slots, slotNum * 8+7), z+1,-1);
            if(strideSeat == "seat" + (string)(currentseatnum)) {
                OldSlot= slotNum;
            }
            if(strideSeat == "seat" + (string)(newseatnum)) {
                NewSlot= slotNum;
            }
        }

        list curslot = llList2List(slots, NewSlot*8, NewSlot*8+3)
            + [llList2Key(slots, OldSlot*8+4)]
            + llList2List(slots, NewSlot*8+5, NewSlot*8+7);
        slots = llListReplaceList(slots, llList2List(slots, OldSlot*8, OldSlot*8+3)
            + [llList2Key(slots, NewSlot*8+4)]
            + llList2List(slots, OldSlot*8+5, OldSlot*8+7), OldSlot*8, (OldSlot+1)*8-1);

        slots = llListReplaceList(slots, curslot, NewSlot*8, (NewSlot+1)*8-1);
    }
    else {
        llRegionSayTo(llList2Key(slots, llListFindList(slots, ["seat"+(string)currentseatnum])-4),
            0, "Seat "+(string)newseatnum+" is not available for this pose set");
    }
    llMessageLinked(LINK_SET, 35353, llDumpList2String(slots, "^"), NULL_KEY);
}

ProcessLine(string sLine, key av, string ncName, string menuName)
{
    sLine = llDumpList2String(llParseStringKeepNulls(sLine, ["%CARDNAME%"], []), ncName);
    list paramsOriginal = llParseStringKeepNulls(sLine, ["|"], []);
    sLine = llDumpList2String(llParseStringKeepNulls(sLine, ["%AVKEY%"], []), av);

    list params = llParseStringKeepNulls(sLine, ["|"], []);
    string action = llList2String(params, 0);
    integer slotNumber;
    if(action == "ANIM") {
        if(slotMax<lastStrideCount) {
            slots = llListReplaceList(slots, [llList2String(params, 1), (vector)llList2String(params, 2),
                llEuler2Rot((vector)llList2String(params, 3) * DEG_TO_RAD), llList2String(params, 4), llList2Key(slots, (slotMax)*8+4),
                "", "",llGetSubString(llList2String(params, 5), 0, 12) + "§" + "seat"+(string)(slotMax+1)], (slotMax)*8, (slotMax)*8+7);
        }
        else {
            slots += [llList2String(params, 1), (vector)llList2String(params, 2),
                llEuler2Rot((vector)llList2String(params, 3) * DEG_TO_RAD), llList2String(params, 4), "", "", "",
                llGetSubString(llList2String(params, 5), 0, 12) + "§" + "seat"+(string)(slotMax+1)];
        }
        slotMax++;
    }
    else if (action == "SCHMO" || action == "SCHMOE") {


        slotNumber = (integer)llList2String(params,1)-1;
        if(slotNumber * 8 < llGetListLength(slots)) {
            if(action == "SCHMOE" || (action == "SCHMO" && llList2Key(slots, slotNumber * 8 + 4) == av)) {
                integer index=2;
                integer length=llGetListLength(params);
                for(; index<length; index++) {
                    if(index==2) {
                        slots=llListReplaceList(slots, [llList2String(params, index)],
                            slotNumber * 8, slotNumber * 8);

                        slots=llListReplaceList(slots, ["",""],
                            slotNumber * 8 + 5, slotNumber * 8 + 6);
                    }
                    else if(index==3) {
                        slots=llListReplaceList(slots, [(vector)llList2String(params, index)],
                            slotNumber * 8 + 1, slotNumber * 8 + 1);
                    }
                    else if(index==4) {
                        slots=llListReplaceList(slots, [llEuler2Rot((vector)llList2String(params, index) * DEG_TO_RAD)],
                            slotNumber * 8 + 2, slotNumber * 8 + 2);
                    }
                    if(index==5) {
                        slots=llListReplaceList(slots, [llList2String(params, index)],
                            slotNumber * 8 + 3, slotNumber * 8 + 3);
                    }
                    else if(index==6) {
                        slots=llListReplaceList(slots, [llList2String(params, index) + "§seat" + (string)(slotNumber+1)],
                            slotNumber * 8 + 7, slotNumber * 8 + 7);
                    }
                }
            }
        }
        slotMax = lastStrideCount;
    }
    else if (action == "PROP")
    {
        string obj = llList2String(params, 1);
        if(llGetInventoryType(obj) == INVENTORY_OBJECT) {
            list strParm2 = llParseString2List(llList2String(params, 2), ["="], []);
            if(llList2String(strParm2, 1) == "die")
            {
                llRegionSay(chatchannel,llList2String(strParm2,0)+"=die");
            }
            else
            {
                explicitFlag = 0;
                if(llList2String(params, 4) == "explicit") {
                    explicitFlag = 1;
                }

                if(llList2String(params, 5) == "quiet") {
                    explicitFlag += 2;
                }
                vector vDelta = (vector)llList2String(params, 2);
                vector pos = llGetPos() + (vDelta * llGetRot());
                rotation rot = llEuler2Rot((vector)llList2String(params, 3) * DEG_TO_RAD) * llGetRot();
                integer sendToPropChannel = (chatchannel << 8);
                sendToPropChannel = sendToPropChannel | explicitFlag;
                if(llVecMag(vDelta) > 9.9) {

                    llRezAtRoot(obj, llGetPos(), ZERO_VECTOR, rot, sendToPropChannel);
                    llSleep(1.0);
                    llRegionSay(chatchannel, llDumpList2String(["MOVEPROP", obj, (string)pos], "|"));
                }
                else {
                    llRezAtRoot(obj, llGetPos() + ((vector)llList2String(params, 2) * llGetRot()),
                        ZERO_VECTOR, rot, sendToPropChannel);
                }
            }
        }
    }
    else if(action=="PAUSE")
    {
        llSleep((float)llList2String(params, 1));
    }
    else if(action == "LINKMSG")
    {
        integer num = (integer)llList2String(params, 1);
        key lmid;
        if((key)llList2String(params, 3) != "") {
            lmid = (key)llList2String(params, 3);
        }
        else {
            lmid = av;
        }
        llMessageLinked(LINK_SET, num, llList2String(params, 2), lmid);
        llSleep((float)llList2String(params, 4));
        llRegionSay(chatchannel, llDumpList2String(["LINKMSG",num,llList2String(params, 2),lmid], "|"));
    }
    else if (action == "SATMSG")
    {
        integer index = (slotMax - 1) * 8 + 5;
        if((integer)llList2String(paramsOriginal, 4) >= 1) {
            index = (((integer)llList2String(paramsOriginal, 4) + -1) * 8 + 5);
        }
        slots = llListReplaceList(slots, [llDumpList2String([llList2String(slots,index),
            llDumpList2String(llDeleteSubList(paramsOriginal, 0, 0), "|")], "§")], index, index);
    }
    else if (action == "NOTSATMSG")
    {
        integer index = (slotMax - 1) * 8 + 6;
        if((integer)llList2String(paramsOriginal, 4) >= 1) {
            index = (((integer)llList2String(paramsOriginal, 4) + -1) * 8 + 6);
        }
        slots = llListReplaceList(slots, [llDumpList2String([llList2String(slots,index),
            llDumpList2String(llDeleteSubList(paramsOriginal, 0, 0), "|")], "§")], index, index);
    }
}

default{
    state_entry()
    {
        integer n;
        for(; n<=llGetNumberOfPrims(); ++n) {
            llLinkSitTarget(n,<0.0,0.0,0.5>,ZERO_ROTATION);
        }
        chatchannel = (integer)("0x7F" + llGetSubString((string)llGetKey(), 0, 5));

        llMessageLinked(LINK_SET, 1, (string)chatchannel, NULL_KEY);
        integer listener = llListen(chatchannel, "", "", "");

        integer stop = llGetInventoryNumber(INVENTORY_NOTECARD);
        for(n = 0; n < stop; n++) {
            string cardName = llGetInventoryName(INVENTORY_NOTECARD, n);
            if((llSubStringIndex(cardName, "DEFAULT:") == 0) || (llSubStringIndex(cardName, "SET:") == 0)) {
                llSleep(1.0);
                llMessageLinked(LINK_SET, 200, cardName, NULL_KEY);
                return;
            }
        }
    }
    link_message(integer sender, integer num, string str, key id)
    {
        if(num == 999999)
        {
            llMessageLinked(LINK_SET, 1, (string)chatchannel, NULL_KEY);
        }
        else if(num == 222 || num == 223)
        {
            list allData=llParseStringKeepNulls(str, [NC_READER_CONTENT_SEPARATOR], []);
            str = "";

            string ncName=llList2String(allData, 0);
            string menuName=llList2String(allData, 1);

            if(num==222) {
                lastStrideCount = slotMax;
                slotMax = 0;
                llRegionSay(chatchannel, "die");
            }
            integer length=llGetListLength(allData);
            integer index=3;
            integer run_assignSlots;
            for(; index<length; index++) {
                string data = llList2String(allData, index);
                if(num==223 && (llSubStringIndex(data, "ANIM") != 0)) {
                    ProcessLine(llList2String(allData, index), id, ncName, menuName);
                    if(!llSubStringIndex(data, "SCHMOE") || !llSubStringIndex(data, "SCHMO")) {
                        run_assignSlots = TRUE;
                    }

                }
                else if (num==222) {
                    ProcessLine(llList2String(allData, index), id, ncName, menuName);
                    run_assignSlots = TRUE;
                }
            }
            if(run_assignSlots) {
                assignSlots();
                if (llGetInventoryType(ncName) == INVENTORY_NOTECARD){
                    lastAssignSlotsCardName=ncName;
                    lastAssignSlotsCardId=llGetInventoryKey(lastAssignSlotsCardName);
                    lastAssignSlotsAvatarId=id;
                }
                if(rezadjusters) {

                    llMessageLinked(LINK_SET, 2, "RezAdjuster", "");
                }
            }
        }
        else if(num == 201)
        {
            rezadjusters = TRUE;
        }
        else if(num == 205)
        {
            rezadjusters = FALSE;
        }
        else if(num == 300) {
            list msg = llParseString2List(str, ["|"], []);
            if(id != NULL_KEY) msg = llListReplaceList(msg, [id], 2, 2);
            llRegionSay(chatchannel,llDumpList2String(["LINKMSG", (string)llList2String(msg, 0),
                llList2String(msg, 1), (string)llList2String(msg,2)], "|"));
        }
        else if (num == 202)
        {
            if(llGetListLength(slots)/8 >= 2) {
                list seats2Swap = llCSV2List(str);
                SwapTwoSlots((integer)llList2String(seats2Swap, 0), (integer)llList2String(seats2Swap, 1));
            }
        }
        else if(num == 210)
        {
            integer slotIndex = llListFindList(slots, [id]);
            integer z = llSubStringIndex(llList2String(slots, slotIndex + 3), "§");
            string strideSeat = llGetSubString(llList2String(slots, slotIndex + 3), z+1,-1);
            integer oldseat = (integer)llGetSubString(strideSeat, 4,-1);
            if (oldseat <= 0)
            {
                llWhisper(0, "avatar is not assigned a slot: " + (string)id);
            }
            else
            {
                SwapTwoSlots(oldseat, (integer)str);
            }
        }
        else if (num == RESET)
        {
            llResetScript();
        }
        else if (num == (35353 + 2000000))
        {
            list tempList = llParseStringKeepNulls(str, ["^"], []);
            integer listStop = llGetListLength(tempList)/8;
            integer slotNum;
            for(; slotNum < listStop; ++slotNum) {
                slots = llListReplaceList(slots, [llList2String(tempList, slotNum*8), (vector)llList2String(tempList, slotNum*8+1),
                    (rotation)llList2String(tempList, slotNum*8+2), llList2String(tempList, slotNum*8+3),
                    (key)llList2String(tempList, slotNum*8+4), llList2String(tempList, slotNum*8+5),
                    llList2String(tempList, slotNum*8+6), llList2String(tempList, slotNum*8+7)], slotNum*8, slotNum*8 + 7);
            }
            slotMax = listStop;
        }
        else if(num == -999)
        {
            if(llGetInventoryType("npose admin hud")!=INVENTORY_NONE && str == "RezHud")
            {
                llRezObject("npose admin hud", llGetPos() + <0,0,1>, ZERO_VECTOR, llGetRot(), chatchannel);
            }
            else if(num == -999 && str == "RemoveHud")
            {
                llRegionSayTo(hudId, chatchannel, "/die");
            }
        }
        else if(num==-240)
        {
            list optionsToSet = llParseStringKeepNulls(str, ["~"], []);
            integer length = llGetListLength(optionsToSet);
            integer index;
            for(; index<length; index++) {
                list optionsItems = llParseString2List(llList2String(optionsToSet, index), ["="], []);
                string optionItem = llToLower(llStringTrim(llList2String(optionsItems, 0), STRING_TRIM));
                string optionSetting = llStringTrim(llList2String(optionsItems, 1), STRING_TRIM);
                if(optionItem == "menuonsit") {
                    curmenuonsit = optionSetting;
                }
            }
        }
        else if(num == 34334)
        {
            llSay(0,"Memory Used by " + llGetScriptName() + ": " + (string)llGetUsedMemory() + " of " + (string)llGetMemoryLimit()
                + ", Leaving " + (string)llGetFreeMemory() + " memory free.");
            llSay(0, "running script time for all scripts in this nPose object are consuming "
                + (string)(llList2Float(llGetObjectDetails(llGetKey(), ([OBJECT_SCRIPT_TIME])), 0)*1000.0) + " ms of cpu time");
        }
    }

    object_rez(key id) {
        if(llKey2Name(id) == "npose admin hud") {
            hudId = id;
            llSleep(2.0);
            llRegionSayTo(hudId, chatchannel, "parent|"+(string)llGetKey());
        }
    }

    listen(integer channel, string name, key id, string message) {
        list temp = llParseString2List(message, ["|"], []);
        if(name == "Adjuster") {
            llMessageLinked(LINK_SET, 3, message, id);
        }
        else if(llGetListLength(temp) >= 2 || llGetSubString(message,0,4) == "ping" || llGetSubString(message,0,8) == "PROPRELAY")
        {
            if(llGetOwnerKey(id) == llGetOwner())
            {
                if(message == "ping")
                {
                    llRegionSayTo(id, chatchannel, "pong|" + (string)llGetPos());
                }
                else if(llGetSubString(message,0,8) == "PROPRELAY")
                {
                    list msg = llParseString2List(message, ["|"], []);
                    llMessageLinked(LINK_SET,llList2Integer(msg,1),llList2String(msg,2),llList2Key(msg,3));
                }
                else if(name == "pos_adjuster_hud")
                {
                }
                else
                {
                    list params = llParseString2List(message, ["|"], []);
                    vector newpos = (vector)llList2String(params, 0) - llGetPos();
                    newpos = newpos / llGetRot();
                    rotation newrot = (rotation)llList2String(params, 1) / llGetRot();
                    string line = "PROP|" + name + "|" + (string)newpos + "|" + (string)(llRot2Euler(newrot) * RAD_TO_DEG) + "|" + llList2String(params, 2);
                    llMessageLinked(LINK_SET, 35355, line, NULL_KEY);
                    llRegionSayTo(llGetOwner(), 0, "\n" + line);
                }
            }
        }
        else if(name == llKey2Name(hudId))
        {
            if(message == "adjust")
            {
                llMessageLinked(LINK_SET, 201, "", "");
            }
            else if(message == "stopadjust")
            {
                llMessageLinked(LINK_SET, 205, "", "");
            }
            else if(message == "posdump")
            {
                llMessageLinked(LINK_SET, 204, "", "");
            }
            else if(message == "hudsync")
            {
                llMessageLinked(LINK_SET, 206, "", "");
            }
        }
    }

    changed(integer change) {
        if(change & CHANGED_INVENTORY) {
            if(llGetInventoryType(lastAssignSlotsCardName) == INVENTORY_NOTECARD)
            {
                if(lastAssignSlotsCardId!=llGetInventoryKey(lastAssignSlotsCardName))
                {
                    llSleep(1.0);
                    llMessageLinked(LINK_SET, 200, lastAssignSlotsCardName, lastAssignSlotsAvatarId);
                }
                else {
                    llResetScript();
                }
            }
            else
            {
                if (!rezadjusters) llResetScript();
            }
        }
        if(change & CHANGED_LINK)
        {
            llMessageLinked(LINK_SET, 1, (string)chatchannel, NULL_KEY);
            assignSlots();
        }
        if(change & CHANGED_REGION)
        {
            llMessageLinked(LINK_SET, 35353, llDumpList2String(slots, "^"), NULL_KEY);
        }
    }

    on_rez(integer param) {
        llResetScript();
    }
}
 