// Lockmeister V2 Bondage Cross Example.
// by Innula Zenovka
//
// This script shows a typical usage for a Bondage Cross.
// The script expects to be placed in the root of a linkset with
// four chain points included.
// The script scans the linkset and identifies the four chain points
// by their description field:
// "top left", "top right", "bottom left", "bottom right" (without quotes, specified below)
// When someone sits on the cross, the animation found inside of the root prim
// will be played and 4 chains corresponding to the chain points specified will be started.
// The animation is removed and the chains turned off when the avatar unsits.
 
 
integer handle;
integer lm_channel = -8888;
integer i;
integer max;
integer n;
integer number_of_prims;
 
key victim;
list emitters;
list particles;
 
string LM2_request = "|LMV2|RequestPoint|";
string anim;
 
string str_top_left ="tl"; //put in the description fields of the emitter prims
string str_top_right ="tr";
string str_bottom_left ="bl";
string str_bottom_right="br";
 
 
string left_wrist = "lcuff"; //lockmeister names
string right_wrist = "rcuff";
string right_ankle = "rlcuff";
string left_ankle = "llcuff";
 
string request;
 
 
init(){
    number_of_prims = llGetObjectPrimCount(llGetKey());
    anim = llGetInventoryName(INVENTORY_ANIMATION,0);
    emitters = [str_top_left,left_wrist,str_top_right,right_wrist,str_bottom_left,left_ankle,str_bottom_right,right_ankle];
    //descriptions of our points, and the LM points we want to use as targets for our chains
    max = llGetNumberOfPrims()+1;
    while (max--){//loop through the linkset
        string s = llToLower(llStringTrim((string)llGetLinkPrimitiveParams(max,[PRIM_DESC]),STRING_TRIM));
        n = llListFindList(emitters,[s]); //check if it's an emitter prim
        if(~n){// if it is
            emitters = llListInsertList(emitters,[max],(n+2));
            //insert it into the list after the LM attachment point name
        }
    }
    max = llGetListLength(emitters);//now get rid of the link descriptions from the list, cos we're not using them again
    while (max>-1){
        emitters = llDeleteSubList(emitters,max,max);
        max-=3;
    }
    max = llGetListLength(emitters);
    // llOwnerSay(llList2CSV(emitters));
 
    particles = [  // start of particle settings
        // Texture Parameters:
        PSYS_SRC_TEXTURE, "53b21c36-243c-41d0-bc26-97e66f7d6d09",
        PSYS_PART_START_SCALE, <0.1, 0.1, FALSE>, PSYS_PART_END_SCALE, <0.1, 0.1, FALSE>,
        PSYS_PART_START_COLOR, <1.00,1.00,1.00>,    PSYS_PART_END_COLOR, <1.00,1.00,1.00>,
        PSYS_PART_START_ALPHA, (float) 1.0,         PSYS_PART_END_ALPHA, (float) 1.0,
 
        // Production Parameters:
        PSYS_SRC_BURST_PART_COUNT, (integer)  2,
        PSYS_SRC_BURST_RATE,         (float) 0.01,
        PSYS_PART_MAX_AGE,           (float)  2.0,
        // PSYS_SRC_MAX_AGE,            (float)  0.00,
 
        // Placement Parameters:
        PSYS_SRC_PATTERN, (integer) 1, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=CONE,
 
        // Placement Parameters (for any non-DROP pattern):
        //  PSYS_SRC_BURST_SPEED_MIN, (float) 00.0,   PSYS_SRC_BURST_SPEED_MAX, (float) 00.0,
        //  PSYS_SRC_BURST_RADIUS, (float) 00.0,
 
        // Placement Parameters (only for ANGLE & CONE patterns):
        //  PSYS_SRC_ANGLE_BEGIN, (float) 0.50 * PI,   PSYS_SRC_ANGLE_END, (float) 0.50 * PI,
        //  PSYS_SRC_OMEGA, <00.00, 00.00, 01.00>,
 
        // After-Effect & Influence Parameters:
        PSYS_SRC_ACCEL, < 00.00, 00.00, -00.1>,
        //  PSYS_SRC_TARGET_KEY, (key) llGetLinkKey(llGetLinkNum() + 1),
 
        PSYS_PART_FLAGS, (integer) ( 0                  // Texture Options:
            | PSYS_PART_INTERP_COLOR_MASK
        | PSYS_PART_INTERP_SCALE_MASK
        | PSYS_PART_EMISSIVE_MASK
        | PSYS_PART_FOLLOW_VELOCITY_MASK
        // After-effect & Influence Options:
        //   | PSYS_PART_WIND_MASK
        // | PSYS_PART_BOUNCE_MASK
        // | PSYS_PART_FOLLOW_SRC_MASK
        | PSYS_PART_TARGET_POS_MASK
        // | PSYS_PART_TARGET_LINEAR_MASK
        )
            //end of particle settings
            ];
 
 
}
 
 
default
{
    state_entry()
    {
        init();
        llSitTarget(<-0.19225, 0.00489, -0.42793>, <-0.06705, -0.27499, 0.95891, 0.01923>);
    }
 
    on_rez(integer start_param)
    {
        init();
    }
 
    changed(integer change)
    {
        if(change & CHANGED_LINK){
            victim = llAvatarOnSitTarget();
            if(victim){
                llRequestPermissions(victim,PERMISSION_TRIGGER_ANIMATION);
            }
            else{
                llListenRemove(handle);
                llLinkParticleSystem(LINK_SET,[]);
                if(llGetObjectPrimCount(llGetKey())!=number_of_prims){
                    //some relinking has taken place, so read the link numbers again
                    init();
                }
            }
        }
        else if (change & CHANGED_INVENTORY){
            init();
        }
    }
 
    run_time_permissions(integer permissions)
    {
        if(permissions & PERMISSION_TRIGGER_ANIMATION){
            if(anim){
                llStopAnimation("sit");
                llStartAnimation(anim);
            }
            handle = llListen(lm_channel,"","","");
            n=0;
            while (n<max){//run though the list of emitters, asking for the uuids of the target points
                request = llList2String(emitters,n);
                llRegionSayTo(victim,lm_channel,(string)victim+request);//v1 style LM message
                n+=2;
            }
        }
    }
 
    listen(integer channel, string name, key id, string message){
 
        if(llGetSubString(message,0,35)==(string)victim){// it's for us
            if(llGetSubString(message,-2,-1)=="ok"){//it's an old style v1 LM reply
                string s = llGetSubString(message,36,-4);//strip out the victim's key and the " ok" tag
                i = llListFindList(emitters,[s]);
 
                if(~i){//check that it's a point on the list
                    i+=1;//the emitter number is the next item
                    //draw a chain, using the uuid of the sender as the target
                    llLinkParticleSystem(llList2Integer(emitters,i),particles+[PSYS_SRC_TARGET_KEY,id]);
 
                    //now send a v2 style LM message, because if the target attachment is using v2 style messages,
                    // then the chains will be better targetted
                    request = (string)victim+LM2_request+s;
                    llRegionSayTo(victim,lm_channel,request);
                }
 
            }
            else{//v2 style LM reply
                // is it a v2 style LM reply?
                list temp = llParseString2List(message,["|"],[""]);
                if(llList2String(temp,1)=="LMV2" && llList2String(temp,2)=="ReplyPoint"){    //looks like it is
                    temp = llDeleteSubList(temp,0,2);//get rid of the victim's key and the "LMV2", "ReplyPoint" bits
                    i=llListFindList(emitters,llList2List(temp,0,0));//check it's a point on the list
                    if(~i){
                        i+=1;//the emitter number is the next item
                        //draw a chain, this time using the uuid supplied in the message (cast as a key) as the target
                        llLinkParticleSystem(llList2Integer(emitters,i),particles+[PSYS_SRC_TARGET_KEY,(key)llList2String(temp,1)]);
                    }
                }
            }
        }
    }
 
} 