// ********************************************************************
//
// Basic Physical Sliding Door Script
// by SimonT Quinnell
// 11/07/2009
//
// NOTE: If you are going to reposition the door, do it while the door 
// is closed.
//  Otherwise it will try and use the old close position as a reference 
// point.
//
// Licensed under the "OpenCollar License"
// Ie. Licensed under the GPLv2, with the additional requirement that 
// these scripts remain "full perms" in Second Life.
//
// Edit: Simplified the script to be just a basic move script .. removed 
// the sound triggers (5/1/2010)
//
// ********************************************************************


// ********************************************************************
// CONSTANTS
// ********************************************************************

// Movement Constants
// moving the door in x,y,z coordinates
vector      OFFSET = <0.0, 0.0, 4>;      // Directional offset for 

float       OPENTIME = 1;                 // Time taken to open door
float       CLOSETIME = 1;                // Time taken to close door


// ********************************************************************
// Variables
// ********************************************************************

vector      vPosition;
rotation    rRot;
float       omega=0.0;
vector      vTargetPos;
integer     bOpen = FALSE;
integer     bMoving = FALSE;


// ********************************************************************
// Functions
// ********************************************************************


MoveDoor()
{
     if(!bOpen)
     {   // Initial conditions
         bOpen = TRUE;
         rRot = llGetRot();
         vPosition = llGetPos();

         // Target Position
         omega=OPENTIME/llVecDist(<0,0,0>,OFFSET);
         vTargetPos = vPosition+OFFSET*rRot;

         // Set the timer to cleanup position
         llSetTimerEvent(OPENTIME);
     }else
     {
         bOpen = FALSE;

         // Target Position
         omega=CLOSETIME/llVecDist(<0,0,0>,OFFSET);
         vTargetPos = vPosition;

         // Set the timer to cleanup position
         llSetTimerEvent(CLOSETIME);
     }

     // Set Door Physical and move it
     bMoving = TRUE;
     llSetStatus(STATUS_PHANTOM, TRUE);
     llSetStatus(STATUS_PHYSICS, TRUE);
     llMoveToTarget(vTargetPos,omega);
}


default
{
     state_entry()
     {   // Initial conditions
         rRot = llGetRot();
         vPosition = llGetPos();
     }

     touch_start(integer num_detected)
     {
         MoveDoor();
     }

     timer()
     {
         // Clean up Position
         bMoving = FALSE;
         llSetTimerEvent(0.0);
         llSetStatus(STATUS_PHYSICS, FALSE);
         llSetStatus(STATUS_PHANTOM, FALSE);
         llSetPrimitiveParams([ PRIM_POSITION, vTargetPos, 
PRIM_ROTATION, rRot ]);
     }
}