/////////////////////////////////////////////////
//                                             //
//            Created  by Jeff Cost            //
//            http://myopengrid.com            //
//                 License MIT                 //
//                                             //
///////////////////////////////////////////////// 

vector focus = <133.216721, 187.981354, 27.963896>;
vector pos = <133.0,162.0,32.0>;

setCameraPosition(integer perms)
{
    if(perms & PERMISSION_CONTROL_CAMERA)
    {
        vector camPos = pos;
        vector camFocus = focus;
        llClearCameraParams();
        llSetCameraParams([
            CAMERA_ACTIVE, 1,
            CAMERA_FOCUS, camFocus,
            CAMERA_FOCUS_LOCKED, TRUE,
            CAMERA_POSITION, camPos,
            CAMERA_POSITION_LOCKED, TRUE
        ]);
    }
}

default
{
    state_entry()
    {
        llSitTarget(<-0.0,0.20,0.28>, llEuler2Rot(<10.0,0.0,90.0>*DEG_TO_RAD));
    }
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key agent = llAvatarOnSitTarget();

            if(agent)
            {
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_CONTROL_CAMERA);
                llInstantMessage(llAvatarOnSitTarget(), "\n *** ATTENTION *** (hit esc for best camera viewing angle)\n ****************************************************************** \n For the best experience, enable automatic prim and parcel media under Edit > Preferences > Audio & Video tab > Check the *automatically play prim media* and *automatically play parcel media* boxes. \n\n ****************************************************************** \n ~to read this again check your local chat log. \n\n");
                
            }
        }
    }
    run_time_permissions(integer perms)
    {
        setCameraPosition(perms);
    }

}