///////////////////////////////////////////////////////////////////////////////
// Builders' Buddy 1.10 (Base Script)
// by Newfie Pendragon, 2006-2008
///////////////////////////////////////////////////////////////////////////////
//
// Traduzione di RINOBIT Footman, 06/06/2010
//
// Uso e scopo dello script
// Le funzioni dipendono dal "component script"
//
// USO VELOCE:
// - Trascinate questo script nella base.
// - Trascinate il "Component Script" in ogni parte della costruzione.
// - Toccate la vostra base, e scegliete RECORD.
// - Prendete tutte le parti della costruzione nell'inventario.
// - Trascinate le parti della costruzione dall'inventario al Base Prim.
// - Toccate la vostra base e scegliete BUILD.
//
// ALTRI COMANDI dal Menu Touch
// - Per riposizionare, muovere/ruotare il Base Prim scegliete POSITION
// - Per bloccare in una posizione (rimuove gli scripts) scegliete DONE
// - Per cancellare la costruzione: scegliete CLEAN
///////////////////////////////////////////////////////////////////////////////
// Questo script è materiale protetto da copyright, e ha una (seppur minima) restrizione.
// Per tutti i dettagli, compresa una cronologia delle revisioni, vedere
// http://wiki.secondlife.com/wiki/Builders_Buddy
///////////////////////////////////////////////////////////////////////////////
 
// Canale usato dal Base Prim per comunicare con i Component Prims
// Questo canale deve essere lo stesso per i Component Prims
// E' utilizzato un canale negativo per evitare attivazioni accidentali
// da un Avatar che parla su questi canali non pubblici
integer DefaultPRIMCHAN = 192567;     // Canale usato di default
integer PRIMCHAN = 192567;    // Canale usato dalla Base Prim per comunicare con i Component Prims;
                                       // ***QUESTO DEVE CORRISPONDERE IN ENTRAMBI GLI SCRIPT!***
 
//La UUID del creatore dell'oggetto
//Lasciate questo come "" a meno che SL visualizzi un nome errato nelle proprietà dell'oggetto
key creatorUUID = "";
 
// Settare a TRUE per permettere ai membri del gruppo di usare il Menu Dialog
// Settare a FALSE per disabilitare i membri del gruppo all'uso del Menu Dialog
integer ingroup = TRUE;
 
// Settare a TRUE per cancellare i pezzi dall'inventario una volta rezzati
// (ATTENZIONE) Se è settato a FALSE, l'utente sarà in grado di rezzare più copie
integer deleteOnRez = FALSE;
 
// Abilita i non-creator ad utilizzare il comando CLEAN?
// (ATTENZIONE) Se è settato a TRUE, si raccomanda di settare
// deleteOnRez a FALSE, o gli utilizzatori potrebbero perdere l'intera costruzione
integer allowClean = TRUE;
 
//Quando un utilizzatore selezione CLEAN, cancella anche il base prim?
integer dieOnClean = FALSE;
 
// Settate a TRUE per memorizzare la posizione dei pezzi mediante
// le coordinate assolute della sim invece che quelle relative al base prim
integer recordSimLocation = FALSE;
 
// Settate a TRUE per rezzare tutte le parti della costruzione prima di posizionarle.
// o FALSE per farlo con uno alla volta (più lento?)
integer bulkBuild = TRUE;
 
//Settate a FALSE se non volete che lo script vi parli in chat mentre 'lavora'
integer chatty = TRUE;
 
//Quanto tempo il menu aspetta una scelta prima di chiudere il linsten
float fListenTime = 30.0;
 
//Quante volte (in secondi) per effettuare eventuali controlli a tempo
float fTimerRate = 0.25;
 
//Quanto tempo per scegliere prima di uscire dalla modalità attiva
float fStoppedTime = 30.0;
 
//SL qualche volta blocca il rezzing per prevenire un "crash"
//Quanto tempo dovete aspettare (in secondi) prima di avere la certezza che SL ha bloccato il vostro tentativo di rez
integer iRezWait = 10;
 
//Specificate cosa volete che il menu Opzioni visualizzi
//FALSE abiliterà le opzioni complete solo al creator
//TRUE abiliterà le opzioni complete a tutti
integer fullOptions = FALSE;
 
//Settate a TRUE se volete ShapeGen channel support
// (Ultime 4 cifre del canale interessato)
integer SGCompatible = FALSE;
 
 
///////////////////////////////////////////////////////////////////////////////
//Parte del codice di Andromeda Quonset....aggiunto giù in diverse parti
list Menu2 = [ "-", "0","enter","7","8","9","4","5","6","1","2","3"];
string Input = "";
string Sign = "+";
string SignInput = " ";
string Caption = "Inserisci un numero, inclusi i numeri che hanno 0 iniziale: ";
 
///////////////////////////////////////////////////////////////////////////////
// NON MODIFICATE NULLA SOTTO QUESTA LINEA .... NO ... NIENT'ALTRO
///////////////////////////////////////////////////////////////////////////////
 
//Nomi delle opzioni - questi sranno i nomi dei vostri pulsanti.
string optRecord = "Record";
string optReset = "Reset";
string optBuild = "Build";
string optPos = "Position";
string optClean = "Clean";
string optDone = "Done";
string optChannel = "Channel";
 
//Descrizione delle opzioni del menu
string descRecord = ": Registra la posizizione di tutti i componenti\n";
string descReset = ": Cancella la posizione di tutti i componenti\n";
string descBuild = ": Rezza e posiziona la nostra costruzione\n";
string descPos = ": Riposiziona i componenti in una nuova posizione\n";
string descClean = ": De-Rezza tutti i componenti\n";
string descDone = ": Rimuove tutti gli script BB e fissa tutti i componenti.\n";
string descChannel = ": Cambia il canale usato dalla base e dai componenti.\n";
 
integer MENU_CHANNEL;
integer MENU2_CHANNEL;
integer MENU_HANDLE;
integer MENU2_HANDLE;
key agent;
key objectowner;
integer group;
string title = "";
list optionlist = [];
integer bMoving;
vector vLastPos;
rotation rLastRot;
integer bRezzing;
integer iListenTimeout = 0;
integer iLastRez = 0;
integer iRezIndex;
 
 
InvertSign()
{
    if(Sign == "+")
        Sign = "-";
    else
        Sign = "+";
}
 
//Per evitare un'indondazione della sim con un alto numero di movimenti
//(con conseguente stallo del simulatore), useremo
// una piccola "valvola" di limitazione
announce_moved()
{
    llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
    llResetTime();        //Resetta la nostra valvola
    vLastPos = llGetPos();
    rLastRot = llGetRot();
    return;
}
 
 
rez_object()
{
    //Rezza l'oggetto indicato dall' iRezIndex
    llRezObject(llGetInventoryName(INVENTORY_OBJECT, iRezIndex), llGetPos(), ZERO_VECTOR, llGetRot(), PRIMCHAN);
    iLastRez = llGetUnixTime();
 
    if(!bRezzing) {
        bRezzing = TRUE;
        //timer_on();
    }
}
 
post_rez_object()
{
    if ( creatorUUID != llGetOwner() ) {
        if(deleteOnRez) llRemoveInventory(llGetInventoryName(INVENTORY_OBJECT, iRezIndex));
    }
}
 
heard(integer channel, string name, key id, string message)
{
    if( channel == PRIMCHAN ) {
        if( message == "READYTOPOS" ) {
            //Nuovo prim pronto per essere posizionato
            vector vThisPos = llGetPos();
            rotation rThisRot = llGetRot();
            llRegionSay(PRIMCHAN, "MOVESINGLE " + llDumpList2String([ vThisPos, rThisRot ], "|"));
 
        } else if( message == "ATDEST" ) {
            //Rezza il prossimo nella sequenza (Eventuali)
            iRezIndex--;
            if(iRezIndex >= 0) {
                //Cerca di rezzarlo
                rez_object();
            } else {
                //Abbiamo costruito, resettiamo i nostri listeners
                iLastRez = 0;
                bRezzing = FALSE;
                state reset_listeners;
            }
        }
        return;
 
    } else if( channel == MENU_CHANNEL ) {   //Processa gli input dal menu originale
        if ( message == optRecord ) {
            PRIMCHAN = DefaultPRIMCHAN;
            llOwnerSay("Sto memorizzando le posizioni...");
            if(recordSimLocation) {
                //Posizione in sim
                llRegionSay(PRIMCHAN, "RECORDABS " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            } else {
                //Posizione relativa alla base
                llRegionSay(PRIMCHAN, "RECORD " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            }
            return;
        }
        if( message == optReset ) {
            llOwnerSay("Sto cancellando le posizioni...");
            llShout(PRIMCHAN, "RESET");
            return;
        }
        if ( message == optBuild ) {
            if(chatty) llOwnerSay("Sto rezzando le parti della costruzione...");
 
            //Se il rezzing/posizionamento è "uno alla volta", abbiamo bisogno
            // di ascoltare per sapere quando hanno raggiunto la loro destinazione
            if(!bulkBuild) {
                llListen(PRIMCHAN, "", NULL_KEY, "READYTOPOS");
                llListen(PRIMCHAN, "", NULL_KEY, "ATDEST");
            }
 
            //Inizia il rezzing, prima l'ultimo pezzo
            iRezIndex = llGetInventoryNumber(INVENTORY_OBJECT) - 1;
            rez_object();
            return;
        }
        if ( message == optPos ) {
            if(chatty) llOwnerSay("Sto posizionando");
            vector vThisPos = llGetPos();
            rotation rThisRot = llGetRot();
            llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ vThisPos, rThisRot ], "|"));
            return;
        }
        if ( message == optClean ) {
            llRegionSay(PRIMCHAN, "CLEAN");
            if(dieOnClean) llDie();
            return;
        }
        if ( message == optDone ) {
            llRegionSay(PRIMCHAN, "DONE");
            if(chatty) llOwnerSay("Sto rimuovendo gli script Builder's Buddy.");
            return;
        }
        if ( message == optChannel ) {
            Sign = "+"; //di default è un numero positivo
            Input = "";
            llDialog( agent, Caption, Menu2, MENU2_CHANNEL );
        }
 
    } else if ( channel == MENU2_CHANNEL ) {    //Processa gli input dal MENU2
        // se è stata fatta una scelta valida, attua la scelta, se possibile.
        // (llListFindList ritorna -1 se la scelta non è nella lista del menu.)
        if ( llListFindList( Menu2, [ message ]) != -1 ) {
            if( llListFindList(["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"], [message]) != -1) {
                Input += message;
                SignInput = Sign + Input;
                llDialog( agent, Caption + SignInput, Menu2, MENU2_CHANNEL );
 
            } else if( message == "-" ) {
                InvertSign();
                SignInput = Sign + Input;
                llDialog( agent, Caption + SignInput, Menu2, MENU2_CHANNEL );
 
            } else if( message == "enter" ) {     //termina gli input dal menu2
                string CalcChan = Input;
 
                //Applicare compatibilità con ShapeGen?
                if(SGCompatible) {
                    //assegna un nuovo canale, forzando le ultime 4 cifre a 0000
                    integer ChanSize = llStringLength(Input); //determina il numero di cifre (caratteri)
                    if(ChanSize > 5) {
                        CalcChan = llGetSubString(Input, 0, 4);    //Accorcia alla 5 cifra
                    }
                    CalcChan += "0000"; //aggiunge 0000
                    if(Sign == "-")
                        CalcChan = Sign + CalcChan;
                }
                PRIMCHAN = (integer)CalcChan; //assegna il numero del canale
                llOwnerSay("Channel set to " + (string)PRIMCHAN + ".");
            }
 
        } else {
            llDialog( agent, Caption, Menu2, MENU2_CHANNEL );
        }
    }
}
 
 
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
default {
    ///////////////////////////////////////////////////////////////////////////////
    changed(integer change) {
        if(change & CHANGED_OWNER)
        llResetScript();
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    state_entry () {
        //Definisce la UUID del Creator
        if(creatorUUID == "") creatorUUID = llGetCreator();
 
        //Quale menu utilizzare?
        if (creatorUUID == llGetOwner() || fullOptions) {
            //Mostra tutte le opzioni
            optionlist = [optPos, optClean, optDone, optRecord, optReset, optBuild, optChannel];
            title = optRecord + descRecord;
            title += optReset + descReset;
            title += optBuild + descBuild;
            title += optPos + descPos;
            title += optClean + descClean;
            title += optDone + descDone;
            title += optChannel + descChannel;
 
        } else {
            //Mostra le opzioni limitate
            if(allowClean) {
                optionlist = [optBuild, optPos, optClean, optDone];
                title = optBuild + descBuild;
                title += optPos + descPos;
                title += optClean + descClean;
                title += optDone + descDone;
            } else {
                optionlist = [optBuild, optPos, optDone];
                title = optBuild + descBuild;
                title += optPos + descPos;
                title += optDone + descDone;
            }
        }
 
        //Memorizza la nostra posizione
        vLastPos = llGetPos();
        rLastRot = llGetRot();
 
        llSetTimerEvent(fTimerRate);
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    touch_start (integer total_number) {
        group = llDetectedGroup(0); // L'utilizzatore è nel gruppo assegnato all'oggetto?
        agent = llDetectedKey(0); // La key dell'utilizzatore
        objectowner = llGetOwner(); // La key del gruppo assegnato all'oggetto
        // se l'utilizzatore = owner OPPURE l'utilizzatore è nel gruppo assegnato all'oggetto
        if ( (objectowner == agent) || ( group && ingroup )  )  {
            iListenTimeout = llGetUnixTime() + llFloor(fListenTime);
            MENU_CHANNEL = llFloor(llFrand(-99999.0 - -100));
            MENU2_CHANNEL = MENU_CHANNEL + 1;
            MENU_HANDLE = llListen(MENU_CHANNEL,"","","");
            MENU2_HANDLE = llListen(MENU2_CHANNEL,"","","");
            if ( creatorUUID == llGetOwner() || fullOptions) {
                llDialog(agent,title + "Now on Channel " + (string)PRIMCHAN, optionlist, MENU_CHANNEL); //mostra il numero del canale se autorizzati
            } else {
                llDialog(agent, title, optionlist, MENU_CHANNEL);
            }
            //timer_on();
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    listen(integer channel, string name, key id, string message) {
        heard(channel, name, id, message);
        return;
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    moving_start()
    {
        if( !bMoving )
        {
            bMoving = TRUE;
            //timer_on();
            announce_moved();
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    object_rez(key id) {
        //L'oggetto rezzato, compie ogni azione post-rez
        post_rez_object();
 
        //Rezzare tutto prima di posizionare?
        if(bulkBuild) {
            //Passare all'oggetto successivo
            //Ciclo indietro (precauzione di sicurezza in caso di variazione dell'inventario)
            iRezIndex--;
            if(iRezIndex >= 0) {
                //Cerca di rezzarlo
                rez_object();
 
            } else {
                //Rezzing completato, adesso posizionamento
                iLastRez = 0;
                bRezzing = FALSE;
                if(chatty) llOwnerSay("Posizionamento");
                llRegionSay(PRIMCHAN, "MOVE " + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            }
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    timer() {
        //Abbiamo cambiato posizione/rotazione?
        if( (llGetRot() != rLastRot) || (llGetPos() != vLastPos) )
        {
            if( llGetTime() > fTimerRate ) {
                announce_moved();
            }
        }
 
        //Stiamo rezzando?
        if(bRezzing) {
            //L'ultimo è stato troppo lungo?
            if((llGetUnixTime() - iLastRez) >= iRezWait) {
                //Si, riprova
                if(chatty) llOwnerSay("Tentativo di Re-Rez delle ultime parti");
                rez_object();
            }
        }
 
        //listener aperto?
        if( iListenTimeout != 0 )
        {
            //Terminato e/o chiuso il nostro timeout?
            if( iListenTimeout <= llGetUnixTime() )
            {
                iListenTimeout = 0;
                llListenRemove(MENU_HANDLE);
            }
        }
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    on_rez(integer iStart)
    {
        //Resettiamo
        llResetScript();
    }
}
 
 
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
state reset_listeners
{
    //////////////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
        state default;
    }
}