///////////////////////////////////////////////////////////////////////////////
// Builders' Buddy 1.10 (Base Script)
// by Newfie Pendragon, 2006-2008
///////////////////////////////////////////////////////////////////////////////
//
// Traduzione di RINOBIT Footman, 06/06/2010
//
// Uso e scopo dello script
// Le funzioni dipendono dal "component script"
//
// USO VELOCE:
// - Trascinate questo script nella base.
// - Trascinate il "Component Script" in ogni parte della costruzione.
// - Toccate la vostra base, e scegliete RECORD.
// - Prendete tutte le parti della costruzione nell'inventario.
// - Trascinate le parti della costruzione dall'inventario al Base Prim.
// - Toccate la vostra base e scegliete BUILD.
//
// ALTRI COMANDI dal Menu Touch
// - Per riposizionare, muovere/ruotare il Base Prim scegliete POSITION
// - Per bloccare in una posizione (rimuove gli scripts) scegliete DONE
// - Per cancellare la costruzione: scegliete CLEAN
///////////////////////////////////////////////////////////////////////////////
// Questo script è materiale protetto da copyright, e ha una (seppur minima) restrizione.
// Per tutti i dettagli, compresa una cronologia delle revisioni, vedere
// http://wiki.secondlife.com/wiki/Builders_Buddy
///////////////////////////////////////////////////////////////////////////////
 
 
//////////////////////////////////////////////////////////////////////////////////////////
// Impostazioni configurabili
float fTimerInterval = 0.25;        // Tempo in secondi tra i movimenti 'ticks'
integer DefaultChannel = 192567; // Canale di default di Andromeda Quonset
integer PRIMCHAN = 192567;  // Canale usato dalla Base Prim per counicare con i Component Prims;
                                    // ***QUESTO DEVE CORRISPONDERE IN ENTRAMBI GLI SCRIPT!***
 
//////////////////////////////////////////////////////////////////////////////////////////
// Variabili di Runtime (Non è necessario modificare nulla qui sotto a meno che non vogliate farne un derivato)
vector vOffset;
rotation rRotation;
integer bNeedMove;
vector vDestPos;
rotation rDestRot;
integer bMovingSingle = FALSE;
integer bAbsolute = FALSE;
integer bRecorded = FALSE;
 
 
////////////////////////////////////////////////////////////////////////////////
string first_word(string In_String, string Token)
{
    // Questa sequenza cerca la prima parola in una stringa,
    // e la restituisce.  Se non trova nessuna parola, restituisce
    // l'intera stringa.
    if(Token == "") Token = " ";
    integer pos = llSubStringIndex(In_String, Token);
 
    //Trovata?
    if( pos >= 1 )
        return llGetSubString(In_String, 0, pos - 1);
    else
        return In_String;
}
 
////////////////////////////////////////////////////////////////////////////////
string other_words(string In_String, string Token)
{
    //Questa sequenza cerca le altre parole che non siano la prima in una stringa,
    // e la restituisce.  Se non trova nessuna parola, restituisce
    // una stringa vuota.
    if( Token == "" ) Token = " ";
 
    integer pos = llSubStringIndex(In_String, Token);
 
    //Trovata?
    if( pos >= 1 )
        return llGetSubString(In_String, pos + 1, llStringLength(In_String));
    else
        return "";
}
 
////////////////////////////////////////////////////////////////////////////////
do_move()
{
    integer i = 0;
    vector vLastPos = ZERO_VECTOR;
    while( (i < 5) && (llGetPos() != vDestPos) )
    {
        list lParams = [];
 
        //Se siamo lì....
        if( llGetPos() != vDestPos )
        {
            //Potremmo essere bloccati a terra ...
            //Abbiamo mosso tutto rispetto all'ultimo ciclo?
            if( llGetPos() == vLastPos )
            {
                //Si, bloccato...sostiamo in alto 10m (Tentativo di sloggiare)
                lParams = [ PRIM_POSITION, llGetPos() + <0, 0, 10.0> ];
                //llSetPos(llGetPos() + <0, 0, 10.0>);
            } else {
                //Memorizziamo il nostro posto per un eventuale 'blocco'
                vLastPos = llGetPos();
            }
        }
 
        //Cerca di muovere verso la destinazione
        //Aggiornato all'uso di llSetPrimitiveParams nuova funzione più veloce
        //(Newfie, June 2006)
        integer iHops = llAbs(llCeil(llVecDist(llGetPos(), vDestPos) / 10.0));
        integer x;
        for( x = 0; x < iHops; x++ ) {
            lParams += [ PRIM_POSITION, vDestPos ];
        }
        llSetPrimitiveParams(lParams);
        //llSleep(0.1);
        i++;
    }
 
    //Setta la rotazione
    llSetRot(rDestRot);
}
 
start_move(string sText, key kID)
{
    //Non muove se non abbiamo ancora memorizzato la posizione
    if( !bRecorded ) return;
 
    //Inoltre ignora i comandi dalla base per un utilizzatore diverso dall'owner
    //(Procedura Anti-hacking)
    if( llGetOwner() != llGetOwnerKey(kID) ) return;
 
 
    //Calcola la nostra posizione di destinazione riferita alla base?
    if(!bAbsolute) {
        //Posizione relativa
        //Calcola la nostra posizione di destinazione
        sText = other_words(sText, " ");
        list lParams = llParseString2List(sText, [ "|" ], []);
        vector vBase = (vector)llList2String(lParams, 0);
        rotation rBase = (rotation)llList2String(lParams, 1);
 
        vDestPos = (vOffset * rBase) + vBase;
        rDestRot = rRotation * rBase;
    } else {
        //Posizione in sim
        vDestPos = vOffset;
        rDestRot = rRotation;
    }
 
    //Si assicura che la posizione calcolata sia all'interno della sim
    if(vDestPos.x < 0.0) vDestPos.x = 0.0;
    if(vDestPos.x > 255.0) vDestPos.x = 255.0;
    if(vDestPos.y < 0.0) vDestPos.y = 0.0;
    if(vDestPos.y > 255.0) vDestPos.y = 255.0;
    if(vDestPos.x > 768.0) vDestPos.x = 768.0;
 
    //Accende il nostro timer per procedere al posizionamento?
    if( !bNeedMove )
    {
        llSetTimerEvent(fTimerInterval);
        bNeedMove = TRUE;
    }
    return;
}
 
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
default
{
    //////////////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
        //Apre il listener
        llListen(PRIMCHAN, "", NULL_KEY, "");
        llRegionSay(PRIMCHAN, "READYTOPOS");
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    on_rez(integer iStart)
    {
        //Imposta il canale a quello specificato
        if( iStart != 0 )
        {
            PRIMCHAN = iStart;
            state reset_listeners;
        }
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    listen(integer iChan, string sName, key kID, string sText)
    {
        string sCmd = llToUpper(first_word(sText, " "));
 
        if( sCmd == "RECORD" )
        {
            //Memorizza la posizione relativa alla base
            sText = other_words(sText, " ");
            list lParams = llParseString2List(sText, [ "|" ], []);
            vector vBase = (vector)llList2String(lParams, 0);
            rotation rBase = (rotation)llList2String(lParams, 1);
 
            vOffset = (llGetPos() - vBase) / rBase;
            rRotation = llGetRot() / rBase;
            bAbsolute = FALSE;
            bRecorded = TRUE;
            llOwnerSay("Posizione memorizzata.");
            return;
        }
 
        if( sCmd == "RECORDABS" )
        {
            //Memorizza la posizione assoluta
            rRotation = llGetRot();
            vOffset = llGetPos();
            bAbsolute = TRUE;
            bRecorded = TRUE;
            llOwnerSay("Posizione nella sim memorizzata.");
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "MOVE" )
        {
            start_move(sText, kID);
            return;
        }
 
        if( sCmd == "MOVESINGLE" )
        {
            //Se non lo abbiamo ottenuto prima, ci posiziona
            if(!bMovingSingle) {
                //Memorizza che il movimento è di un singlolo-prim
                bMovingSingle = TRUE;
 
                //Inizia a muovere
                start_move(sText, kID);
                return;
            }
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "DONE" )
        {
            //Abbiamo fatto, rimuove gli scripts
            llRemoveInventory(llGetScriptName());
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "CLEAN" )
        {
            //Ripulisce
            llDie();
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "RESET" )
        {
            llResetScript();
        }
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    timer()
    {
        //Spegne il timer
        llSetTimerEvent(0.0);
 
        //Abbiamo bisogno di muoverci?
        if( bNeedMove )
        {
            //Esegue il movimento e pulisce
            do_move();
 
            //Se muove un singolo-prim, avverte la base quando è stato fatto
            if(bMovingSingle) {
                llRegionSay(PRIMCHAN, "ATDEST");
            }
 
            //Avvenuto il movimento
            bNeedMove = FALSE;
        }
        return;
    }
}
 
 
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
state reset_listeners
{
    //////////////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
        state default;
    }
}