// "Sound" - Starting Template Script v1 - 2/13/2009 - Jopsy Pendragon
// This is a free sample script from THE PARTICLE LABORATORY in Teal.

// llPlaySound() is an LSL FUNCTION that plays a sound once.
// llLoopSound() will cause the sound to play over and over.

integer AUTO_START = FALSE;   // Optionally FALSE only if using CONTROLLERS.
integer LOOP_SOUND = TRUE;  // set to true to play the sound over and over.
float VOLUME = 1.0;  // 0.0 = silent to 1.0 = full volume 

string  CONTROLLER_ID = "ANB"; // Ignore ALL Linked messages that don't send this message.
string sound_asset; // sound asset name is auto-detected below.

sound(integer mode) {
    if ( ! mode ) { 
        llStopSound();
    } else { 
        if ( LOOP_SOUND) {
            llLoopSound( sound_asset, VOLUME );
        } else { 
            llPlaySound( sound_asset, VOLUME );
        }
    } 
}

default {  
    state_entry() {
        sound_asset = llGetInventoryName( INVENTORY_SOUND, 0 );
        sound( AUTO_START ); 
    }  
    
    changed(integer detected_change) { 
        if ( detected_change & CHANGED_INVENTORY ) llResetScript(); // might have a new sound to use
    }
        
    link_message( integer sibling, integer mode, string message, key target_key ) {
        
        if ( message != CONTROLLER_ID )  return; // this message isn't for me.  Bail out.   
         
        sound(mode);  
    } 
}  
  