//Free Posing Stand
//based on Thili Playfair s work
//followed by Karandas Banjo and Ariane Brodie
//adapted to Pose Stand by YadNi Monde




string vendorname;
integer total;
integer counter;
integer change;
integer anim_on = FALSE;
string curranim;
string lastanim;
vector offset=<0,0,0.7>;
key avatar;

next()
{
    total=llGetInventoryNumber(INVENTORY_ANIMATION);
    vendorname = llGetObjectName();
    counter++;
    if(counter>=total)
    {
        counter=0;
    }
    lastanim = curranim;
    curranim = llGetInventoryName(INVENTORY_ANIMATION,    counter);
    

    if (anim_on) {
        llStopAnimation(lastanim);
        llStartAnimation(curranim);
    }
}
prev()
{
    total=llGetInventoryNumber(INVENTORY_ANIMATION);
    vendorname = llGetObjectName();
    if (counter > 0)
    {
        counter--;
    }
    else
    {
        counter=total - 1;
    }
    lastanim = curranim;
    curranim = llGetInventoryName(INVENTORY_ANIMATION,    counter);
    

    if (anim_on) {
        llStopAnimation(lastanim);
        llStartAnimation(curranim);
    }
}

default
{
    state_entry()
    {
        rotation rot = llEuler2Rot(<0,0,PI>);
        llSetSitText("POSE");
        llSitTarget(offset,rot);
        llSetCameraAtOffset(<0.0,0.0,1.0>);
        llSetCameraEyeOffset(<-4.0,0.0,1.0>);
        llSetText("", <1,1,1>, 1);
        next();
        
    }

    touch_start(integer total_number)
    {
        if ( llGetLinkName(llDetectedLinkNumber(0)) == "next" )
        {
            next();
        }
        else if ( llGetLinkName(llDetectedLinkNumber(0)) == "prev" )
        {
            prev();
        }
        
    }

    

    

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_LINK)
        {
            avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY)
            {
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (llGetPermissionsKey() != NULL_KEY) {
                    llStopAnimation(curranim);
                    anim_on = FALSE;
                }
            }
        }
    }

    run_time_permissions(integer perm)
    {
        if(perm == PERMISSION_TRIGGER_ANIMATION)
        {
            llStopAnimation("sit");
            llStartAnimation(curranim);
            anim_on = TRUE;
        }
    }
}



 