// SECTION ONE: These settings affect how each particle LOOKS.
integer      glow = TRUE;        // TRUE or FALSE, Make the particles glow
vector startColor = <1,0.6,0>;     // Start color of particles <R,G,B> (each is 0.0(dark) to 1.0(bright))
vector   endColor = <0,0,0>;     // End color of particles <R,G,B> (if interpColor == TRUE)
float  startAlpha = 1.0;         // 0(invis) to 1.0(opaque), Start alpha (transparency) value
float    endAlpha = 0.2;         // End alpha (transparency) value
vector  startSize = <1.1,1.1,0>; // <.04,.04,0> to <10,10,0> Start size of particles 
vector    endSize = <4.5,4.5,0>; // End size of particles.  (3rd part of vector is ignored)
string    texture = "";          // Texture used for particles, default used if blank


// SECTION TWO:   These settings affect how Many, how Quickly, and for how Long particles are created.
//     Note, 
integer count = 12;    // How many particles to emit per burst (0 = off)
float    rate = 0.04;   // How long to wait between burst (0.01 to 60, avoid 0.0 if you can)
float     age = 11.0;   // How long does each particle live? (0.2 to 60)
float    life = 0.0;   // How long to wait keep creating new particles (0.0 = never stop)

// SECTION THREE:  Where are new particles created, and what direction are they facing?
// Choose a pattern from the following:
// PSYS_SRC_PATTERN_EXPLODE (sends particles in all directions)
// PSYS_SRC_PATTERN_DROP  (count>1 is useless for this one, it also ignores minSpeed and maxSpeed)
// PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY  (I've never gotten this one to work -- Jopsy)
// PSYS_SRC_PATTERN_ANGLE_CONE (set innerangle/outerange to make rings/cones of particles)
// PSYS_SRC_PATTERN_ANGLE (set innerangle/outerangle to make flat fanshapes of particles)
integer   pattern = PSYS_SRC_PATTERN_DROP;
float      radius = 0;     // 0 to ?50?  How far from Emitter to create particles.
float  innerAngle = PI;      // "tilt", for all ANGLE patterns, 0 to TWO_PI
float  outerAngle = 0.0;     // "spread", for ANGLE patterns,  0 to TWO_PI, can use PI_BY_TWO or PI as well.
vector      omega = <0,0,0>; // Rotation of ANGLE patterns around the source <X,Y,Z>, 
                             // Warning, there's no way to RESET the emitter direction once you use Omega!!
                             // You must attach the script to a new prim to clear the effect of omega.

// SECTION FOUR:  How do the particles move once they're created?
integer followSource = FALSE;   // TRUE or FALSE, Particles move as the emitter moves, (TRUE disables radius.)
integer    followVel = TRUE;    // TRUE or FALSE, Particles rotate towards their direction
integer         wind = TRUE;   // TRUE or FALSE, Particles get blown away by wind in the sim
integer       bounce = TRUE;   // TRUE or FALSE, Make particles bounce on Z altitude of emitter
float       maxSpeed = 13.15;     // 0.01 to ? Max speed each particle is spit out at
float       minSpeed = 2.3;     // 0.01 to ? Min speed each particle is spit out at
vector          push = <0,0,0.4>; // Continuous force pushed on particles, use small settings for long lived particles
key           target = "";      // Select a target for particles to arrive at when they die
                                // can be "self" (emitter), "owner" (you), "" or any prim/persons KEY.

// SECTION FIVE:   Ama's "Create Short Particle Settings List"
integer  enableoutput = TRUE; // Please wait until class is over before setting this to TRUE.

// === Don't muck about below this line unless you're comfortable with the LSL scripting language ====

// Script variables
integer pre = 2;          //Adjust the precision of the generated list.
integer flags;
list sys;
integer type;
vector tempVector;
rotation tempRot;
string tempString;
integer i;

string float2String(float in)
{
    return llGetSubString((string)in,0,pre - 7);
}

updateParticles()
{
    flags = 0;
    if (target == "owner") target = llGetOwner();
    if (target == "self") target = llGetKey();
    if (glow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (bounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (startColor != endColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (startSize != endSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (wind) flags = flags | PSYS_PART_WIND_MASK;
    if (followSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (followVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (target != "") flags = flags | PSYS_PART_TARGET_POS_MASK;
    sys = [  PSYS_PART_MAX_AGE,age,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR, startColor,
                        PSYS_PART_END_COLOR, endColor,
                        PSYS_PART_START_SCALE,startSize,
                        PSYS_PART_END_SCALE,endSize, 
                        PSYS_SRC_PATTERN, pattern,
                        PSYS_SRC_BURST_RATE,rate,
                        PSYS_SRC_ACCEL, push,
                        PSYS_SRC_BURST_PART_COUNT,count,
                        PSYS_SRC_BURST_RADIUS,radius,
                        PSYS_SRC_BURST_SPEED_MIN,minSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
                        PSYS_SRC_TARGET_KEY,target,
                        PSYS_SRC_INNERANGLE,innerAngle, 
                        PSYS_SRC_OUTERANGLE,outerAngle,
                        PSYS_SRC_OMEGA, omega,
                        PSYS_SRC_MAX_AGE, life,
                        PSYS_SRC_TEXTURE, texture,
                        PSYS_PART_START_ALPHA, startAlpha,
                        PSYS_PART_END_ALPHA, endAlpha
                            ];
    float newrate = rate;
    if (newrate == 0.0) newrate=.01;
    if ( (age/rate)*count < 4096) llParticleSystem(sys);
    else {
        llInstantMessage(llGetOwner(),"Your particle system creates too many concurrent particles.");
        llInstantMessage(llGetOwner(),"Reduce count or age, or increate rate.");
        llParticleSystem( [ ] );
    }
}
integer onoff;
default
{
    state_entry()
    {
        onoff=0;
        updateParticles();
    }
    
    touch_start(integer num)
    {
        if ( enableoutput == FALSE ) {
            if ( onoff ) llResetScript();
            onoff++;
            llParticleSystem( [ ] );
            return;
        }
        if (1) return;  //  Comment out this line to enable this function
        llWhisper(0,"...Generating List...");
        for (i=1;i<42;i+=2)
        {
            type = llGetListEntryType(sys,i);
            if(type == TYPE_FLOAT)
            {
                tempString = float2String(llList2Float(sys,i));
                sys = llDeleteSubList(sys,i,i);
                sys = llListInsertList(sys,[tempString],i);
            }
            else if (type == TYPE_VECTOR)
            {
                tempVector = llList2Vector(sys,i);
                tempString = "<" + float2String(tempVector.x) + "," 
                    + float2String(tempVector.y) + "," 
                    + float2String(tempVector.z) + ">";
                sys = llDeleteSubList(sys,i,i);
                sys = llListInsertList(sys,[tempString],i);
            }
            else if (type == TYPE_ROTATION)
            {
                tempRot = llList2Rot(sys,i);
                tempString = "<" + float2String(tempRot.x) + "," 
                    + float2String(tempRot.y) + "," 
                    + float2String(tempRot.z) + "," 
                    + float2String(tempRot.s) + ">";
                sys = llDeleteSubList(sys,i,i);
                sys = llListInsertList(sys,[tempString],i);
            }
            else if (type == TYPE_STRING || type == TYPE_KEY)
            {
                tempString = "\"" + llList2String(sys,i) + "\"";
                sys = llDeleteSubList(sys,i,i);
                sys = llListInsertList(sys,[tempString],i);
            }
        }
        i = llListFindList(sys,[20,""]);
        if (i != -1) sys = llDeleteSubList(sys,i,i+1);
        llWhisper(0,"[" + llList2CSV(llList2List(sys,0,22)) + ",");
        llWhisper(0,llList2CSV(llList2List(sys,23,-1)) + "]");
    }
}