//
//  Popgun
//
//  This script is a basic gun- it waits for a mouseclick in mouselook and
//  then fires a bullet in the direction the user is facing. 
//  It also animates the avatar holding it, to create a convining hold and 
//  firing look for the gun. 
// 
//  This script can be used as a good basis for other weapons. 
//  

float SPEED         = 25.0;         //  Speed of arrow in meters/sec
integer LIFETIME    = 8;            //  How many seconds will bullets live 
                                    //  before deleting themselves
float DELAY         = 0.1;          //  Delay between shots to impose 

vector vel;                         //  Used to store velocity of arrow to be shot 
vector pos;                         //  Used to store position of arrow to be shot
rotation rot;                       //  Used to store rotation of arrow to be shot

integer have_permissions = FALSE;   //  Indicates whether wearer has yet given permission 
                                    //  to take over their controls and animation.
                                    
integer armed = TRUE;               //  Used to impose a short delay between firings

float gmass;
                                    

fire()
{
    // 
    //  This subroutine creates and fires an arrow
    //
    if (armed)
    {
        //  
        //  Actually fires the arrow
        //  
        armed = FALSE;
        rot = llGetRot();               //  Get current avatar mouselook directiondefault
{
//    state_entry()
//    {
//        llSay(0, "Script running");
//    }
}
        vel = llRot2Fwd(rot);           //  Convert rotation to a direction vector
        pos = llGetPos();               //  Get position of avatar to create arrow
        pos = pos + vel;                //  Create arrow slightly in direction of travel
        pos.z += 0.75;                  //  Correct creation point upward to eye point 
                                        //  from hips,  so that in mouselook we see arrow 
                                        //  travelling away from the camera. 
        vel = vel * SPEED;              //  Multiply normalized vector by speed 
        
        //llStartAnimation("shoot_R_handgun");    //  Trigger the bow release animation
        llTriggerSound("cannon", 1.0); //  Make the sound of the arrow being shot
        llRezObject("cannon shot", pos, vel, rot, LIFETIME); 
                                            //  Create the actual arrow from object 
                                            //  inventory, and set its position, velocity, 
                                            //  and rotation.  Pass a parameter to it to 
                                            //  tell it how long to live.
                                            
        //llSetTimerEvent(DELAY);         //  Wait until can fire again
        recoil();
        smoke();
         llSleep(4.0);
        llResetScript();
    }
}


recoil()
{
        vector pos = llGetPos();
       rotation rot = llGetRot();
        vector eulerrot = llRot2Fwd(rot);
        vector newpos = pos - eulerrot;
        llSleep(0.1);
        llSetPos(<newpos.x+0.01, newpos.y, newpos.z>);
        llSetPos (<pos.x, pos.y, pos.z>);
}

smoke()
{
         llParticleSystem([
         PSYS_PART_FLAGS, 0 | PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK | PSYS_PART_WIND_MASK,
         PSYS_SRC_PATTERN, 2 | PSYS_SRC_PATTERN_EXPLODE,
         PSYS_PART_START_ALPHA, 1.0,
         PSYS_PART_END_ALPHA, 0,
//         PSYS_PART_START_COLOR, <0.0, 0.0, 0.0>,
//         PSYS_PART_END_COLOR, <0, 0, 0>,
         PSYS_PART_START_SCALE, <.5, .5, 0.0>, 
         PSYS_PART_END_SCALE, <1.0, 1.0, 0>, 
         PSYS_PART_MAX_AGE, 1,
         PSYS_SRC_ACCEL, <-5.0, 0, 1>,
         PSYS_SRC_BURST_PART_COUNT, 2,
         PSYS_SRC_BURST_RADIUS, .2,
         PSYS_SRC_BURST_RATE, 0.01,
         PSYS_SRC_BURST_SPEED_MIN, 0.02,
         PSYS_SRC_BURST_SPEED_MAX, 0.02,
         PSYS_SRC_INNERANGLE, 0.09375,
         PSYS_SRC_OUTERANGLE, 0.00000,
         PSYS_SRC_OMEGA, <0, 0, 0>,
         PSYS_SRC_TEXTURE, (key)"52c68e3f-3218-4240-a70d-2aacb2133c25",
         PSYS_SRC_TARGET_KEY, (key)"00000000-0000-0000-0000-000000000000"
         ]);
}



default
{
    state_entry()
    //  
    //  This routine is called whenever the script is edited and restarted.  So if you 
    //  are editing the bow while wearing it, this code will re-request permissions 
    //  to animate and capture controls. 
    // 
    {
        
        llParticleSystem([]);
         gmass = llGetMass();         
      
    }
    on_rez(integer param)
    {
        //
        //  Called when the gun is created from inventory.
        // 
        llPreloadSound("cannon");        //  Preload shooting sound so you hear it
    }

    

   
   
    touch_start(integer num)
    {
      fire();
      smoke();
    }
    
    timer()
    {
        //  After timer expires, allow user to shoot bow again
        llSetTimerEvent(0.0);
        armed = TRUE;
    }
  
}
 