// Made by Seagel Neville


string DISPLAY_TEXT = "Sit"; 
string ANIMATION;
string GESTURE;
integer is_sitting;

list GESTURE_BUTTON =
[
"point_you", "point_me", "peace",
"nyanya", "toungue out", "blowkiss",
"wink#1", "wink#2", "embarassed",
"laugh", "surprise", "cry"
];

list GESTURE_LIST =
[
"point_you", "point_me", "peace",
"nyanya", "express_tongue_out", "blowkiss",
"wink_hollywood", "express_wink", "express_embarrased",
"express_laugh", "express_surprise", "express_cry"
];

opendialog_gestures()
{
    llDialog(llAvatarOnSitTarget(), "What do you want to do in front of this mirror?", GESTURE_BUTTON, 696543);
}

default 
{ 
    state_entry() 
    {
        llListen(696543, "", NULL_KEY, "");
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, 0); 
        is_sitting = 0; 
       llSitTarget(<2.71752, 0.17104, -1.59564>, <0.00000, 0.00000, 0.99966, -0.02618>);
        llSetText(DISPLAY_TEXT,<1,1,1>,1);
        llSetCameraEyeOffset(<-1, 0, 0>);
        llSetCameraAtOffset(<-5, 0, -100>);
    } 
     
    changed(integer change) 
    { 
        if(change & CHANGED_LINK) 
        { 
            key av = llAvatarOnSitTarget(); 
             
            if(av != NULL_KEY) 
            { 
                llRequestPermissions(av, PERMISSION_TRIGGER_ANIMATION); 
            } 
            else 
            { 
                if((llGetPermissions() & PERMISSION_TRIGGER_ANIMATION) && is_sitting) 
                {
                    llMessageLinked(LINK_SET, 0, "standing", NULL_KEY);
                    is_sitting = 0; 
                    llStopAnimation(ANIMATION); 
                    llSetText(DISPLAY_TEXT,<1,1,1>,1);
                    llUnSit(av);
                    llOwnerSay("Press \"Ignore\" button if you want to remove the menus.");
                } 
            }
        }          
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, 0); 
    } 
    listen(integer channel, string name, key id, string message)
    {
    if (llListFindList(GESTURE_BUTTON, [message]) != -1)  // verify dialog choice
    {
        opendialog_gestures();   // The dialog box keeps showing until you choose "Ignore".
        GESTURE = llList2String(GESTURE_LIST, llListFindList(GESTURE_BUTTON, [message]));
        llStartAnimation(GESTURE);
        }
    }
    run_time_permissions(integer perm) 
    { 
        if(perm & PERMISSION_TRIGGER_ANIMATION) 
        {
            llMessageLinked(LINK_SET, 0, "sitting", NULL_KEY);
            is_sitting = 1; 
            llStopAnimation("sit_generic"); 
            llStopAnimation("sit"); 
            llStartAnimation(ANIMATION); 
            llSetText("",<1,1,1>,1);
            opendialog_gestures();
        } 
    }
    on_rez(integer start_param) 
    { 
        llResetScript(); 
    } 
} 