float age = 1.0;                // How long each particle will survive
float rate = .1;              // How many seconds between particle emissions
float radius = .03;             // Starting radius for Particles to appear within
integer count = 50;             // How many particles per emission (Per Rate)


float startAlpha = .07;         // Start alpha (transparency) value
float endAlpha = .02;             // End alpha (transparency) value
                                // Alpha is between 0.0 and 1.0

vector startColor = <0.8,0.3,0.0>;  // Starting color of particles <R,G,B>
vector endColor = <0.9,0.9,0.0>;     // End color of particles <R,G,B>
                                // <0,0,0> = Black <1,1,1> = White

// No Need to edit after this Line
//---------------------------------


MakeParticles()
     {                
         llParticleSystem(
         [
              PSYS_PART_FLAGS,0
             |PSYS_PART_WIND_MASK 
             |PSYS_PART_INTERP_COLOR_MASK 
             |PSYS_PART_INTERP_SCALE_MASK 
             |PSYS_PART_FOLLOW_SRC_MASK 
             |PSYS_PART_FOLLOW_VELOCITY_MASK
             ,PSYS_SRC_PATTERN
             ,PSYS_SRC_PATTERN_EXPLODE
             ,PSYS_SRC_TEXTURE,"2ca57748-4944-de53-b301-8d0efbafb2c6"
             ,PSYS_PART_MAX_AGE, age
             ,PSYS_SRC_BURST_RATE,rate
             ,PSYS_SRC_BURST_PART_COUNT,count
             ,PSYS_SRC_BURST_RADIUS,radius
             ,PSYS_SRC_BURST_SPEED_MIN,0.5
             ,PSYS_SRC_BURST_SPEED_MAX,1.0
             ,PSYS_SRC_ACCEL,<0.0,0.0,0.2>
             ,PSYS_PART_START_COLOR,startColor
             ,PSYS_PART_END_COLOR,endColor
             ,PSYS_PART_START_ALPHA,startAlpha
             ,PSYS_PART_END_ALPHA,endAlpha
             ,PSYS_PART_START_SCALE,<0.8,0.8,0.0>
             ,PSYS_PART_END_SCALE,<1.3,1.3,0.0>
             ,PSYS_SRC_ANGLE_BEGIN,-.1
             ,PSYS_SRC_ANGLE_END,.1
             ,PSYS_SRC_OMEGA,<0.0,0.0,0.0>
         ]);
     }
     default
     {
         state_entry() 
         {
           
             llParticleSystem([]);
             llSetTimerEvent(5);
         }
         on_rez(integer num)
         {
             llResetScript();
         }
         timer()
         {
             MakeParticles();
             
         }
     }