integer page;

string what_texture(key id)
{
    integer count;
    integer i;
    string name;
    string temp;
    key tempid;

    name = "";    
    count=llGetInventoryNumber(INVENTORY_TEXTURE);
    for ( i=0;i<count;i++) {
        temp = llGetInventoryName(INVENTORY_TEXTURE, i);
        if (id == llGetInventoryKey(temp)) {
            name = temp;
        }
    }
    return name;
}

load_buttons()
{
    integer i;
    integer start;
    integer max;
    key id;
    
    max = llGetInventoryNumber(INVENTORY_TEXTURE);
    if (page < 0) {
        page = max / 16;
    }
    start = page * 16;
    if (start >= max) {
        start = 0;
        page = 0;
    }
    
    for (i=0;i<16;i++) {
        if ((i+start)<max){
            id = llGetInventoryKey(llGetInventoryName(INVENTORY_TEXTURE, i+start));
        } else {
            id = TEXTURE_BLANK;
        }
        llSetLinkPrimitiveParamsFast((i+4),[PRIM_TEXTURE,ALL_SIDES,id,<1,1,1>,<0,0,0>,0]);
    }
    max = (max + 14) / 16;
    llSetText("Showing page " + (string)(page+1) + " of " + (string)max, <1,1,1>, 1);
}

load_showpanels(key id) {
    string name;
    
    name = what_texture(id);
    llSetLinkPrimitiveParamsFast(2,[PRIM_TEXTURE,ALL_SIDES,id,<1,1,1>,<0,0,0>,0]);
    llSetLinkPrimitiveParamsFast(2, [PRIM_TEXT,name,<1,1,1>,1]);
    llSetLinkPrimitiveParamsFast(3, [PRIM_TEXTURE, ALL_SIDES,id, <2,2,2>,<0,0,0>,0]);
}


default {
    state_entry()
    {
        list textureinfo;
        
        page = 0;
        load_buttons();
        textureinfo = llGetLinkPrimitiveParams(4, [PRIM_TEXTURE, 0]);
        load_showpanels(llList2Key(textureinfo, 0));
    }
    
    changed(integer change){
        if (change & CHANGED_INVENTORY) {
            llResetScript();
        }
    }
    
    link_message(integer sender, integer num, string str, key id) {
        string name;
        if (str == "next") {
            page++;
            load_buttons();
        } else if (str == "prev") {
            page--;
            load_buttons();
        } else if (str == "show") {
            load_showpanels(id);
        } else if (num == 42) {
            name = what_texture(id);
            if (name != "") {
                llGiveInventory(str, name);
            }
        }
    }
    
    touch_start(integer num)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            list givelist;
            integer count;
            integer i;
            
            count = llGetInventoryNumber(INVENTORY_TEXTURE);
            givelist = [];
            for (i=0;i<count;i++){
                givelist += llGetInventoryName(INVENTORY_TEXTURE, i);
            }
            llGiveInventoryList(llGetOwner(), llGetObjectName(), givelist);
        }
    }
} 