// "CM_Cup.lsl"
//
// Cale Vinson, Oct-2006
//
// Note: touch events commented out intentionally. The "touch to attach" idea worked fine
// fine for the owner, but gave an error message for everyone else.

string gDRINKING_ANIMATION;
string gRESTING_ANIMATION;
// key gUser;   (Used in touch event only)

InitOnce()
{
    gDRINKING_ANIMATION = "drink"; 
    gRESTING_ANIMATION = ""; 
}


//==============================================================================================
//    "default" state
//
//==============================================================================================

default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    run_time_permissions(integer perm)
    {
        if ( perm & PERMISSION_TRIGGER_ANIMATION )
            if ( perm & PERMISSION_ATTACH )
            {
                llAttachToAvatar(ATTACH_RHAND);
                state resting;
            }
    }
    
    
    state_entry()
    {
        InitOnce();

//        Following covers the case where the owner attaches the cup directly, ie., drags it from
//        inventory to the avatar. (Remember - we are resetting the script in the on_rez event.)
        
        if ( llGetAttached() != 0 )
            llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION | PERMISSION_ATTACH);
    }
    
    
//    touch_start(integer num_detected)
//    {
//        gUser = llDetectedKey(0);
//        llRequestPermissions(gUser, PERMISSION_TRIGGER_ANIMATION | PERMISSION_ATTACH);
//    }
}


//==============================================================================================
//    "drinking" state
//
//==============================================================================================

state drinking
{
    attach(key id)
    {
        if ( id == NULL_KEY )
            llStopAnimation(gDRINKING_ANIMATION);
    }
    
    
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    state_entry()
    {
        if ( llGetAttached() == 0 )
            llResetScript();
        
        llStartAnimation(gDRINKING_ANIMATION);
        llSetTimerEvent(2.5);
    }
    
    
    state_exit()
    {
        llStopAnimation(gDRINKING_ANIMATION);
        llSetTimerEvent(0.0);
    }
    
    
    timer()
    {
        state resting;
    }
}


//==============================================================================================
//    "resting" state
//
//==============================================================================================

state resting
{
    attach(key id)
    {
        if ( id == NULL_KEY )
            llStopAnimation(gRESTING_ANIMATION);
    }
    
    
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    state_entry()
    {
        if ( llGetAttached() == 0 )
            llResetScript();
        
        llStartAnimation(gRESTING_ANIMATION);
        llSetTimerEvent(12.0);
    }
    
    
    state_exit()
    {
        llStopAnimation(gRESTING_ANIMATION);
        llSetTimerEvent(0.0);
    }
    
    
    timer()
    {
        state drinking;
    }
}
