// Mask Flags - set to TRUE to enable
integer iGlow = TRUE;            // Set particles to be self illuminated
integer iBounce = FALSE;         // Make particles bounce on Z plan of object
integer iInterpColor = TRUE;     // Go from start to end color
integer iInterpSize = TRUE;      // Go from start to end size
integer iWind = FALSE;           // Particles effected by wind
integer iFollowSource = FALSE;   // Particles follow the source
integer iFollowVel = TRUE;       // Particles turn to velocity direction

// Choose a pattern from the following:
// PSYS_SRC_PATTERN_EXPLODE
// PSYS_SRC_PATTERN_DROP
// PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY
// PSYS_SRC_PATTERN_ANGLE_CONE
// PSYS_SRC_PATTERN_ANGLE
integer iPattern = PSYS_SRC_PATTERN_EXPLODE;

// Select a target for particles to go towards
// "" for no target, "owner" will follow object owner 
//    and "self" will target this object
//    or put the key of an object for particles to go to
key kTarget = "";  

////////// BEGIN PARTICLE PARAMS /////////////
float fAge = 1.5;                     // Life of each particle
float fAgeRnd = 0.5;                  // Random value applied to life.  
float fMaxSpeed = 0.10;              // Max speed each particle is spit out at
float fMaxSpeedRnd = 0.05;          // Random value for max speed 
float fMinSpeed = 0.05;             // Min speed each particle is spit out at
float fMinSpeedRnd = 0.05;          // Random value for min speed
float fStartAlpha = 0.28;              // Start alpha (transparency) value
float fStartAlphaRnd = 0.10;         // Rnd starting alpha value.  
float fEndAlpha = 0.0;              // End alpha (transparency) value
float fEndAlphaRnd = 0.00;          // End alpha value rand.    
// float fGravity = 0;             // Gravity, added to push to simulate gravity. 

vector vStartColor = <1,1,1>;       // Start color of particles <R,G,B>
float fStartColorRnd = 0;           // Start color random 
vector vEndColor = <0.8,0.4,0.4>;   // End color of particles <R,G,B> (if interpColor == TRUE)
float fEndColorRnd = 0;                // End color random 
vector vStartSize = <0.1,0.1,0.1>;  // Start size of particles 
float fStartSizeRnd = 0.1;            // Start size random 
vector vEndSize = <0.0,0.0,0.0>;          // End size of particles (if interpSize == TRUE)
float fEndSizeRnd = 0.2;              // End Size random. 
vector vPush = <0,0,4>;             // Force pushed on particles
// vector vWind = <0,0,0>;             // Force added to push (for simpler editing) 

integer iUseRndTexture = 0;        // Bool, if == 1, uses random textures in rand func. 

string sTexture = "fire_1";               // Texture used if iUseRndTexture == 0 

//////////// END PARTICLE PARAMS //////////////////


// System paramaters
float fRate = 0.051;             // How fast (rate) to emit particles
float fRateRnd = 0.00;           // Random value for rate 
float fRadius = 0.01;             // Radius to emit particles for BURST pattern
float fRadiusRnd = 0.01;            // Radius random 
float fInnerAngle = 0.0;         // Inner angle for all ANGLE patterns
float fInnerAngleRnd = 0.0;        // Inner Angle random. 
float fOuterAngle = .1;         // Outer angle for all ANGLE patterns
float fOuterAngleRnd = 0.0;        // Outer angle rand 
float fLife = 0;                 // Life in seconds for the system to make particles
float fLifeRnd = 0;              // Random life rates (yes there is a random for fuckn everything)

integer iCount = 10;              // How many particles to emit per BURST 
float fCountRnd = 5;             // Random count (rounded) 

vector vOmega = <0,0,0.0>;       // Rotation of ANGLE patterns around the source
float fOmegaRnd = 3;             // Random number applied to the omega. 


// Script variables
integer flags;

///// Randomize values function ///////// 
random()
{
    fAge += llFrand(fAgeRnd);
    
    fMaxSpeed += llFrand(fMaxSpeedRnd); 
    fMinSpeed += llFrand(fMinSpeedRnd); 
    
    fStartAlpha += llFrand(fStartAlphaRnd); 
    fEndAlpha += llFrand(fEndAlphaRnd); 
    
    vStartColor.x += llFrand(fStartColorRnd); 
    vStartColor.y += llFrand(fStartColorRnd); 
    vStartColor.z += llFrand(fStartColorRnd); 
    
    vEndColor.x += llFrand(fEndColorRnd); 
    vEndColor.y += llFrand(fEndColorRnd);
    vEndColor.z += llFrand(fEndColorRnd);
    
    float o = llFrand(fStartSizeRnd);
    vStartSize.x += o;
    vStartSize.y += o;
    vStartSize.z += o;
    
    float i = llFrand(fEndSizeRnd);
    vEndSize.x += i;
    vEndSize.y += i;
    vEndSize.z += i;
    
    fRate += llFrand(fRateRnd); 
    fRadius += llFrand(fRadiusRnd); 
    fInnerAngle += llFrand(fInnerAngle);
    fOuterAngle += llFrand(fOuterAngle);  
    fLife += llFrand(fLifeRnd); 
    iCount += (integer)llFrand(fCountRnd); 
    
    vOmega.x += llFrand(fOmegaRnd); 
    vOmega.y += llFrand(fOmegaRnd); 
    vOmega.z += llFrand(fOmegaRnd); 
     
    
    
    /////// RANDOMIZE TEXTURE //////////////// 
    if(iUseRndTexture == 1)
    {
        integer texCount = 2; // number of textures to use. Add to list if more than 2 
        texCount -= 1; 
        integer randnum = llRound(llFrand(texCount));
        
        if(randnum == 0)
        {
            sTexture = "52cf0676-f6f6-0eec-8860-0d545d624be9";
        }
        if(randnum == 1)
        {
            sTexture = "6402e6c4-0084-d11d-b2f8-e716a80cae0b"; 
        }
    
    }
    ///////// END RANDOM TEXTURE /////////////
}    

updateParticles()
{
    //randomize certain values on each pass
    random();
    vector scalevec = llGetScale();
    float foox = scalevec.x; 
    float fooy = scalevec.y;
    float fooz = scalevec.z; 
    ////// Do not modify below this line //////
    flags = 0;
    if (kTarget == "owner") kTarget = llGetOwner();
    if (kTarget == "self") kTarget = llGetKey();
    if (iGlow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (iBounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (iInterpColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (iInterpSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (iWind) flags = flags | PSYS_PART_WIND_MASK;
    if (iFollowSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (iFollowVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (kTarget != "") flags = flags | PSYS_PART_TARGET_POS_MASK;

    llParticleSystem([  PSYS_PART_MAX_AGE,fAge ,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR,vStartColor,
                        PSYS_PART_END_COLOR,vEndColor,
                        PSYS_PART_START_SCALE,vStartSize + <foox, foox, foox>,
                        PSYS_PART_END_SCALE,vEndSize + <foox, foox, foox>, 
                        PSYS_SRC_PATTERN,iPattern,
                        PSYS_SRC_BURST_RATE,fRate,
                        PSYS_SRC_ACCEL,vPush * fooz,
                        PSYS_SRC_BURST_PART_COUNT,(integer)fooy + iCount,
                        PSYS_SRC_BURST_RADIUS,fRadius + foox/2,
                        PSYS_SRC_BURST_SPEED_MIN,fMinSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,fMaxSpeed,
                        PSYS_SRC_TARGET_KEY,kTarget,
                        PSYS_SRC_INNERANGLE,fInnerAngle, 
                        PSYS_SRC_OUTERANGLE,fOuterAngle,
                        PSYS_SRC_OMEGA, vOmega,
                        PSYS_SRC_MAX_AGE, fLife,
                        PSYS_SRC_TEXTURE, sTexture,
                        PSYS_PART_START_ALPHA, fStartAlpha,
                        PSYS_PART_END_ALPHA, fEndAlpha
                            ]);
}

default
{
    state_entry()
    {
        llSetTimerEvent(0.15); 
        //updateParticles();
        
    }
    
    timer()
    {
        updateParticles();
        llResetScript();
    }
    
}