// written by Twisted Laws, 16 Aug 2008, just for the fun of it

// particle fountain controller that expects to have 17 "jets"
// that shoot particles on demand.  Link order is important and
// this expects prim 2 is center jet and prims 3 thru 19 are jets
// arranged in a circle around it

// how long between shows
float interval = 20.0;
// following is key of particle textures, change as desired
key mastertexture =  "dc12d3fb-f014-4ee2-afe8-a297f709780d"; // fountain_test3
// following lists aren't used, useful place for storing texture keys tho
// fountain_test textures made by Wisdom Streeter
list textures = [
    "d693f360-ad36-4284-85a1-ed157f27b776", // water
    "98e3ef3c-04d1-2f71-4256-5cbf95091d3c", // fountain_test1
    "bdcee459-5cb8-2c9f-b65c-0fd47cc18494", // fountain_test2
    "dc12d3fb-f014-4ee2-afe8-a297f709780d", // fountain_test3
    "f40f3be2-6055-a7e1-2c55-4fb5a7240335" // flames
];
list texturenames = ["test1","test2","test3","flames"];
// this is changed in the program as needed
vector color = <1,1,1>;
// this list of colors is used in a couple shows
list colors = [ <1,1,1>, <1,0.75,0.75>,<0.75,1,0.75>,<0.75,0.75,1>,<1,1,0.75>,<1,0.75,1>,<0.75,1,1> ];
// this is used in show3 to control alternating jets
list show3List = [2,-1,3,11,4,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19];
// show counter
integer showcounter = 0;
// how close an avatar must be, before this is active
float howclose = 15.0;

// format the link message and send it
doJet(integer which,float sage,float page,float power,vector tcolor,key textur,float delay)
{
    llMessageLinked(which,0,"shoot|" + (string)sage + "|" + (string)page +
        "|" + (string)power + "|" + (string)tcolor,textur);
    if(which != -1)
        llTriggerSound("4fc86565-5f40-4cc7-8d97-ea2568c92f27",0.8);
    else
        llTriggerSound("8c9e81a7-1820-42db-a776-f2442851c763",0.4);
    if(delay>0.0)
        llSleep(delay);
}

// following are 9 "shows" that are called by doShow based on showcounter
show1()
{
    key texture = mastertexture;
    vector save_color = color;
    integer i;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<16;i++)
    {
        color = llList2Vector(colors,i % 7);
        doJet(i+3,1.0,2.0,6.0,color,texture,0.0);
        doJet(19-i,1.0,2.0,6.0,color,texture,0.5);
    }
    color = save_color;
    doJet(2,1.0,2.0,10.0,color,texture,2.0);
    doJet(-1,1.0,2.0,10.0,color,texture,2.0);
    doJet(2,1.0,2.0,10.0,color,texture,3.0);
    doJet(-1,1.0,2.0,10.0,color,texture,2.0);
}
show2()
{
    integer i;
    key texture = mastertexture;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<16;i++)
    {
        doJet(i+3,1.0,2.0,6.0,color,texture,0.0);
        doJet(19-i,1.0,2.0,6.0,color,texture,0.5);
    }
    doJet(2,1.0,2.0,8.0,color,texture,2.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
    doJet(2,1.0,2.0,8.0,color,texture,2.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
}
show3()
{
    key texture = mastertexture;
    list temp = show3List;
    integer i;
    integer m = llGetListLength(temp);
    doJet(-1,1.0,2.0,1.0,color,texture,2.0);
    doJet(2,1.0,2.0,5.0,color,texture,2.0);
    doJet(-1,1.0,2.0,1.0,color,texture,2.0);
    for(i=0;i<m;i++)
    {
        doJet(llList2Integer(temp,i),1.0,2.0,6.0,color,texture,1.0);
    }
    doJet(-1,1.0,3.0,8.0,color,texture,2.0);
    for(i=0;i<8;i++)
    {
        doJet(llList2Integer(temp,llRound(llFrand(m))),1.0,2.0,6.0,color,texture,1.0);
    }
    doJet(-1,1.0,3.0,8.0,color,texture,2.0);
    for(i=(m-1);i>=0;i--)
    {
        doJet(llList2Integer(temp,i),1.0,2.0,6.0,color,texture,1.0);
    }
    llSleep(3.0);
}
show4()
{
    key texture = mastertexture;
    doJet(2,2.0,2.0,10.0,color,texture,3.0);
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    doJet(-1,1.0,2.0,2.0,color,texture,3.0);
    doJet(-1,1.0,2.0,3.0,color,texture,3.0);
    doJet(-1,1.0,2.0,4.0,color,texture,3.0);
    doJet(-1,1.0,2.0,5.0,color,texture,3.0);
    doJet(-1,1.0,2.0,4.0,color,texture,3.0);
    doJet(-1,1.0,2.0,3.0,color,texture,3.0);
    doJet(-1,1.0,2.0,2.0,color,texture,3.0);
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    doJet(2,2.0,2.0,10.0,color,texture,3.0);
}
show5()
{
    key texture = mastertexture;
    doJet(2,2.0,2.0,10.0,color,texture,3.0);
    doJet(-1,1.0,2.0,1.0,color,texture,2.0);
    doJet(2,1.0,2.0,6.0,color,texture,2.0);
    doJet(-1,1.0,2.0,2.0,color,texture,2.0);
    doJet(2,1.0,2.0,5.0,color,texture,2.0);
    doJet(-1,1.0,2.0,3.0,color,texture,2.0);
    doJet(2,1.0,2.0,5.0,color,texture,2.0);
    doJet(-1,1.0,2.0,2.0,color,texture,2.0);
    doJet(2,1.0,2.0,6.0,color,texture,2.0);
    doJet(-1,1.0,2.0,1.0,color,texture,2.0);
    doJet(2,2.0,2.0,5.0,color,texture,2.0);
    doJet(-1,1.0,2.0,5.0,color,texture,3.0);
}
show6()
{
    key texture = mastertexture;
    integer i;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<32;i++)
    {
        doJet(19-(i % 16),1.0,2.0,6.0,color,texture,0.5);
    }
    doJet(2,1.0,2.0,7.0,color,texture,2.0);
    doJet(-1,1.0,2.0,7.0,color,texture,2.0);
    doJet(2,1.0,2.0,7.0,color,texture,2.0);
    doJet(-1,1.0,2.0,7.0,color,texture,2.0);
}
show7()
{
    key texture = mastertexture;
    vector save_color = color;
    integer i;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<32;i++)
    {
        color = llList2Vector(colors,i % 7);
        doJet(3+(i % 16),1.0,2.0,5.0,color,texture,0.0);
        doJet((8+i) % 16 + 3,1.0,2.0,5.0,color,texture,0.5);
    }
    color = save_color;
    doJet(2,1.0,2.0,7.0,color,texture,2.0);
    doJet(-1,1.0,2.0,7.0,color,texture,2.0);
    doJet(2,1.0,2.0,7.0,color,texture,3.0);
    doJet(-1,1.0,2.0,7.0,color,texture,2.0);
}
show8()
{
    integer i;
    key texture = mastertexture;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<32;i++)
    {
        doJet(19-(i % 16),1.0,2.0,6.0,color,texture,0.5);
    }
    doJet(2,1.0,2.0,8.0,color,texture,2.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
    doJet(2,1.0,2.0,8.0,color,texture,3.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
}
show9()
{
    integer i;
    key texture = mastertexture;
    doJet(-1,1.0,2.0,1.0,color,texture,3.0);
    for(i=0;i<32;i++)
    {
        doJet(3+(i % 16),1.0,2.0,5.0,color,texture,0.0);
        doJet((8+i) % 16 + 3,1.0,2.0,5.0,color,texture,0.5);
    }
    doJet(2,1.0,2.0,8.0,color,texture,2.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
    doJet(2,1.0,2.0,8.0,color,texture,3.0);
    doJet(-1,1.0,2.0,8.0,color,texture,2.0);
}

doShow()
{
    // stop the timer while a show is going as they
    // are different lengths
    llSetTimerEvent(0.0);
    // play water bubbling
    llLoopSound("12ff67b9-6a97-4408-b9aa-8f0e509a8837",0.5);
    // colors are set randomly
    integer which = llRound(llFrand(5.0));
    if(which==2)
        color=<1,0.75,0.75>;
    else
    if(which==3)
        color=<0.75,1,0.75>;
    else
    if(which==4)
        color=<0.75,0.75,1.0>;
    else
        color = <1,1,1>;
    // turn on light and full bright on water prim    
    llSetPrimitiveParams([PRIM_FULLBRIGHT,0,TRUE,PRIM_COLOR,3,color,1.0,
        PRIM_POINT_LIGHT, TRUE, color, 1.0, 5.0, 0.75]);
    // run the right show
    if(showcounter == 0)
        show1();
    else if(showcounter == 1)
        show2();
    else if(showcounter == 2)
        show3();
    else if(showcounter == 3)
        show4();
    else if(showcounter == 4)
        show5();
    else if(showcounter == 5)
        show6();
    else if(showcounter == 6)
        show7();
    else if(showcounter == 7)
        show8();
    else
        show9();
    if(++showcounter > 8)
        showcounter = 0;
    // turn off all particles so that people seeing it for
    // first time don't get extra particles
    llMessageLinked(-1,0,"reset",NULL_KEY);
    // turn off light and full bright on water prim
    llSetPrimitiveParams([PRIM_POINT_LIGHT, FALSE, <1, 1, 1>, 1.0, 5.0, 0.75,
        PRIM_FULLBRIGHT, 0, FALSE,PRIM_COLOR,3,<0.7,0.7,0.7>,1.0]);
    // lower volume on water bubbling
    llLoopSound("12ff67b9-6a97-4408-b9aa-8f0e509a8837",0.2);
    // start the center jet
    doJet(2,interval,2.0,3.0,<1,1,1>,mastertexture,0.0);
    // delay until next show
    llSetTimerEvent(interval);
}

integer someonearound = FALSE;

default
{
    state_entry()
    {
        // shut off all particles
        llMessageLinked(-1,0,"reset",NULL_KEY);
        // set water to texture
        llSetTexture("b7355e0c-1fcb-4798-b137-ff58ce88d549",3);
        // animate the water
        llSetTextureAnim (ANIM_ON | LOOP | PING_PONG,3,8,8,0,0,10.0);
        // turn off lights
        llSetPrimitiveParams([PRIM_POINT_LIGHT, FALSE, <1, 1, 1>, 1.0, 5.0, 0.75,
            PRIM_FULLBRIGHT, 0, FALSE,PRIM_COLOR,3,<0.7,0.7,0.7>,1.0]);
        // start first show in 3 seconds after rezzing
        llSetTimerEvent(3.0);
        llSensorRepeat("","",AGENT,howclose,PI,5);
    }
    on_rez(integer sp)
    {
        llResetScript();
    }
    no_sensor()
    {
        someonearound = FALSE;
    }
    sensor(integer n)
    {
        someonearound = TRUE;
    }
    touch_start(integer total_number)
    {
        // if someone clicks this while idle, start a show
        doShow();
    }
    timer()
    {
        // start timed show
        if(someonearound)
            doShow();
    }
}
