// LightPoleTouch.lsl

// 28 august 2007
// Author: Hans541 Tomsen

// PRODUCED BY:
// (c) 2007 Logic
// Logic Scripted Products and Script Services
// Owner: Flennan Roffo

// VERSION:
// Version: 1.0

// LICENCE:
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// (Also available at http://www.gnu.org/copyleft/gpl.html) 

// DESCRIPTION:
// Sets the light of a light pole ON or OFF. 
// Touching the light pole will toggle between ON and OFF.
// Takes into account the SunDirection and will go ON at night and OFF when day.
// Additionally you can tweak the values for SunFullValue and SunDarkValue (the Z coordinate of Sun direction)
// to create a DIM period, during which the light pole is less bright/dimmed.
// LightColor and LightIntensity are changeable values. 

// INSTALLION:
// Place this script in the ROOT prim of the linkset.
// (in case there is only one prim, place both scripts in the same prim).
// Note: if the light emitting prim and the prim in which the touch script is put are not in the
// same linkset, this will not work.

/////////////////////////// NON EDITABLE VALES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

integer LM_TOUCH    = 193356;

//////////////////////////// default ///////////////////////////////////////

default
{
    touch_start(integer total_number)
    {
        llMessageLinked(LINK_SET, LM_TOUCH, "", NULL_KEY);
    }
}

// End LightPoleTouch.lsl