// 14 Jan 2014

/////////////////
// user variables

string debugStr;
key owner;
integer animPerm;
string playingAnim;
string currentAnim="";

integer listenHandle;


debug()
{
        //llOwnerSay(debugStr);
        debugStr="";
}

checkAnim()
{
    if(animPerm)
    { 

        if(currentAnim!=playingAnim)
        {
            llStopAnimation(playingAnim);
            playingAnim = currentAnim;
            llStartAnimation(playingAnim);
            if(llGetInventoryKey(playingAnim)==NULL_KEY)
            {
                debugStr+="Missing "+playingAnim+",";
            }
        }
    }
    else
    {
        debugStr+="noAnimPerm,";
    }
}

reset()
{
    animPerm=FALSE;
    playingAnim="";
    currentAnim="";
    owner = llGetOwner();
    llRequestPermissions(owner, PERMISSION_TRIGGER_ANIMATION);
}

default {
    
    attach(key id)
    {
        if(id)
        {
            reset();
        }
        else
        {
            animPerm=FALSE;
        }
    }
    
    changed( integer change )
    {

        if(change & CHANGED_OWNER) {
            llResetScript();
        }
        
        if(change & CHANGED_INVENTORY) {
            llResetScript();
        }
        
        currentAnim = llGetAnimation(owner);
        checkAnim(); 
        
        debug();
    }
      
    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TRIGGER_ANIMATION) {
            animPerm=TRUE;
        }
    }
    
    state_entry()
    {
    }

}

