float age = 8.0;                // How long each particle will survive
float rate = .2;              // How many seconds between particle emissions
float radius = .05;             // Starting radius for Particles to appear within
integer count = 20;             // How many particles per emission (Per Rate)
integer followVel = TRUE;                           // Particles turn to velocity direction
integer glow = TRUE;                                // Makes the particles glow
float startAlpha = .4;         // Start alpha (transparency) value
float endAlpha = .1;             // End alpha (transparency) value
                                // Alpha is between 0.0 and 1.0

vector startColor = <0.7,0.7,0.5>;  // Starting color of particles <R,G,B>
vector endColor = <0.7,0.7,0.7>;     // End color of particles <R,G,B>
                                // <0,0,0> = Black <1,1,1> = White
vector push = <0,0,0.01>;                        // Force pushed on particles

// No Need to edit after this Line
//---------------------------------


MakeParticles()
     {                
         llParticleSystem(
         [
              PSYS_PART_FLAGS,0
             |PSYS_PART_WIND_MASK 
             |PSYS_PART_INTERP_COLOR_MASK 
             |PSYS_PART_INTERP_SCALE_MASK 
             |PSYS_PART_FOLLOW_SRC_MASK 
             |PSYS_PART_FOLLOW_VELOCITY_MASK
             ,PSYS_SRC_PATTERN
             ,PSYS_SRC_PATTERN_ANGLE_CONE
             ,PSYS_SRC_TEXTURE,"SMOKE & STEAM"
             ,PSYS_PART_MAX_AGE, age
             ,PSYS_SRC_BURST_RATE,rate
             ,PSYS_SRC_BURST_PART_COUNT,count
             ,PSYS_SRC_BURST_RADIUS,radius
             ,PSYS_SRC_BURST_SPEED_MIN,0.5
             ,PSYS_SRC_BURST_SPEED_MAX,1.0
             ,PSYS_SRC_ACCEL,<0.0,0.0,0.2>
             ,PSYS_PART_START_COLOR,startColor
             ,PSYS_PART_END_COLOR,endColor
             ,PSYS_PART_START_ALPHA,startAlpha
             ,PSYS_PART_END_ALPHA,endAlpha
             ,PSYS_PART_START_SCALE,<2,2,2>
             ,PSYS_PART_END_SCALE,<5,5,5>
             ,PSYS_SRC_ANGLE_BEGIN,0.1
             ,PSYS_SRC_ANGLE_END,0.65
             ,PSYS_SRC_OMEGA,<0.0,0.0,0.0>
         ]);
     }
     default
     {
         state_entry() 
         {
           
             llParticleSystem([]);
             llSetTimerEvent(5);
         }
         on_rez(integer num)
         {
             llResetScript();
         }
         timer()
         {
             MakeParticles();
             
         }
     }