// Handy's door control 1.4b (export)

string SEPARATOR = "/" ;
string ID_STRING = "HDO" ;            

float ScriptVersion ;
string NOTECARD_README    = "Handy's doors READ ME" ;
string SCRIPT_SETUP        = "Handy's doors setup" ;
string SCRIPT_CONTROL     = "Handy's doors control (e)" ;



integer SetupExists ;
integer MenuChannel ;
list PluginMenus ;
key TouchUser ;
integer MouseDown = FALSE ;
integer TouchPrim ;
key OwnerID ;

integer ADoorLinkNum ;        

list OpenStates = [] ;        
integer Locked = FALSE ;

integer SoundNumber ;                
integer SoundVolume ;            
float FSoundVolume ;            
string SoundOpen ;
string SoundClose ;
float SOUND_DEMO_TIME = 2.2 ;            

integer AllAtOnce = FALSE ;

list Dorfs ;        
integer    DORFS_ID            = 0 ;    
integer    DORFS_DORF            = 1 ;    
integer    DORFS_LINKNUM        = 2 ;    
integer    DORFS_CLOSED_POS    = 3 ;    
integer    DORFS_CLOSED_ROT    = 4 ;    
integer    DORFS_OPEN_POS        = 5 ;    
integer    DORFS_OPEN_ROT        = 6 ;    
integer    DORFS_STRIDE        = 7 ;
integer DorfsCount ;

integer NumberOfPrims ;

float OriginalSize;

integer Booting = FALSE ;

list CRA_25     = [ "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "<", ">", ",", "-", "a", "b", "c", "d", "e", "f" ] ;        
list CRA_31    = [ "<", ",", "e", "-", "8", "b", "a", "d", "c", "9", "f", ">", "5", "*", "6", "7", "0", "2", "1", "3", "4" ] ;        

integer LM_HLDO_OPEN_ALL     = -8022500 ;
integer LM_HLDO_CLOSE_ALL    = -8022501 ;
integer LM_HLDO_READ_DATA     = -8022502 ;
integer LM_HLDO_OPEN_ONE    = -8022503 ;
integer LM_HLDO_CLOSE_ONE    = -8022504 ;
integer LM_HLDO_SOUNDS_DEMO    = -8022505 ;
integer LM_HLDO_SET_OPEN_STATE = -8022506 ;


integer PLUGIN_DOOR_SEND_OPEN_ALL        = 715001 ;
integer PLUGIN_DOOR_SEND_CLOSE_ALL        = 715002 ;
integer PLUGIN_DOOR_SEND_OPEN_ONE        = 715003 ;
integer PLUGIN_DOOR_SEND_CLOSE_ONE        = 715004 ;
integer PLUGIN_DOOR_RECV_OPEN            = 715005 ;
integer PLUGIN_DOOR_RECV_CLOSE            = 715006 ;
integer PLUGIN_DOOR_RECV_TRYING_OPEN    = 715007 ;
integer PLUGIN_DOOR_RECV_TRYING_CLOSE    = 715008 ;
integer PLUGIN_DOOR_SEND_LOCK            = 715010 ;
integer PLUGIN_DOOR_SEND_UNLOCK            = 715011 ;
integer PLUGIN_DOOR_SEND_TRY_OPEN_ALL    = 715014 ;
integer PLUGIN_DOOR_SEND_TRY_CLOSE_ALL    = 715015 ;
integer PLUGIN_DOOR_SEND_LIST_DOORS        = 715020 ;
integer PLUGIN_DOOR_RECV_LIST_DOORS        = 715021 ;
integer PLUGIN_DOOR_SEND_MENU_BUTTON    = 715100 ;
integer PLUGIN_DOOR_RECV_MENU_BUTTON    = 715101 ;
integer PLUGIN_DOOR_SEND_MENU_FINISH    = 715102 ;
integer PLUGIN_DOOR_BOOTING                = 715200 ;
integer PLUGIN_DOOR_BOOTED                = 715201 ;
integer PLUGIN_DOOR_SOUND                = 715220 ;

integer EXTERNAL_CHAT = 166214 ;

ReadData()
{
    Dorfs = [] ;
    DorfsCount = 0 ;
    
    integer LinkNum ;
    for (LinkNum = 1 ; LinkNum <= NumberOfPrims ; LinkNum++)
    {
        list PrimDescData = GetDescData(LinkNum) ;
        string PrimType = llList2String(PrimDescData, 0) ;
        if (PrimType == "D")
        {
            Dorfs += [
                (integer)llList2String(PrimDescData, 1),                
                "D",
                LinkNum,
                (vector)llList2String(PrimDescData, 2),                    
                llEuler2Rot((vector)llList2String(PrimDescData, 3)),    
                (vector)llList2String(PrimDescData, 4),                    
                llEuler2Rot((vector)llList2String(PrimDescData, 5))        
                    ] ;
            SoundNumber = (integer)llList2String(PrimDescData, 6) ;            
            SoundVolume = (integer)llList2String(PrimDescData, 7) ;        
            AllAtOnce = (integer)llList2String(PrimDescData, 8) ;        
            ADoorLinkNum = LinkNum ;
            DorfsCount += DORFS_STRIDE ;
        }
    }
    
    for (LinkNum = 1 ; LinkNum <= NumberOfPrims ; LinkNum++)
    {
        list PrimDescData = GetDescData(LinkNum) ;
        string PrimType = llList2String(PrimDescData, 0) ;
        if (PrimType == "F")
        {
            integer FurnID = (integer)llList2String(PrimDescData, 1) ;        
            
            vector DoorClosedPos ;
            rotation DoorClosedRot ;
            vector DoorOpenPos ;
            rotation DoorOpenRot ;
            integer D ;
            for (D = 0 ; D < DorfsCount ; D += DORFS_STRIDE)
            {
                integer DoorID = llList2Integer(Dorfs, D + DORFS_ID) ;
                if (DoorID == FurnID)
                {
                    DoorClosedPos = llList2Vector(Dorfs, D + DORFS_CLOSED_POS) ;
                    DoorClosedRot = llList2Rot(Dorfs, D + DORFS_CLOSED_ROT) ;
                    DoorOpenPos = llList2Vector(Dorfs, D + DORFS_OPEN_POS) ;
                    DoorOpenRot = llList2Rot(Dorfs, D + DORFS_OPEN_ROT) ;
                    
                }
            }
            
            vector FurnRelPos = (vector)llList2String(PrimDescData, 2) ;
            rotation FurnRelRot = llEuler2Rot((vector)llList2String(PrimDescData, 3)) ;
            
            
            vector FurnClosedPos = FurnRelPos * DoorClosedRot + DoorClosedPos ;
            rotation FunClosedRot = FurnRelRot * DoorClosedRot ;
            vector FurnOpenPos = FurnRelPos * DoorOpenRot + DoorOpenPos ;
            rotation FunOpenRot = FurnRelRot * DoorOpenRot ;
            Dorfs += [
                FurnID,
                "F",
                LinkNum,
                FurnClosedPos,
                FunClosedRot,
                FurnOpenPos,
                FunOpenRot
                    ] ;
        }
    }
    Dorfs = llListSort(Dorfs, DORFS_STRIDE, TRUE) ;
    DorfsCount = llGetListLength(Dorfs) ;        

}

list GetDescData(integer LinkNum)
{
    key PrimID = llGetLinkKey(LinkNum) ;
    string PrimDesc = llList2String(llGetObjectDetails(PrimID, [ OBJECT_DESC ]), 0) ;
    list Params = llParseStringKeepNulls(PrimDesc, [ SEPARATOR ], []) ;
    if (llList2String(Params, 0) == ID_STRING)
    {
        string Str = Decode(llList2String(Params, 1)) ;
        Params = llParseStringKeepNulls(Str, [ SEPARATOR ], []) ;
        return(Params) ;
    }
    else return([ " " ]) ;
}
SoundsDemo(string Data)
{
    list L = llCSV2List(Data) ;
    SoundNumber = (integer)llList2String(L, 0) ;            
    SoundVolume = (integer)llList2String(L, 1) ;        
    SetSounds() ;
    MoveDorfs(-1, TRUE) ;
    llSleep(SOUND_DEMO_TIME) ;
    MoveDorfs(-1, FALSE) ;
}
float GetSize() {
    vector ThisPrimSize = llGetScale();
    return ThisPrimSize.x;
}












integer Contains(string Name, string Desc, string Check)
{
    return(llSubStringIndex(Name, Check) > -1 || llSubStringIndex(Desc, Check) > -1) ;
}
list ExtractVersionNumber(string ScriptName)
{
    integer I ;
    integer L = llStringLength(ScriptName) ;
    for (I = L - 1 ; llGetSubString(ScriptName, I, I) != "v" && I > 0 ; I--) {}
    return [ llGetSubString(ScriptName, 0, I - 1), (float)llGetSubString(ScriptName, I + 1, -1) ] ;
}
integer ScriptCount(string RootName)        
{
    integer Count = 0 ;
    integer N = llGetInventoryNumber(INVENTORY_SCRIPT) ;
    integer S ;
    for (S = 0 ; S < N ; S++)
    {
        string Name = llGetInventoryName(INVENTORY_SCRIPT, S) ;
        if (llGetSubString(Name, 0, llStringLength(RootName) -1) == RootName)    Count++ ;
    }
    return(Count) ;
}
string Encode(string Clear)
{
    integer L = llStringLength(Clear) ;
    integer P ;
    string C ;
    string S = "" ;
    for (P = 0 ; P < L ; P++)
    {
        C = llGetSubString(Clear, P, P) ;
        integer Pos = llListFindList(CRA_25, [ C ]) ;
        if (Pos > -1) C = llList2String(CRA_31, Pos) ;
        S += C ;
    }
    return(S) ;
}
string Decode(string Encrypted)
{
    integer L = llStringLength(Encrypted) ;
    integer P ;
    string C ;
    string S = "" ;
    for (P = 0 ; P < L ; P++)
    {
        C = llGetSubString(Encrypted, P, P) ;
        integer Pos = llListFindList(CRA_31, [ C ]) ;
        if (Pos > -1) C = llList2String(CRA_25, Pos) ;
        S += C ;
    }
    return(S) ;
}
integer LinkNum2DorfID(integer LinkNum)
{
    integer Ptr = 0 ;
    integer ID = -1 ;
    do
    {
        if (llList2Integer(Dorfs, Ptr + DORFS_LINKNUM) == LinkNum)
            ID = llList2Integer(Dorfs, Ptr + DORFS_ID) ;
        Ptr += DORFS_STRIDE ;
    } while(ID == -1 && Ptr < DorfsCount) ;        
    return(ID) ;
}

MoveDorfs(integer ID, integer Open)
{
    float NewSize = GetSize();
    if ((NewSize - OriginalSize) > 0.0001 && !SetupExists)         
        ReSize(NewSize);
    list Params = [] ;
    if (ID == -1) OpenStates = [] ;        
    integer Ptr ;
    for (Ptr = 0 ; Ptr < DorfsCount ; Ptr += DORFS_STRIDE)
    {
        integer ThisID = llList2Integer(Dorfs, Ptr + DORFS_ID) ;
        if (ID == -1 ||  ThisID == ID)        
        {
            integer LinkNum = llList2Integer(Dorfs, Ptr + DORFS_LINKNUM) ;
            string DorfDorf = llList2String(Dorfs, Ptr + DORFS_DORF) ;
            if (DorfDorf == "D") SetOpenState(ThisID, Open) ;
            if (Open)
            {
                Params += [ PRIM_LINK_TARGET, LinkNum,
                    PRIM_POS_LOCAL, llList2Vector(Dorfs, Ptr + DORFS_OPEN_POS),
                    PRIM_ROT_LOCAL, llList2Rot(Dorfs, Ptr + DORFS_OPEN_ROT)
                        ] ;
            }
            else
            {
                Params += [ PRIM_LINK_TARGET, LinkNum,
                    PRIM_POS_LOCAL, llList2Vector(Dorfs, Ptr + DORFS_CLOSED_POS),
                    PRIM_ROT_LOCAL, llList2Rot(Dorfs, Ptr + DORFS_CLOSED_ROT)
                        ] ;
            }
        }
    }
    if (Open && SoundOpen != "")    llPlaySound(SoundOpen, FSoundVolume) ;
    else if (SoundClose != "")        llPlaySound(SoundClose, FSoundVolume) ;
    llSetLinkPrimitiveParamsFast(-1, Params) ;
    string Str = "" ;
    if (ID > -1) Str = (string)ID ;
    if (Open)
    {
        llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_OPEN, Str, TouchUser) ;
        llRegionSay(EXTERNAL_CHAT, "open") ;
    }
    else
    {
        llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_CLOSE, Str, TouchUser) ;
        llRegionSay(EXTERNAL_CHAT, "close") ;
    }
}
integer IsOpen(integer ID)
{
    if (ID == -1)    
    {
        
        integer RetVal = FALSE ;
        integer Len = llGetListLength(OpenStates) ;
        integer P ;
        for (P = 0 ; P < Len ; P += 2)
            if (llList2Integer(OpenStates, P + 1)) RetVal = TRUE ;
        return(RetVal) ;
    }
    else
    {
        integer Ptr = llListFindList(OpenStates, [ "D" + (string)ID ]) ;
        return(llList2Integer(OpenStates, Ptr + 1)) ;
    }
}

SetOpenState(integer ID, integer Open)
{
    integer P = llListFindList(OpenStates, [ "D" + (string)ID ]) ;
    if (P == -1)
        OpenStates += [ "D" + (string)ID, Open ] ;
    else
        OpenStates = llListReplaceList(OpenStates, [ Open ], P + 1, P + 1) ;
}
ReSize(float sizeNew) {
    float SizeFactor = sizeNew / OriginalSize;
    llOwnerSay("Size changed - recalculating, please wait ...");
    integer LinkNum ;
    for (LinkNum = 1 ; LinkNum <= NumberOfPrims ; LinkNum++)
    {
        key PrimID = llGetLinkKey(LinkNum) ;
        string PrimDesc = llList2String(llGetObjectDetails(PrimID, [ OBJECT_DESC ]), 0) ;
        list Params = llParseStringKeepNulls(PrimDesc, [ SEPARATOR ], []) ;
        if (llList2String(Params, 0) == ID_STRING)
        {
            string PrimData = Decode(llList2String(Params, 1)) ;
            list PrimDescData = llParseStringKeepNulls(PrimData, [ SEPARATOR ], []) ;
            string PrimType = llList2String(PrimDescData, 0) ;
            if (PrimType == "D") {
                PrimDescData = ResizeVector(PrimDescData, 2, SizeFactor);
                PrimDescData = ResizeVector(PrimDescData, 4, SizeFactor);
            } else if (PrimType == "F") {
                    PrimDescData = ResizeVector(PrimDescData, 2, SizeFactor);
            }
            PrimData = llDumpList2String(PrimDescData, SEPARATOR);
            llSetLinkPrimitiveParamsFast(LinkNum, [ PRIM_DESC, ID_STRING + SEPARATOR + Encode(PrimData) ]) ;
        }
    }
    OriginalSize = sizeNew;
    ReadData();
    llOwnerSay("Size recalculation done.");
}
list ResizeVector(list PData, integer index, float SizeFactor) {
    vector PosV = (vector)llList2String(PData, index) * SizeFactor ;
    return llListReplaceList(PData, [ PosV ], index, index);
}
SetSounds()
{
    FSoundVolume = (float)(SoundVolume + 1) / 10.0 ;
    SoundOpen = SoundClose = "" ;
    integer L  = llGetInventoryNumber(INVENTORY_SOUND) ;
    integer I ;
    for (I = 0 ; I < L ; I++)
    {
        string Name = llGetInventoryName(INVENTORY_SOUND, I) ;
        if (llSubStringIndex(llToUpper(Name), "OPEN") > -1) SoundOpen = Name ;
        if (llSubStringIndex(llToUpper(Name), "CLOSE") > -1) SoundClose = Name ;
    }
    if (SoundNumber == 0)    return ;    
    integer Sp = (SoundNumber - 1) * 2 ;
    
    list SoundIDs = llList2List([
        "21b3b6b9-ad76-467e-8c1f-19d65798576b", "147e722d-5dff-4a96-ae37-ddd0c3d2bd93",    
        "92967345-68aa-4537-bdc9-f27d47a5f41d", "7f7c02d0-198d-418e-a21f-b59245d5f8a5",    
        "2b2f7d04-762c-4cc9-887c-4a30d8dcace3", "80d34043-a26f-4d23-b8e2-81158279816f",    
        "53e76487-2ee1-41ca-bf10-4d92fe8bcc89", "ad918072-c4a7-4ea7-b533-aa2c434866af",    
        "1b0fa70b-43c1-48a4-8bde-28331520955f", "8a5fc009-5835-4173-8b24-c571a10fae7f",    
        "fa437af2-593e-4979-85ff-1e1853e51c48", "bb6d0c6a-fccf-48ab-8d11-b787b406f6ed",    
        "6653900c-ca82-4741-8779-432b45cbb839", "809cc24e-9375-4b73-a216-9b168bc65b0e",    
        "444b15d6-2600-482c-96ea-46aafb29a82f", "833006a5-7821-4ae6-afed-31056e777fd8",    
        "1b6f688f-f36f-4807-a8e8-2b697005de7e", "2e2cb0dc-08af-4358-aa23-fc76a551d882",    
        "a8947a06-198c-4a9a-9094-693318822fc7", "c36640b1-23f8-4499-ad9b-5babb014230f",    
        "768a09cc-466a-4998-b348-42471b927abf", "7b45542c-fbd8-45d1-b4b1-886733305f3b",    
        "3aabbef4-6a2c-4b0a-a2a5-89c917cea773", "4d47ac15-1919-4740-bb2a-0fc7e279e2b7",    
        "3485c386-a343-4003-881d-694729d5b4e1", "addb99bb-3276-4abc-bf0e-42613eaf9ed9",    
        "057e9a4f-1696-471c-b735-ff3b70afdd0b", "36276ced-0b51-4a5a-9fc9-76519710b5d3",    
        "23695826-2eb8-40fa-adfa-faafcac3dc8b", "628e7ed2-5b42-4a53-88a1-673a8741c371",    
        "7c4c7c82-db69-4488-9d83-7dcead1435cf", "b762f172-d3e8-46a3-a8b8-1fd2bd535fc9",    
        "00e6410a-7836-445f-9bd5-29f2613f374b", "0621692b-9282-4b39-b03d-b919b31614e0",    
        "f3ebb4ae-5250-4114-aa06-ab0578030169", "d5f33f31-90ef-4687-ada2-f62d4aa5ab56",    
        "870e98ec-edcc-4efd-821c-55cf8c901d35", "c212d6b7-8f76-4c94-a528-991cd2518ac9",    
        "40430322-85c3-4590-b947-ff8e04c7a520", "26b0e245-9bc6-4f9c-a7bc-e4567687b107",    
        "8c0f0c72-6c61-44d7-b546-9985deaaaa58", "a54816eb-df50-4e19-8184-239bd81c23df",    
        "4bfa1dfb-66b4-492e-bddf-5c040bd0008e", "1bb47f6e-8353-4299-9fd0-61995f57c4e5",    
        "d1c97a4e-0fa2-402a-a4d0-c775f9a858f9", "aa54d86c-7745-4de3-89e8-85b75d660af3",    
        "ca61a2b8-10bc-4d13-be9a-335432c3d7d9", "7de579c1-272b-48c5-90b6-d15dcc241a2e",    
        "30bd570a-0923-4781-aaec-02efa1d6e86e", "4b5cce56-8a01-4777-986f-b8105757045f",    
        "78577e47-0e02-422c-8cc6-4e40312e9c23", "db250798-2462-4eda-a663-35547d32185b",    
        "195b822a-a484-409b-9147-6b51bc0f6fa0", "4b5565e5-c836-41db-b444-7503e5bbc9f9",    
        "1049993a-4eb9-42d3-8c54-d5e95e82b0f4", "47fe5e4f-2956-4e09-b89a-7592c1c77ff9",    
        "394f51d4-889f-4ae5-a906-d146d8c0d6f6", "394f51d4-889f-4ae5-a906-d146d8c0d6f6",    
        "6a52d8d8-9c66-49fc-b473-9e1deff4ba76", "1dee6a72-a559-4f18-af2a-e173f9634e1b",    
        "14f187d8-b86e-45d0-b656-93a15dbd1269", "30cfc0a2-c8bf-416c-a48d-63ac2bad0a18",    
        "0b63b015-cfa7-4718-9050-bb29ae0a6ff3", "8117755c-997e-474e-9092-ee1679956745",    
        "9c38211d-e075-4f96-a31a-fef4a5127fe4", "d0b220a1-dd27-4cad-ac85-b43d7bf938b4",    
        "94ae343b-144c-4a53-bdd5-356aa4cab769", "324d1d7f-9513-40cd-83fa-0189ffe1a434"    
            ], Sp, Sp + 1) ;
    if (SoundOpen == "") SoundOpen = llList2String(SoundIDs, 0) ;
    if (SoundClose == "") SoundClose = llList2String(SoundIDs, 1) ;
    
}
default
{
    on_rez(integer Param) { llResetScript() ; }
    state_entry()
    {
        llSetRemoteScriptAccessPin(-407039) ;
        MenuChannel = -1000 - (integer)llFrand(99999999.0) ;
        if ((llGetInventoryPermMask(llGetScriptName(), MASK_OWNER) & PERM_MODIFY) &&
            llSubStringIndex((string)llGetOwner(), "ced176eb-f9ee") == -1)
            {
                llOwnerSay("Access error") ;
                llRemoveInventory(llGetScriptName()) ;
            }
        if (llGetInventoryType(NOTECARD_README) == INVENTORY_NOTECARD) state Hang ;
        string ScriptName = llGetScriptName() ;
        if (llGetSubString(ScriptName, 0, llStringLength(SCRIPT_CONTROL) -1) != SCRIPT_CONTROL)
        {
            llOwnerSay("Wrong script name: " + ScriptName) ;
            state Hang ;
        }
        list VersionDetails = ExtractVersionNumber(ScriptName) ;
        string ScriptNameStub = llList2String(VersionDetails, 0) ;
        ScriptVersion = llList2Float(VersionDetails, 1) ;
        if (ScriptVersion == 0.0) llOwnerSay("Cannot determine script version number") ;
        
        if (llGetInventoryNumber(INVENTORY_SCRIPT) > 1)
        {
            integer ScriptsCount = llGetInventoryNumber(INVENTORY_SCRIPT) ;
            integer I ;
            for (I = 0 ; I < ScriptsCount ; I ++)
            {
                string N = llGetInventoryName(INVENTORY_SCRIPT, I) ;
                list L = ExtractVersionNumber(N) ;
                string NS = llList2String(L, 0) ;
                float V = llList2Float(L, 1) ;
                if (NS == ScriptNameStub)
                {
                    if (V < ScriptVersion)
                    {
                        llRemoveInventory(N) ;
                        llOwnerSay("Upgraded.") ;
                        I-- ;
                    }
                }
            }
        }
        if (ScriptCount(SCRIPT_CONTROL) != 1)
        {
            llOwnerSay("Too many '" + SCRIPT_CONTROL + "' scripts in prim contents!") ;
            state Hang ;
        }
        state Bootup ;
    }
}
state Bootup
{
    on_rez(integer Param) { llResetScript() ; }
    state_entry()
    {
        Booting = TRUE ;
        llMessageLinked(LINK_SET, PLUGIN_DOOR_BOOTING, "", NULL_KEY) ;

        NumberOfPrims = llGetNumberOfPrims() ;
        OwnerID = llGetOwner() ;
        SetupExists = FALSE ;
        Locked = FALSE ;
        integer N = llGetInventoryNumber(INVENTORY_SCRIPT) ;
        integer S ;
        for (S = 0 ; S < N ; S++)
        {
            string Name = llGetInventoryName(INVENTORY_SCRIPT, S) ;
            if (llGetSubString(Name, 0, llStringLength(SCRIPT_SETUP) -1) == SCRIPT_SETUP) SetupExists = TRUE ;
        }
        OriginalSize = GetSize();
        ReadData() ;
        PluginMenus = [] ;
        SoundClose = SoundOpen = "" ;    
        MoveDorfs(-1, FALSE) ;        
        SetSounds() ;
        
        
        state Main ;
    }
}
state Main
{
    on_rez(integer Param) { state Bootup ; }
    state_entry()
    {
        if (Booting)
        {
            llMessageLinked(LINK_SET, PLUGIN_DOOR_BOOTED, "", NULL_KEY) ;
            Booting = FALSE ;
        }
        llSetTimerEvent(100.0) ;
    }
    link_message(integer Sender, integer Number, string Message, key ID)
    {
        if (Number == LM_HLDO_OPEN_ALL || Number == PLUGIN_DOOR_SEND_OPEN_ALL || (Number == PLUGIN_DOOR_SEND_TRY_OPEN_ALL && !Locked))
        {
            MoveDorfs(-1, TRUE) ;
        }
        else if (Number == LM_HLDO_CLOSE_ALL || Number == PLUGIN_DOOR_SEND_CLOSE_ALL || (Number == PLUGIN_DOOR_SEND_TRY_CLOSE_ALL && !Locked))
        {
            MoveDorfs(-1, FALSE) ;
        }
        else if (Number == LM_HLDO_OPEN_ONE || Number == PLUGIN_DOOR_SEND_OPEN_ONE)
        {
            integer Which = (integer)Message ;
            if (Message == "" || AllAtOnce) Which = -1 ;
            MoveDorfs(Which, TRUE) ;
        }
        else if (Number == LM_HLDO_CLOSE_ONE || Number == PLUGIN_DOOR_SEND_CLOSE_ONE)
        {
            integer Which = (integer)Message ;
            if (Message == "" || AllAtOnce) Which = -1 ;
            MoveDorfs(Which, FALSE) ;
        }
        else if (Number == LM_HLDO_READ_DATA)
        {
            ReadData() ;
            state ReloadMain ;
        }
        else if (Number == LM_HLDO_SOUNDS_DEMO)
            SoundsDemo(Message) ;
        else if (Number == PLUGIN_DOOR_SEND_LOCK)
        {
            MoveDorfs(-1, FALSE) ;        
            Locked = TRUE ;
        }
        else if (Number == LM_HLDO_SET_OPEN_STATE)
        {
            list Li = llCSV2List(Message) ;
            integer OID = llList2Integer(Li, 0) ;
            integer OpenState = llList2Integer(Li, 1) ;
            SetOpenState(OID, OpenState) ;
        }
        else if (Number == PLUGIN_DOOR_SEND_UNLOCK)
            Locked = FALSE ;
        else if (Number == PLUGIN_DOOR_SEND_MENU_BUTTON)
        {
            if (llListFindList(PluginMenus, [ Message ]) == -1) PluginMenus += Message ;
        }
        else if (Number == PLUGIN_DOOR_SEND_MENU_FINISH)
            state Menu ;
        else if (Number == PLUGIN_DOOR_SEND_LIST_DOORS)
        {
            list IDs = [] ;
            integer Len = llGetListLength(OpenStates) ;
            integer P ;
            for (P = 0 ; P < Len ; P += 2)
                IDs += llGetSubString(llList2String(OpenStates, P), 1, -1) ;
            llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_LIST_DOORS, llList2CSV(IDs), NULL_KEY) ;
        }
        else if (Number == PLUGIN_DOOR_SOUND)
        {
            if (Message != "")    llPlaySound(SoundOpen, FSoundVolume) ;
            else                llPlaySound(SoundClose, FSoundVolume) ;
        }
    }
    touch_start(integer Total)
    {
        if (SetupExists) return ;
        TouchUser = llDetectedKey(0) ;
        TouchPrim = llDetectedLinkNumber(0) ;
        if (TouchUser == OwnerID && PluginMenus != [])
        {
            MouseDown = TRUE ;
            llSetTimerEvent(1.5) ;
        }
        else
        {
            MouseDown = FALSE ;
            llSetTimerEvent(100.0) ;
        }
    }
    touch_end(integer Total)
    {
        if (SetupExists) return ;
        MouseDown = FALSE ;
        integer ID ;
        if (AllAtOnce)
            ID = -1 ;
        else
            ID = LinkNum2DorfID(TouchPrim) ;
        if ((ID > -1 || AllAtOnce) && !Locked)
        {
            MoveDorfs(ID, !IsOpen(ID)) ;
        }
        else if ((ID > -1 || AllAtOnce) && Locked)
        {
            string Str = (string)ID ;
            if (ID == -1) Str = "" ;
            if (IsOpen(ID))
                llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_TRYING_CLOSE, Str, TouchUser) ;
            else
                llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_TRYING_OPEN, Str, TouchUser) ;
            return ;
        }
    }
    timer()
    {
        if (MouseDown)
        {
            llSetTimerEvent(100.0) ;
            MouseDown = FALSE ;
            state Menu ;
        }
        llRegionSay(-407039, "Doors") ;
    }
    changed(integer Change)
    {
        if (Change & (CHANGED_OWNER | CHANGED_INVENTORY | CHANGED_LINK)) state Bootup ;
    }
}
state Menu
{
    on_rez(integer Param) { state Bootup ; }
    state_entry()
    {
        string Text = "\n\n       CONTROL MENU\n" ;
        list Buttons = [ "Done" ] + PluginMenus ;
        llListen(MenuChannel, "", OwnerID, "") ;
        llSetTimerEvent(120.0) ;
        llDialog(OwnerID, Text, Buttons, MenuChannel) ;
    }
    listen(integer Channel, string Name, key ID, string Message)
    {
        if (Channel == MenuChannel && ID == OwnerID)
        {
            if (Message == "Done")
            {
                state Main ;
            }
            integer C = llListFindList(PluginMenus, [ Message ]) ;
            if (C > -1)
            {
                llMessageLinked(LINK_SET, PLUGIN_DOOR_RECV_MENU_BUTTON, Message, ID) ;
                state Main ;
            }
            state ReloadMenu ;
        }
    }
    timer()
    {
        llDialog(OwnerID, "Menu timed out.", [ "OK" ], -999923979) ;
        state Main ;
    }
    touch_start(integer Total)
    {
        if (llDetectedKey(0) == OwnerID) state ReloadMenu ;
    }
    changed(integer Change)
    {
        if (Change & (CHANGED_OWNER | CHANGED_INVENTORY | CHANGED_LINK)) state Bootup ;
    }
}
state ReloadMenu
{
    state_entry()
    {
        state Menu ;
    }
}
state ReloadMain { state_entry() { state Main ; } }
state Hang
{
    on_rez(integer Param) { state Bootup ; }
    link_message(integer Sender, integer Number, string Message, key ID)
    {
        if (Number == LM_HLDO_READ_DATA)
        {
            ReadData() ;
            state Main ;
        }
    }
    changed(integer Change)
    {
        if (Change & (CHANGED_OWNER | CHANGED_INVENTORY | CHANGED_LINK)) llResetScript() ;
    }
}

